/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import com.clarkparsia.pellint.lintpattern.LintPattern;
import com.clarkparsia.pellint.lintpattern.LintPatternLoader;
import com.clarkparsia.pellint.lintpattern.axiom.AxiomLintPattern;
import com.clarkparsia.pellint.lintpattern.ontology.OntologyLintPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.model.OntologyLints;
import com.clarkparsia.pellint.model.Severity;
import com.clarkparsia.pellint.rdfxml.OWLSyntaxChecker;
import com.clarkparsia.pellint.rdfxml.RDFLints;
import com.clarkparsia.pellint.rdfxml.RDFModel;
import com.clarkparsia.pellint.rdfxml.RDFModelReader;
import com.clarkparsia.pellint.rdfxml.RDFModelWriter;
import com.clarkparsia.pellint.util.CollectionUtil;
import com.clarkparsia.pellint.util.IllegalPellintArgumentException;
import com.hp.hpl.jena.rdf.model.Statement;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.utils.FileUtils;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChangeException;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLOntologySetProvider;
import org.semanticweb.owl.model.OWLOntologyStorageException;
import org.semanticweb.owl.model.UnknownOWLOntologyException;
import org.semanticweb.owl.util.OWLOntologyImportsClosureSetProvider;
import org.semanticweb.owl.util.OWLOntologyMerger;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOption;
import pellet.PelletCmdOptionArg;
import pellet.PelletCmdOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pellint
extends PelletCmdApp {
    private static final String CONFIGURATION_PROPERTY_NAME = "pellint.configuration";
    private static final String DEFAULT_CONFIGURATION_FILE_NAME = "pellint.properties";
    private static final URI MERGED_ONTOLOGY_URI = URI.create("tag:clarkparsia.com,2008:pellint:merged");
    private static final Logger LOGGER = Logger.getLogger(Pellint.class.getName());
    private boolean m_DoRDF = true;
    private boolean m_DoOWL = true;
    private boolean m_DoRootOnly = false;
    private String m_InputOntologyPath;
    private String m_OutputOntologyPath;
    private PrintStream m_Out = System.out;

    public Pellint(String[] arg) {
        super(arg);
        String only = this.options.getOption("only").getValueAsString();
        this.setDoRDF(false);
        this.setDoOWL(false);
        if (only.equalsIgnoreCase("RDF&OWL") || only.equalsIgnoreCase("RDF & OWL") || only.equalsIgnoreCase("RDF")) {
            this.setDoRDF(true);
        }
        if (only.equalsIgnoreCase("RDF&OWL") || only.equalsIgnoreCase("RDF & OWL") || only.equalsIgnoreCase("OWL")) {
            this.setDoOWL(true);
        }
        this.setDoRootOnly(this.options.getOption("root-only").getValueAsBoolean());
        if (this.getInputFiles().length > 1) {
            throw new PelletCmdException("lint doesn't handle multiple input files");
        }
        this.setInputOntologyPath(this.getInputFiles()[0]);
        this.setOutputOntologyPath(this.options.getOption("fix").getValueAsString());
    }

    @Override
    public String getAppId() {
        return "Pellint: Lint tool for OWL ontologies";
    }

    @Override
    public String getAppCmd() {
        String s1 = "pellet lint [options] <file URI> ...\n";
        String s2 = "Note: pellet lint <file URI> without arguments prints the lint report to STDOUT.";
        String lb = System.getProperty("line.separator");
        String s = s1 + lb + lb + s2;
        return s;
    }

    @Override
    public PelletCmdOptions getOptions() {
        PelletCmdOptions options = new PelletCmdOptions();
        PelletCmdOption option = new PelletCmdOption("fix");
        option.setShortOption("f");
        option.setIsMandatory(false);
        option.setType("File");
        option.setDescription("Apply any applicable fixes to ontology lints and save a new ontology to File.");
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        option = new PelletCmdOption("root-only");
        option.setIsMandatory(false);
        option.setDefaultValue(false);
        option.setType("boolean");
        option.setDescription("Lint the root ontology only; ignore its imports.");
        option.setArg(PelletCmdOptionArg.NONE);
        options.add(option);
        option = new PelletCmdOption("only");
        option.setShortOption("o");
        option.setIsMandatory(false);
        option.setDefaultValue("both RDF & OWL");
        option.setType("RDF | OWL");
        option.setDescription("Analyze only RDF declarations or OWL axioms, not both.");
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        return options;
    }

    public void setDoRDF(boolean v) {
        this.m_DoRDF = v;
    }

    public void setDoOWL(boolean v) {
        this.m_DoOWL = v;
    }

    public void setDoRootOnly(boolean v) {
        this.m_DoRootOnly = v;
    }

    public void setInputOntologyPath(String v) {
        this.m_InputOntologyPath = v;
    }

    public void setOutputOntologyPath(String v) {
        this.m_OutputOntologyPath = v;
    }

    public void setPrintStream(PrintStream v) {
        this.m_Out = v;
    }

    public static OntologyLints lint(List<AxiomLintPattern> axiomLintPatterns, List<OntologyLintPattern> ontologyLintPatterns, OWLOntology ontology) {
        OntologyLints ontologyLints = new OntologyLints(ontology);
        for (OWLAxiom axiom : ontology.getAxioms()) {
            for (AxiomLintPattern pattern : axiomLintPatterns) {
                Lint lint = pattern.match(ontology, axiom);
                if (lint == null) continue;
                ontologyLints.addLint(pattern, lint);
            }
        }
        for (OntologyLintPattern pattern : ontologyLintPatterns) {
            List<Lint> lints = pattern.match(ontology);
            if (lints.isEmpty()) continue;
            ontologyLints.addLints(pattern, lints);
        }
        ontologyLints.sort((Comparator<? super Lint>)new Comparator<Lint>(){

            @Override
            public int compare(Lint lint0, Lint lint1) {
                Severity severity0 = lint0.getSeverity();
                Severity severity1 = lint1.getSeverity();
                if (severity0 != null && severity1 != null) {
                    return -severity0.compareTo(severity1);
                }
                Set<OWLClass> classes0 = lint0.getParticipatingClasses();
                Set<OWLClass> classes1 = lint1.getParticipatingClasses();
                if (classes0 == null || classes1 == null) {
                    return 0;
                }
                if (classes0.size() != 1 || classes1.size() != 1) {
                    return 0;
                }
                URI uri0 = classes0.iterator().next().getURI();
                URI uri1 = classes1.iterator().next().getURI();
                if (uri0 == null || uri1 == null) {
                    return 0;
                }
                String fragment0 = uri0.getFragment();
                String fragment1 = uri1.getFragment();
                if (fragment0 == null || fragment1 == null) {
                    return 0;
                }
                return fragment0.compareTo(fragment1);
            }
        });
        return ontologyLints;
    }

    @Override
    public void run() {
        try {
            if (this.m_InputOntologyPath == null) {
                throw new IllegalPellintArgumentException("Input ontology is not specified");
            }
            if (this.m_DoRDF) {
                this.runLintForRDFXML();
            }
            if (this.m_DoOWL) {
                this.runLintForOWL();
            }
        }
        catch (IllegalPellintArgumentException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (OWLOntologyCreationException e) {
            e.printStackTrace();
        }
        catch (OWLOntologyStorageException e) {
            e.printStackTrace();
        }
        catch (OWLOntologyChangeException e) {
            e.printStackTrace();
        }
    }

    private void runLintForRDFXML() throws MalformedURLException, IOException {
        RDFModelReader reader = new RDFModelReader();
        RDFModel rootModel = null;
        try {
            rootModel = reader.read(this.m_InputOntologyPath, !this.m_DoRootOnly);
        }
        catch (Exception e) {
            throw new PelletCmdException(e);
        }
        OWLSyntaxChecker checker = new OWLSyntaxChecker();
        RDFLints lints = checker.validate(rootModel);
        this.m_Out.println(lints);
        if (this.m_OutputOntologyPath != null && !this.m_DoOWL) {
            List<Statement> missingStmts = lints.getMissingStatements();
            if (!missingStmts.isEmpty()) {
                rootModel.addAllStatementsWithExistingBNodesOnly(missingStmts);
                RDFModelWriter writer = new RDFModelWriter();
                writer.writePretty(new FileOutputStream(new File(this.m_OutputOntologyPath)), rootModel);
                this.m_Out.println("Applied fixes and saved to " + this.m_OutputOntologyPath + ".");
            } else {
                this.m_Out.println("Nothing to fix.");
            }
        }
    }

    private void runLintForOWL() throws OWLOntologyCreationException, OWLOntologyChangeException, UnknownOWLOntologyException, OWLOntologyStorageException {
        LintPatternLoader patternLoader = new LintPatternLoader(Pellint.loadProperties());
        List<AxiomLintPattern> axiomLintPatterns = patternLoader.getAxiomLintPatterns();
        List<OntologyLintPattern> ontologyLintPatterns = patternLoader.getOntologyLintPatterns();
        this.logLoadedPatterns(axiomLintPatterns, ontologyLintPatterns);
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology rootOntology = null;
        try {
            String inputOntologyURI = FileUtils.toURI(this.m_InputOntologyPath);
            rootOntology = manager.loadOntology(URI.create(inputOntologyURI));
        }
        catch (Exception e) {
            throw new PelletCmdException(e);
        }
        OntologyLints rootOntologyLints = Pellint.lint(axiomLintPatterns, ontologyLintPatterns, rootOntology);
        this.m_Out.println(rootOntologyLints);
        if (!this.m_DoRootOnly) {
            Set<OWLOntology> importClosures = CollectionUtil.copy(manager.getImportsClosure(rootOntology));
            importClosures.remove(rootOntology);
            if (importClosures.isEmpty()) {
                this.m_Out.println("\n" + rootOntology.getURI() + " does not import other ontologies.");
            } else {
                for (OWLOntology importedOntology : importClosures) {
                    OntologyLints importedOntologyLints = Pellint.lint(axiomLintPatterns, ontologyLintPatterns, importedOntology);
                    this.m_Out.println(importedOntologyLints);
                }
                OWLOntology mergedImportClosure = Pellint.buildMergedImportClosure(manager, rootOntology);
                OntologyLints mergedOntologyLints = Pellint.lint(axiomLintPatterns, ontologyLintPatterns, mergedImportClosure);
                mergedOntologyLints.setRootOntology(rootOntology);
                this.m_Out.println(mergedOntologyLints);
            }
        }
        if (this.m_OutputOntologyPath != null) {
            if (!rootOntologyLints.isEmpty()) {
                rootOntologyLints.applyFix(manager);
                manager.saveOntology(rootOntologyLints.getOntology(), new File(this.m_OutputOntologyPath).toURI());
                this.m_Out.println("Applied fixes and saved the new ontology to " + this.m_OutputOntologyPath + ".");
            } else {
                this.m_Out.println("No lints found for " + rootOntology.getURI() + " - nothing to fix.");
            }
        }
    }

    private void logLoadedPatterns(List<AxiomLintPattern> axiomLintPatterns, List<OntologyLintPattern> ontologyLintPatterns) {
        if (!LOGGER.isLoggable(Level.FINE)) {
            return;
        }
        List<AxiomLintPattern> allPatterns = CollectionUtil.copy(axiomLintPatterns);
        allPatterns.addAll(ontologyLintPatterns);
        Collections.sort(allPatterns, new Comparator<LintPattern>(){

            @Override
            public int compare(LintPattern p0, LintPattern p1) {
                return p0.getName().compareTo(p1.getName());
            }
        });
        LOGGER.fine("Loaded lint patterns:");
        for (LintPattern lintPattern : allPatterns) {
            StringBuilder builder = new StringBuilder();
            builder.append("  ");
            if (lintPattern.isFixable()) {
                builder.append("[fixable] ");
            } else {
                builder.append("          ");
            }
            builder.append(lintPattern.getName());
            LOGGER.fine(builder.toString());
        }
    }

    private static OWLOntology buildMergedImportClosure(OWLOntologyManager manager, OWLOntology rootOntology) throws OWLOntologyCreationException, OWLOntologyChangeException {
        OWLOntologyImportsClosureSetProvider importClosureSetProvider = new OWLOntologyImportsClosureSetProvider(manager, rootOntology);
        OWLOntologyMerger merger = new OWLOntologyMerger((OWLOntologySetProvider)importClosureSetProvider);
        return merger.createMergedOntology(manager, MERGED_ONTOLOGY_URI);
    }

    private static Properties loadProperties() {
        Properties properties = new Properties();
        String configFile = System.getProperty(CONFIGURATION_PROPERTY_NAME);
        URL configURL = null;
        if (configFile == null) {
            configURL = Pellint.class.getClassLoader().getResource(DEFAULT_CONFIGURATION_FILE_NAME);
            if (configURL == null) {
                LOGGER.severe("Cannot find Pellint configuration file pellint.properties");
            }
        } else {
            try {
                configURL = new URL(configFile);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                configURL = Pellint.class.getClassLoader().getResource(configFile);
            }
            if (configURL == null) {
                LOGGER.severe("Cannot find Pellint configuration file " + configFile);
            }
        }
        if (configURL != null) {
            try {
                properties.load(configURL.openStream());
            }
            catch (FileNotFoundException e) {
                LOGGER.severe("Pellint configuration file cannot be found");
            }
            catch (IOException e) {
                LOGGER.severe("I/O error while reading Pellet configuration file");
            }
        }
        return properties;
    }

    public static void main(String[] args) {
        Pellint app = new Pellint(args);
        app.run();
    }
}

