/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFReaderF;
import com.hp.hpl.jena.shared.NoReaderForLangException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.mindswap.pellet.KBLoader;
import org.mindswap.pellet.KRSSLoader;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.jena.JenaLoader;
import org.mindswap.pellet.owlapi.OWLAPILoader;
import pellet.PelletCmdException;
import pellet.PelletCmdOption;
import pellet.PelletCmdOptionArg;
import pellet.PelletCmdOptions;

public abstract class PelletCmdApp {
    public static final Logger logger = Logger.getLogger(PelletCmdApp.class.getName());
    private static final String LINE_BREAK = System.getProperty("line.separator");
    private static final RDFReaderF READER_FACTORY = ModelFactory.createDefaultModel();
    protected String[] args;
    protected String appId;
    protected String appCmd;
    protected String help;
    protected PelletCmdOptions options;
    protected PrintStream out = System.out;
    protected PrintStream err = System.err;
    private List<String> inputFiles;
    private boolean acceptNoArgs;
    protected KBLoader loader;

    public PelletCmdApp(String[] args) {
        this(args, false);
    }

    public PelletCmdApp(String[] args, boolean acceptNoArgs) {
        this.args = args;
        this.acceptNoArgs = acceptNoArgs;
        this.options = this.getOptions();
        this.appId = this.getAppId();
        this.appCmd = this.getAppCmd();
        this.inputFiles = new ArrayList<String>();
        this.init();
        this.buildHelp();
        this.parseCmdLine();
    }

    public abstract String getAppId();

    public abstract String getAppCmd();

    public abstract PelletCmdOptions getOptions();

    public abstract void run();

    protected String getMandatoryOptions() {
        StringBuffer ret = new StringBuffer();
        Set<PelletCmdOption> mandatory = this.options.getMandatoryOptions();
        for (PelletCmdOption option : mandatory) {
            ret.append("-" + option.getShortOption() + " arg ");
        }
        return ret.toString();
    }

    public PelletCmdOption getLoaderOption() {
        PelletCmdOption option = new PelletCmdOption("loader");
        option.setShortOption("l");
        option.setDescription("Use Jena, OWLAPI, or KRSS to load the ontology");
        option.setType("Jena | OWLAPI | KRSS");
        option.setDefaultValue("OWLAPI");
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        return option;
    }

    public PelletCmdOption getInputFormatOption() {
        PelletCmdOption option = new PelletCmdOption("input-format");
        option.setDefaultValue(null);
        option.setDescription("Format of the input file (valid only for the Jena loader). Default behaviour is to guess the input format based on the file extension.");
        option.setType("RDF/XML | N3 | N-TRIPLE");
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        return option;
    }

    protected KnowledgeBase getKB() {
        KBLoader loader = this.getLoader();
        try {
            return loader.createKB(this.getInputFiles());
        }
        catch (RuntimeException e) {
            throw new PelletCmdException(e);
        }
    }

    protected KBLoader getLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        String loaderName = this.options.getOption("loader").getValueAsString();
        return this.getLoader(loaderName);
    }

    protected KBLoader getLoader(String loaderName) {
        if (loaderName.equalsIgnoreCase("Jena")) {
            this.loader = new JenaLoader();
        } else if (loaderName.equalsIgnoreCase("OWLAPI")) {
            this.loader = new OWLAPILoader();
        } else if (loaderName.equalsIgnoreCase("KRSS")) {
            this.loader = new KRSSLoader();
        } else {
            throw new PelletCmdException("Unknown loader: " + loaderName);
        }
        PelletCmdOption option = this.options.getOption("input-format");
        if (option != null && this.loader instanceof JenaLoader) {
            String inputFormat = option.getValueAsString();
            try {
                if (inputFormat != null) {
                    READER_FACTORY.getReader(inputFormat.toUpperCase());
                    ((JenaLoader)this.loader).setInputFormat(inputFormat);
                }
            }
            catch (NoReaderForLangException e) {
                throw new PelletCmdException("Unrecognized input format: " + inputFormat);
            }
        }
        return this.loader;
    }

    protected String[] getInputFiles() {
        return this.inputFiles.toArray(new String[0]);
    }

    private void init() {
        PelletCmdOption option = new PelletCmdOption("help");
        option.setShortOption("h");
        option.setDescription("Print this message");
        option.setDefaultValue(false);
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.NONE);
        this.options.add(option);
    }

    private void buildHelp() {
        StringBuffer u = new StringBuffer();
        HelpTable table = new HelpTable(this.options);
        u.append(this.appId + LINE_BREAK + LINE_BREAK);
        u.append("Usage: " + this.appCmd + LINE_BREAK + LINE_BREAK);
        u.append(table.print() + LINE_BREAK);
        this.help = u.toString();
    }

    private void parseCmdLine() {
        int i;
        if (!this.acceptNoArgs && this.args.length == 0) {
            this.help();
        }
        block5: for (i = 0; i < this.args.length; ++i) {
            String arg = this.args[i];
            if (arg.equals("--")) {
                return;
            }
            if (arg.charAt(0) != '-') break;
            PelletCmdOption option = this.options.getOption(arg = arg.charAt(1) == '-' ? arg.substring(2) : arg.substring(1));
            if (option == null) {
                throw new PelletCmdException("Unrecognized option: " + arg);
            }
            if (option.getLongOption().equals("help")) {
                this.help();
            }
            PelletCmdOptionArg optionArg = option.getArg();
            boolean nextIsArg = this.args.length > i + 1 && this.args[i + 1].charAt(0) != '-';
            switch (optionArg) {
                case NONE: {
                    option.setValue(true);
                    continue block5;
                }
                case REQUIRED: {
                    if (!nextIsArg) {
                        throw new PelletCmdException("Option <" + option.getLongOption() + "> requires an argument");
                    }
                    option.setValue(this.args[++i]);
                    continue block5;
                }
                case OPTIONAL: {
                    if (!nextIsArg) continue block5;
                    option.setValue(this.args[++i]);
                    continue block5;
                }
                default: {
                    throw new PelletCmdException("Unrecognized option argument: " + (Object)((Object)optionArg));
                }
            }
        }
        for (PelletCmdOption option : this.options.getOptions()) {
            if (!option.isMandatory() || option.getValue() != null) continue;
            throw new PelletCmdException("Option <" + option.getLongOption() + "> is mandatory");
        }
        while (i < this.args.length) {
            this.inputFiles.add(this.args[i]);
            ++i;
        }
        if (!this.acceptNoArgs && this.inputFiles.isEmpty()) {
            throw new PelletCmdException("No input file given");
        }
    }

    private void help() {
        System.out.println(this.help);
        System.exit(0);
    }

    private class HelpTable {
        private final String LINE_BREAK = System.getProperty("line.separator");
        private PelletCmdOptions options;
        private int maxLineWidth = 80;
        private int indent = 5;

        public HelpTable(PelletCmdOptions options) {
            this.options = options;
        }

        public String print() {
            StringBuffer ret = new StringBuffer();
            ret.append("Argument description:" + this.LINE_BREAK + this.LINE_BREAK);
            int i = 0;
            boolean last = false;
            for (PelletCmdOption option : this.options.getOptions()) {
                if (++i == this.options.getOptions().size()) {
                    last = true;
                }
                String longOption = option.getLongOption();
                String shortOption = option.getShortOption();
                String type = option.getType();
                PelletCmdOptionArg arg = option.getArg();
                String description = option.getDescription();
                String defaultValue = new String();
                if (option.getDefaultValue() != null) {
                    defaultValue = option.getDefaultValue().toString();
                }
                String firstLine = this.firstLine(shortOption, longOption, type, arg);
                String secondLine = this.secondLine(description, defaultValue);
                ret.append(firstLine);
                ret.append(this.LINE_BREAK);
                ret.append(secondLine);
                if (last) continue;
                ret.append(this.LINE_BREAK + this.LINE_BREAK);
            }
            return ret.toString();
        }

        private String fill(int n) {
            return this.draw(" ", n);
        }

        private String draw(String c, int n) {
            StringBuffer ret = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                ret.append(c);
            }
            return ret.toString();
        }

        private String firstLine(String shortOption, String longOption, String type, PelletCmdOptionArg arg) {
            StringBuffer ret = new StringBuffer();
            ret.append("--" + longOption);
            if (shortOption != null) {
                ret.append(", -" + shortOption);
            }
            ret.append(" ");
            if (type != null) {
                if (arg.equals((Object)PelletCmdOptionArg.OPTIONAL) && !type.startsWith("[") && !type.startsWith("(")) {
                    ret.append("[" + type + "] ");
                } else if (arg.equals((Object)PelletCmdOptionArg.REQUIRED) && !type.startsWith("[") && !type.startsWith("(")) {
                    ret.append("(" + type + ") ");
                }
            }
            return ret.toString();
        }

        private String secondLine(String description, String defaultValue) {
            int colStart;
            int colLength = colStart = this.indent;
            StringBuffer ret = new StringBuffer();
            if (description == null && defaultValue == null) {
                return ret.toString();
            }
            String tokens = defaultValue != null && defaultValue.length() != 0 && !defaultValue.equals("true") && !defaultValue.equals("false") ? description + " (Default: " + defaultValue + ")" : description;
            ret.append(this.fill(colStart));
            StringTokenizer tokenizer = new StringTokenizer(tokens);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if ((colLength = colLength + token.length() + 1) > this.maxLineWidth) {
                    ret.append(this.LINE_BREAK + this.fill(colStart));
                    colLength = colStart + token.length() + 1;
                }
                ret.append(token + " ");
            }
            return ret.toString();
        }
    }
}

