/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import com.clarkparsia.modularity.ModularityUtils;
import com.clarkparsia.owlapi.OntologyUtils;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.mindswap.pellet.owlapi.OWLAPILoader;
import org.semanticweb.owl.io.OWLOntologyOutputTarget;
import org.semanticweb.owl.io.RDFXMLOntologyFormat;
import org.semanticweb.owl.io.StreamOutputTarget;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyFormat;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOption;
import pellet.PelletCmdOptionArg;
import pellet.PelletCmdOptions;
import uk.ac.manchester.cs.owl.modularity.ModuleType;

public class PelletModularity
extends PelletCmdApp {
    private OWLAPILoader loader;
    private ModuleType moduleType;
    private String[] entityNames;

    public PelletModularity(String[] args) {
        super(args);
    }

    public String getAppCmd() {
        return "pellet modularity " + this.getMandatoryOptions() + "[options] <file URI>...";
    }

    public String getAppId() {
        return "PelletModularity: Extract ontology modules for classes";
    }

    public PelletCmdOptions getOptions() {
        PelletCmdOptions options = new PelletCmdOptions();
        PelletCmdOption option = new PelletCmdOption("signature");
        option.setShortOption("s");
        option.setType("Space separated list");
        option.setDescription("One or more entity URI(s) or local name(s) to be extracted as a module. Example: \"Animal Wildlife Rainforest\"");
        option.setIsMandatory(true);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        option = new PelletCmdOption("type");
        option.setShortOption("t");
        option.setType("lower| upper | upper-of-lower | lower-of-upper");
        option.setDefaultValue("lower");
        option.setDescription("The type of the module that will be extracted. See http://bit.ly/ontology-module-types for an explanation of the module types.");
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        return options;
    }

    public void run() {
        this.loadEntityNames();
        this.loadModuleType();
        this.loadOntology();
        this.extractModule();
    }

    public static void main(String[] args) {
        PelletModularity app = new PelletModularity(args);
        app.run();
    }

    private void loadOntology() {
        this.loader = (OWLAPILoader)this.getLoader("OWLAPI");
        this.getKB();
    }

    private void loadEntityNames() {
        String signature = this.options.getOption("signature").getValueAsString();
        if (signature == null) {
            throw new PelletCmdException("No signature provided");
        }
        this.entityNames = signature.split(" ");
        if (this.entityNames.length == 0) {
            throw new PelletCmdException("No signature provided");
        }
    }

    private void loadModuleType() {
        String type = this.options.getOption("type").getValueAsString();
        if (type.equalsIgnoreCase("lower")) {
            this.moduleType = ModuleType.TOP;
        } else if (type.equalsIgnoreCase("upper")) {
            this.moduleType = ModuleType.BOT;
        } else if (type.equalsIgnoreCase("upper-of-lower")) {
            this.moduleType = ModuleType.BOT_OF_TOP;
        } else if (type.equalsIgnoreCase("lower-of-upper")) {
            this.moduleType = ModuleType.TOP_OF_BOT;
        } else {
            throw new PelletCmdException("Unknown module type: " + type);
        }
    }

    private void extractModule() {
        HashSet<OWLEntity> entities = new HashSet<OWLEntity>();
        for (String entityName : this.entityNames) {
            OWLEntity entity = OntologyUtils.findEntity((String)entityName, (Set)this.loader.getOntologies());
            if (entity == null) {
                throw new PelletCmdException("Entity not found in ontology: " + entityName);
            }
            entities.add(entity);
        }
        Set module = ModularityUtils.extractModule((Set)this.loader.getOntologies(), entities, (ModuleType)this.moduleType);
        try {
            OWLOntology moduleOnt = this.loader.getManager().createOntology(module);
            this.loader.getManager().saveOntology(moduleOnt, (OWLOntologyFormat)new RDFXMLOntologyFormat(), (OWLOntologyOutputTarget)new StreamOutputTarget((OutputStream)System.out));
        }
        catch (OWLException e) {
            throw new RuntimeException(e);
        }
    }
}

