/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.taxonomy.printer.ClassTreePrinter;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOptions;

public class PelletRealize
extends PelletCmdApp {
    public String getAppCmd() {
        return "pellet realize " + this.getMandatoryOptions() + "[options] <file URI>...";
    }

    public String getAppId() {
        return "PelletRealize: Compute and display the most specific instances for each class";
    }

    public PelletCmdOptions getOptions() {
        PelletCmdOptions options = this.getGlobalOptions();
        options.add(this.getLoaderOption());
        options.add(this.getIgnoreImportsOption());
        options.add(this.getInputFormatOption());
        return options;
    }

    public void run() {
        KnowledgeBase kb = this.getKB();
        this.startTask("consistency check");
        boolean isConsistent = kb.isConsistent();
        this.finishTask("consistency check");
        if (!isConsistent) {
            throw new PelletCmdException("Ontology is inconsistent, run \"pellet explain\" to get the reason");
        }
        this.startTask("classification");
        kb.classify();
        this.finishTask("classification");
        this.startTask("realization");
        kb.realize();
        this.finishTask("realization");
        ClassTreePrinter printer = new ClassTreePrinter();
        printer.print(kb.getTaxonomy());
    }
}

