/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.owlapi.OntologyUtils;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.owlapi.OWLAPILoader;
import org.mindswap.pellet.taxonomy.POTaxonomyBuilder;
import org.mindswap.pellet.taxonomy.SubsumptionComparator;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.printer.ClassTreePrinter;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.PartialOrderComparator;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLObjectProperty;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOption;
import pellet.PelletCmdOptionArg;
import pellet.PelletCmdOptions;

public class PelletTransTree
extends PelletCmdApp {
    private String propertyName;
    private boolean showClasses;
    private boolean showIndividuals;

    public String getAppId() {
        return "PelletTransTree: Compute a transitive-tree closure";
    }

    public String getAppCmd() {
        return "pellet trans-tree " + this.getMandatoryOptions() + "[options] <file URI>...";
    }

    public PelletCmdOptions getOptions() {
        this.showClasses = true;
        this.showIndividuals = false;
        PelletCmdOptions options = this.getGlobalOptions();
        PelletCmdOption option = new PelletCmdOption("property");
        option.setShortOption("p");
        option.setType("<URI>");
        option.setDescription("The part-of (transitive) property");
        option.setIsMandatory(true);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        option = new PelletCmdOption("classes");
        option.setShortOption("c");
        option.setDescription("Show parts hierarchy for classes");
        option.setDefaultValue(this.showClasses);
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.NONE);
        options.add(option);
        option = new PelletCmdOption("individuals");
        option.setShortOption("i");
        option.setDescription("Show parts hierarchy for individuals");
        option.setDefaultValue(this.showIndividuals);
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.NONE);
        options.add(option);
        return options;
    }

    public void run() {
        this.propertyName = this.options.getOption("property").getValueAsString();
        OWLAPILoader loader = new OWLAPILoader();
        KnowledgeBase kb = loader.createKB(this.getInputFiles());
        OWLEntity entity = OntologyUtils.findEntity((String)this.propertyName, (Set)loader.getOntologies());
        if (entity == null) {
            throw new PelletCmdException("Property not found: " + this.propertyName);
        }
        if (!(entity instanceof OWLObjectProperty)) {
            throw new PelletCmdException("Not an object property: " + this.propertyName);
        }
        if (!((OWLObjectProperty)entity).isTransitive(loader.getOntologies())) {
            throw new PelletCmdException("Not a transitive property: " + this.propertyName);
        }
        ATermAppl p = ATermUtils.makeTermAppl((String)entity.getURI().toString());
        POTaxonomyBuilder builder = null;
        if (this.options.getOption("individuals").getValueAsBoolean()) {
            builder = new POTaxonomyBuilder(kb, (PartialOrderComparator)new PartIndividualsComparator(kb, p));
            for (ATermAppl individual : kb.getIndividuals()) {
                if (ATermUtils.isBnode((ATermAppl)individual)) continue;
                builder.classify(individual);
            }
        } else {
            builder = new POTaxonomyBuilder(kb, (PartialOrderComparator)new PartClassesComparator(kb, p));
            builder.classify();
        }
        Taxonomy taxonomy = builder.getTaxonomy();
        ClassTreePrinter printer = new ClassTreePrinter();
        printer.print(taxonomy);
    }

    private static class PartIndividualsComparator
    extends SubsumptionComparator {
        private ATermAppl p;

        public PartIndividualsComparator(KnowledgeBase kb, ATermAppl p) {
            super(kb);
            this.p = p;
        }

        protected boolean isSubsumedBy(ATermAppl a, ATermAppl b) {
            return this.kb.hasPropertyValue(a, this.p, b);
        }
    }

    private static class PartClassesComparator
    extends SubsumptionComparator {
        private ATermAppl p;

        public PartClassesComparator(KnowledgeBase kb, ATermAppl p) {
            super(kb);
            this.p = p;
        }

        protected boolean isSubsumedBy(ATermAppl a, ATermAppl b) {
            ATermAppl someB = ATermUtils.makeSomeValues((ATerm)this.p, (ATerm)b);
            return this.kb.isSubClassOf(a, someB);
        }
    }
}

