/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import aterm.ATermAppl;
import java.util.Iterator;
import java.util.TreeSet;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.utils.Comparators;
import org.mindswap.pellet.utils.QNameProvider;
import org.mindswap.pellet.utils.progress.ProgressMonitor;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOptions;

public class PelletUnsatisfiable
extends PelletCmdApp {
    public String getAppCmd() {
        return "pellet unsatisfiable " + this.getMandatoryOptions() + "[options] <file URI>...";
    }

    public String getAppId() {
        return "PelletUnsatisfiable: Find the unsatisfiable classes in the ontology";
    }

    public PelletCmdOptions getOptions() {
        PelletCmdOptions options = this.getGlobalOptions();
        options.add(this.getLoaderOption());
        options.add(this.getIgnoreImportsOption());
        options.add(this.getInputFormatOption());
        return options;
    }

    public void run() {
        KnowledgeBase kb = this.getKB();
        this.startTask("consistency check");
        boolean isConsistent = kb.isConsistent();
        this.finishTask("consistency check");
        if (!isConsistent) {
            throw new PelletCmdException("Ontology is inconsistent, run \"pellet explain\" to get the reason");
        }
        QNameProvider qnames = new QNameProvider();
        TreeSet<String> unsatisfiableClasses = new TreeSet<String>(Comparators.stringComparator);
        ProgressMonitor monitor = PelletOptions.USE_CLASSIFICATION_MONITOR.create();
        monitor.setProgressTitle("Finding unsatisfiable");
        monitor.setProgressLength(kb.getClasses().size());
        this.startTask("find unsatisfiable");
        monitor.taskStarted();
        Iterator i = kb.getClasses().iterator();
        while (i.hasNext()) {
            monitor.incrementProgress();
            ATermAppl c = (ATermAppl)i.next();
            if (kb.isSatisfiable(c)) continue;
            unsatisfiableClasses.add(qnames.shortForm(c.getName()));
        }
        monitor.taskFinished();
        this.finishTask("find unsatisfiable");
        this.output("");
        if (unsatisfiableClasses.isEmpty()) {
            this.output("Found no unsatisfiable concepts.");
        } else {
            this.output("Found " + unsatisfiableClasses.size() + " unsatisfiable concept(s):");
            for (String c : unsatisfiableClasses) {
                this.output(c);
            }
        }
    }
}

