/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.rete.Fact;
import com.clarkparsia.pellet.rules.rete.Node;
import com.clarkparsia.pellet.rules.rete.RuleNode;
import com.clarkparsia.pellet.rules.rete.TermTuple;
import com.clarkparsia.pellet.rules.rete.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BetaNode
extends Node {
    private boolean doExplanation;
    private boolean dirty;
    public Node lnode;
    public List<BetaNode> parents;
    public Node rnode;
    public RuleNode rule;

    public BetaNode(Node lnode, Node rnode, boolean doExplanation) {
        this.doExplanation = doExplanation;
        this.lnode = lnode;
        this.rnode = rnode;
        this.dirty = true;
        List<ATermAppl> shared = Utils.getSharedVars(lnode, rnode);
        lnode.svars = shared;
        rnode.svars = shared;
        this.vars = Utils.concat(shared, lnode.vars);
        this.vars = Utils.concat(this.vars, rnode.vars);
        this.vars = Utils.removeDups(this.vars);
        this.parents = new ArrayList<BetaNode>();
        lnode.add(this);
        if (!rnode.equals(lnode)) {
            rnode.add(this);
        }
    }

    public HashMap<ATermAppl, ATermAppl> getBindings(List<ATermAppl> row) {
        HashMap<ATermAppl, ATermAppl> bindings = new HashMap<ATermAppl, ATermAppl>();
        for (int i = 0; i < this.vars.size(); ++i) {
            bindings.put((ATermAppl)this.vars.get(i), row.get(i));
        }
        return bindings;
    }

    private ATermAppl getVar(ATermAppl var, List<ATermAppl> fact) {
        if (this.vars.contains(var)) {
            int index = this.getKey().indexOf(var);
            return fact.get(index);
        }
        ABox.log.warning("Unbound rule variable: " + var + this.vars);
        return null;
    }

    private int[] getVarPermutation() {
        List<ATermAppl> joinVars = new ArrayList<ATermAppl>(this.lnode.getKey());
        joinVars.addAll(this.rnode.getKey());
        joinVars = Utils.removeDups(joinVars);
        int[] perm = new int[this.vars.size()];
        for (int i = 0; i < joinVars.size(); ++i) {
            perm[i] = this.getKeyPosition(joinVars.get(i));
        }
        return perm;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public List<Fact> join() {
        this.dirty = false;
        int[] permutation = this.getVarPermutation();
        ArrayList<Fact> facts = new ArrayList<Fact>();
        for (Pair<Fact, Fact> match : this.lnode.index.join(this.rnode.index, this.lnode.svars.size())) {
            ArrayList constants = new ArrayList(permutation.length);
            constants.addAll(((Fact)match.first).getElements());
            constants.addAll(((Fact)match.second).getElements().subList(this.lnode.svars.size(), this.rnode.vars.size()));
            ATermAppl[] factParts = new ATermAppl[permutation.length];
            for (int i = 0; i < permutation.length; ++i) {
                factParts[permutation[i]] = (ATermAppl)constants.get(i);
            }
            DependencySet ds = ((Fact)match.first).getDependencySet();
            ds = ds.union(((Fact)match.second).getDependencySet(), this.doExplanation);
            List<ATermAppl> orderedConstants = Arrays.asList(factParts);
            Fact fact = new Fact(ds, orderedConstants);
            facts.add(fact);
            this.index.add(orderedConstants, fact);
        }
        return facts;
    }

    public void markDirty() {
        this.dirty = true;
        this.index.clear();
        for (BetaNode child : this.getBetas()) {
            child.markDirty();
        }
    }

    public Set<Fact> matchingFacts(TermTuple rhs, List<Fact> facts) {
        HashSet<Fact> results = new HashSet<Fact>();
        for (Fact f : facts) {
            ArrayList<ATermAppl> constants = new ArrayList<ATermAppl>(rhs.getElements().size());
            for (ATermAppl term : rhs.getElements()) {
                if (ATermUtils.isVar((ATermAppl)term)) {
                    constants.add(this.getVar(term, f.getElements()));
                    continue;
                }
                constants.add(term);
            }
            DependencySet ds = f.getDependencySet();
            ds = ds.union(rhs.getDependencySet(), this.doExplanation);
            if (this.rule != null && this.rule.explain != null) {
                ds = ds.union(Collections.singleton(this.rule.explain), this.doExplanation);
            }
            results.add(new Fact(ds, (List<ATermAppl>)constants));
        }
        return results;
    }

    @Override
    public void reset() {
        super.reset();
        for (BetaNode parent : this.parents) {
            parent.reset();
        }
    }

    public String toString() {
        return "BetaNode vars: " + this.vars.toString();
    }
}

