/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.impl.model;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.owl.impl.model.ListFactory;
import org.semanticweb.owl.impl.model.OWLAndImpl;
import org.semanticweb.owl.impl.model.OWLAnnotationInstanceImpl;
import org.semanticweb.owl.impl.model.OWLAnnotationPropertyImpl;
import org.semanticweb.owl.impl.model.OWLClassImpl;
import org.semanticweb.owl.impl.model.OWLConcreteDataImpl;
import org.semanticweb.owl.impl.model.OWLConcreteDataTypeImpl;
import org.semanticweb.owl.impl.model.OWLDataAllRestrictionImpl;
import org.semanticweb.owl.impl.model.OWLDataCardinalityRestrictionImpl;
import org.semanticweb.owl.impl.model.OWLDataEnumerationImpl;
import org.semanticweb.owl.impl.model.OWLDataPropertyImpl;
import org.semanticweb.owl.impl.model.OWLDataSomeRestrictionImpl;
import org.semanticweb.owl.impl.model.OWLDataValueRestrictionImpl;
import org.semanticweb.owl.impl.model.OWLDifferentIndividualsAxiomImpl;
import org.semanticweb.owl.impl.model.OWLDisjointClassesAxiomImpl;
import org.semanticweb.owl.impl.model.OWLEnumerationImpl;
import org.semanticweb.owl.impl.model.OWLEquivalentClassesAxiomImpl;
import org.semanticweb.owl.impl.model.OWLEquivalentPropertiesAxiomImpl;
import org.semanticweb.owl.impl.model.OWLFrameImpl;
import org.semanticweb.owl.impl.model.OWLIndividualImpl;
import org.semanticweb.owl.impl.model.OWLNotImpl;
import org.semanticweb.owl.impl.model.OWLObjectAllRestrictionImpl;
import org.semanticweb.owl.impl.model.OWLObjectCardinalityRestrictionImpl;
import org.semanticweb.owl.impl.model.OWLObjectPropertyImpl;
import org.semanticweb.owl.impl.model.OWLObjectSomeRestrictionImpl;
import org.semanticweb.owl.impl.model.OWLObjectValueRestrictionImpl;
import org.semanticweb.owl.impl.model.OWLOntologyImpl;
import org.semanticweb.owl.impl.model.OWLOrImpl;
import org.semanticweb.owl.impl.model.OWLSameIndividualsAxiomImpl;
import org.semanticweb.owl.impl.model.OWLSubClassAxiomImpl;
import org.semanticweb.owl.impl.model.OWLSubPropertyAxiomImpl;
import org.semanticweb.owl.io.vocabulary.OWLVocabularyAdapter;
import org.semanticweb.owl.model.OWLAnd;
import org.semanticweb.owl.model.OWLAnnotationInstance;
import org.semanticweb.owl.model.OWLAnnotationProperty;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataEnumeration;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyInstance;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValue;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLEnumeration;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentPropertiesAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLFrame;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLNot;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyInstance;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOr;
import org.semanticweb.owl.model.OWLProperty;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSubPropertyAxiom;
import org.semanticweb.owl.util.OWLConnection;

public class OWLDataFactoryImpl
implements OWLDataFactory,
Serializable {
    static Logger logger = Logger.getLogger((Class)(class$org$semanticweb$owl$impl$model$OWLDataFactoryImpl == null ? (class$org$semanticweb$owl$impl$model$OWLDataFactoryImpl = OWLDataFactoryImpl.class$("org.semanticweb.owl.impl.model.OWLDataFactoryImpl")) : class$org$semanticweb$owl$impl$model$OWLDataFactoryImpl));
    private Map classes;
    private Map objectProperties;
    private Map annotationProperties;
    private Map dataProperties;
    private Map individuals;
    private Map ontologies;
    private Map concreteDataTypes;
    private OWLConnection con;
    private OWLClass thing;
    private OWLClass nothing;
    static /* synthetic */ Class class$org$semanticweb$owl$impl$model$OWLDataFactoryImpl;

    private OWLDataFactoryImpl(OWLConnection con) {
        this.con = con;
        this.classes = ListFactory.getMap();
        this.objectProperties = ListFactory.getMap();
        this.annotationProperties = ListFactory.getMap();
        this.dataProperties = ListFactory.getMap();
        this.individuals = ListFactory.getMap();
        this.concreteDataTypes = ListFactory.getMap();
        this.ontologies = ListFactory.getMap();
        try {
            URI uri = new URI(OWLVocabularyAdapter.INSTANCE.getThing());
            this.thing = this.getOWLClass(uri);
            uri = new URI(OWLVocabularyAdapter.INSTANCE.getNothing());
            this.nothing = this.getOWLClass(uri);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public static OWLDataFactoryImpl getInstance(OWLConnection con) {
        return new OWLDataFactoryImpl(con);
    }

    public OWLAnd getOWLAnd(Set set) {
        return new OWLAndImpl(this, set);
    }

    public OWLDataValue getOWLConcreteData(URI uri, String lang, Object value) {
        return new OWLConcreteDataImpl(this, uri, lang, value);
    }

    public OWLDataType getOWLConcreteDataType(URI uri) {
        if (this.concreteDataTypes.get(uri) == null) {
            OWLConcreteDataTypeImpl newType = new OWLConcreteDataTypeImpl(this, uri);
            this.concreteDataTypes.put(uri, newType);
            return newType;
        }
        return (OWLDataType)this.concreteDataTypes.get(uri);
    }

    public OWLDataEnumeration getOWLDataEnumeration(Set set) {
        return new OWLDataEnumerationImpl(this, set);
    }

    public OWLDataAllRestriction getOWLDataAllRestriction(OWLDataProperty property, OWLDataRange dataType) {
        return new OWLDataAllRestrictionImpl(this, property, dataType);
    }

    public OWLDataCardinalityRestriction getOWLDataCardinalityRestriction(OWLDataProperty property, int atLeast, int atMost) {
        return new OWLDataCardinalityRestrictionImpl(this, property, atLeast, atMost);
    }

    public OWLDataCardinalityRestriction getOWLDataCardinalityAtLeastRestriction(OWLDataProperty property, int atLeast) {
        return new OWLDataCardinalityRestrictionImpl(this, property, atLeast, -1);
    }

    public OWLDataCardinalityRestriction getOWLDataCardinalityAtMostRestriction(OWLDataProperty property, int atMost) {
        return new OWLDataCardinalityRestrictionImpl(this, property, -1, atMost);
    }

    public OWLDataProperty getOWLDataProperty(URI uri) {
        if (this.dataProperties.get(uri) == null) {
            OWLDataPropertyImpl newDataProperty = new OWLDataPropertyImpl(this, uri);
            this.dataProperties.put(uri, newDataProperty);
            return newDataProperty;
        }
        return (OWLDataProperty)this.dataProperties.get(uri);
    }

    public OWLDataSomeRestriction getOWLDataSomeRestriction(OWLDataProperty property, OWLDataRange dataType) {
        return new OWLDataSomeRestrictionImpl(this, property, dataType);
    }

    public OWLDataValueRestriction getOWLDataValueRestriction(OWLDataProperty property, OWLDataValue value) {
        return new OWLDataValueRestrictionImpl(this, property, value);
    }

    public OWLDifferentIndividualsAxiom getOWLDifferentIndividualsAxiom(Set set) {
        return new OWLDifferentIndividualsAxiomImpl(this, set);
    }

    public OWLDisjointClassesAxiom getOWLDisjointClassesAxiom(Set set) {
        return new OWLDisjointClassesAxiomImpl(this, set);
    }

    public OWLEquivalentClassesAxiom getOWLEquivalentClassesAxiom(Set set) {
        return new OWLEquivalentClassesAxiomImpl(this, set);
    }

    public OWLEquivalentPropertiesAxiom getOWLEquivalentPropertiesAxiom(Set set) {
        return new OWLEquivalentPropertiesAxiomImpl(this, set);
    }

    public OWLFrame getOWLFrame(Set superClasses, Set restrictions) {
        return new OWLFrameImpl(this, superClasses, restrictions);
    }

    public OWLIndividual getOWLIndividual(URI uri) {
        if (uri == null) {
            throw new NullPointerException();
        }
        if (this.individuals.get(uri) == null) {
            OWLIndividualImpl newIndividual = new OWLIndividualImpl(this, uri);
            this.individuals.put(uri, newIndividual);
            return newIndividual;
        }
        return (OWLIndividual)this.individuals.get(uri);
    }

    public OWLIndividual getAnonOWLIndividual(URI uri) {
        if (uri == null) {
            throw new NullPointerException();
        }
        if (this.individuals.get(uri) == null) {
            OWLIndividualImpl newIndividual = new OWLIndividualImpl(this, uri, true);
            this.individuals.put(uri, newIndividual);
            return newIndividual;
        }
        return (OWLIndividual)this.individuals.get(uri);
    }

    public OWLObjectAllRestriction getOWLObjectAllRestriction(OWLObjectProperty property, OWLDescription description) {
        return new OWLObjectAllRestrictionImpl(this, property, description);
    }

    public OWLObjectCardinalityRestriction getOWLObjectCardinalityRestriction(OWLObjectProperty property, int atLeast, int atMost) {
        return new OWLObjectCardinalityRestrictionImpl(this, property, atLeast, atMost);
    }

    public OWLObjectCardinalityRestriction getOWLObjectCardinalityAtLeastRestriction(OWLObjectProperty property, int atLeast) {
        return new OWLObjectCardinalityRestrictionImpl(this, property, atLeast, -1000);
    }

    public OWLObjectCardinalityRestriction getOWLObjectCardinalityAtMostRestriction(OWLObjectProperty property, int atMost) {
        return new OWLObjectCardinalityRestrictionImpl(this, property, -1000, atMost);
    }

    public OWLAnnotationProperty getOWLAnnotationProperty(URI uri) {
        if (this.annotationProperties.get(uri) == null) {
            OWLAnnotationPropertyImpl newAnnotationProperty = new OWLAnnotationPropertyImpl(this, uri);
            this.annotationProperties.put(uri, newAnnotationProperty);
            return newAnnotationProperty;
        }
        return (OWLAnnotationProperty)this.annotationProperties.get(uri);
    }

    public OWLObjectProperty getOWLObjectProperty(URI uri) {
        if (this.objectProperties.get(uri) == null) {
            OWLObjectPropertyImpl newObjectProperty = new OWLObjectPropertyImpl(this, uri);
            this.objectProperties.put(uri, newObjectProperty);
            return newObjectProperty;
        }
        return (OWLObjectProperty)this.objectProperties.get(uri);
    }

    public OWLObjectSomeRestriction getOWLObjectSomeRestriction(OWLObjectProperty property, OWLDescription description) {
        return new OWLObjectSomeRestrictionImpl(this, property, description);
    }

    public OWLObjectValueRestriction getOWLObjectValueRestriction(OWLObjectProperty property, OWLIndividual individual) {
        return new OWLObjectValueRestrictionImpl(this, property, individual);
    }

    public OWLNot getOWLNot(OWLDescription operand) {
        return new OWLNotImpl(this, operand);
    }

    public OWLClass getOWLNothing() {
        return this.nothing;
    }

    public OWLOntology getOWLOntology(URI logicalURI, URI physicalURI) throws OWLException {
        if (this.ontologies.get(logicalURI) == null) {
            OWLOntologyImpl newOntology = new OWLOntologyImpl(this, logicalURI, physicalURI);
            this.ontologies.put(logicalURI, newOntology);
            return newOntology;
        }
        OWLOntology existing = (OWLOntology)this.ontologies.get(logicalURI);
        if (!existing.getPhysicalURI().equals(physicalURI)) {
            throw new OWLException("Ontology with logical URI: \n\t" + logicalURI + "\nAlready present using physical URI\n\t" + existing.getPhysicalURI());
        }
        return existing;
    }

    public OWLOr getOWLOr(Set set) {
        return new OWLOrImpl(this, set);
    }

    public OWLClass getOWLClass(URI uri) {
        logger.debug((Object)("Creating: " + uri));
        if (logger.isDebugEnabled() && uri == null) {
            Thread.currentThread();
            Thread.dumpStack();
        }
        if (this.classes.get(uri) == null) {
            OWLClassImpl newClass = new OWLClassImpl(this, uri);
            this.classes.put(uri, newClass);
            return newClass;
        }
        return (OWLClass)this.classes.get(uri);
    }

    public OWLEnumeration getOWLEnumeration(Set set) {
        return new OWLEnumerationImpl(this, set);
    }

    public OWLSameIndividualsAxiom getOWLSameIndividualsAxiom(Set set) {
        return new OWLSameIndividualsAxiomImpl(this, set);
    }

    public OWLSubClassAxiom getOWLSubClassAxiom(OWLDescription subClass, OWLDescription superClass) {
        return new OWLSubClassAxiomImpl(this, subClass, superClass);
    }

    public OWLSubPropertyAxiom getOWLSubPropertyAxiom(OWLProperty subProperty, OWLProperty superProperty) {
        return new OWLSubPropertyAxiomImpl(this, subProperty, superProperty);
    }

    public OWLClass getOWLThing() {
        return this.thing;
    }

    public OWLObjectPropertyInstance getOWLObjectPropertyInstance(OWLIndividual subject, OWLObjectProperty property, OWLIndividual object) throws OWLException {
        return null;
    }

    public OWLAnnotationInstance getOWLAnnotationInstance(OWLObject subject, OWLAnnotationProperty property, Object content) throws OWLException {
        return new OWLAnnotationInstanceImpl(this, subject, property, content);
    }

    public OWLDataPropertyInstance getOWLDataPropertyInstance(OWLIndividual subject, OWLDataProperty property, OWLDataValue object) throws OWLException {
        return null;
    }

    public OWLConnection getOWLConnection() {
        return this.con;
    }

    public void forgetOWLOntology(OWLOntology o) throws OWLException {
        this.ontologies.remove(o.getURI());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

