/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.impl.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.impl.model.ListFactory;
import org.semanticweb.owl.impl.model.OWLDataFactoryImpl;
import org.semanticweb.owl.impl.model.OWLImplHelper;
import org.semanticweb.owl.model.OWLAnnotationInstance;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.util.OWLConnection;

public abstract class OWLObjectImpl
implements Cloneable,
Serializable,
OWLObject {
    private OWLDataFactoryImpl owlDataFactory;
    private Map metadata;
    private Map annotations;

    public OWLObjectImpl(OWLDataFactoryImpl factory) {
        this.owlDataFactory = factory;
        this.metadata = ListFactory.getMap();
        this.annotations = ListFactory.getMap();
    }

    public OWLObject[] getContainedObjects() {
        return new OWLObject[0];
    }

    public OWLDataFactory getOWLDataFactory() {
        return this.owlDataFactory;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public abstract void accept(OWLObjectVisitor var1) throws OWLException;

    public Map getMetadata() {
        return ListFactory.getMap(this.metadata);
    }

    public OWLConnection getOWLConnection() {
        return this.owlDataFactory.getOWLConnection();
    }

    public Set getAnnotations(OWLOntology o) {
        return ListFactory.getSet(OWLImplHelper.getAppropriateSet(this.annotations, o));
    }

    public Set getAnnotations() {
        return ListFactory.getSet(OWLImplHelper.unionValues(this.annotations));
    }

    boolean addAnnotation(OWLOntology ontology, OWLAnnotationInstance instance) {
        return OWLImplHelper.getAppropriateSet(this.annotations, ontology).add(instance);
    }

    boolean removeAnnotation(OWLOntology ontology, OWLAnnotationInstance instance) {
        HashSet<OWLAnnotationInstance> newAnnotInstanceSet = new HashSet<OWLAnnotationInstance>();
        Iterator iter = OWLImplHelper.getAppropriateSet(this.annotations, ontology).iterator();
        while (iter.hasNext()) {
            OWLAnnotationInstance currInst = (OWLAnnotationInstance)iter.next();
            try {
                if (currInst.getSubject().equals(instance.getSubject()) && currInst.getContent().equals(instance.getContent()) && currInst.getProperty().equals(instance.getProperty())) continue;
                newAnnotInstanceSet.add(currInst);
            }
            catch (OWLException e) {
                e.printStackTrace();
            }
        }
        OWLImplHelper.getAppropriateSet(this.annotations, ontology).clear();
        OWLImplHelper.getAppropriateSet(this.annotations, ontology).addAll(newAnnotInstanceSet);
        return false;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass().equals(obj.getClass());
    }

    protected static int hashCode(Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

