/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.impl.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.owl.impl.model.ListFactory;
import org.semanticweb.owl.impl.model.OWLClassImpl;
import org.semanticweb.owl.impl.model.OWLConnectionImpl;
import org.semanticweb.owl.impl.model.OWLDataFactoryImpl;
import org.semanticweb.owl.impl.model.OWLDataPropertyImpl;
import org.semanticweb.owl.impl.model.OWLDeprecatableObjectImpl;
import org.semanticweb.owl.impl.model.OWLEntityImpl;
import org.semanticweb.owl.impl.model.OWLIndividualImpl;
import org.semanticweb.owl.impl.model.OWLNamedObjectImpl;
import org.semanticweb.owl.impl.model.OWLObjectImpl;
import org.semanticweb.owl.impl.model.OWLObjectPropertyImpl;
import org.semanticweb.owl.impl.model.OWLPropertyImpl;
import org.semanticweb.owl.model.OWLAnnotationInstance;
import org.semanticweb.owl.model.OWLAnnotationProperty;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityVisitor;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentPropertiesAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLIndividualAxiom;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLPropertyAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSubPropertyAxiom;
import org.semanticweb.owl.model.change.AddAllEntitiesStrategy;
import org.semanticweb.owl.model.change.AddAnnotationInstance;
import org.semanticweb.owl.model.change.AddClassAxiom;
import org.semanticweb.owl.model.change.AddDataPropertyInstance;
import org.semanticweb.owl.model.change.AddDataPropertyRange;
import org.semanticweb.owl.model.change.AddDataType;
import org.semanticweb.owl.model.change.AddDomain;
import org.semanticweb.owl.model.change.AddEntity;
import org.semanticweb.owl.model.change.AddEnumeration;
import org.semanticweb.owl.model.change.AddEquivalentClass;
import org.semanticweb.owl.model.change.AddForeignEntity;
import org.semanticweb.owl.model.change.AddImport;
import org.semanticweb.owl.model.change.AddIndividualAxiom;
import org.semanticweb.owl.model.change.AddIndividualClass;
import org.semanticweb.owl.model.change.AddInverse;
import org.semanticweb.owl.model.change.AddObjectPropertyInstance;
import org.semanticweb.owl.model.change.AddObjectPropertyRange;
import org.semanticweb.owl.model.change.AddPropertyAxiom;
import org.semanticweb.owl.model.change.AddSuperClass;
import org.semanticweb.owl.model.change.AddSuperProperty;
import org.semanticweb.owl.model.change.ChangeVisitor;
import org.semanticweb.owl.model.change.ChangeVisitorAdapter;
import org.semanticweb.owl.model.change.OntologyChange;
import org.semanticweb.owl.model.change.OntologyChangeListener;
import org.semanticweb.owl.model.change.OntologyChangeSource;
import org.semanticweb.owl.model.change.RemoveAnnotationInstance;
import org.semanticweb.owl.model.change.RemoveClassAxiom;
import org.semanticweb.owl.model.change.RemoveDataPropertyInstance;
import org.semanticweb.owl.model.change.RemoveDataPropertyRange;
import org.semanticweb.owl.model.change.RemoveDomain;
import org.semanticweb.owl.model.change.RemoveEntity;
import org.semanticweb.owl.model.change.RemoveEnumeration;
import org.semanticweb.owl.model.change.RemoveEquivalentClass;
import org.semanticweb.owl.model.change.RemoveForeignEntity;
import org.semanticweb.owl.model.change.RemoveImport;
import org.semanticweb.owl.model.change.RemoveIndividualAxiom;
import org.semanticweb.owl.model.change.RemoveIndividualClass;
import org.semanticweb.owl.model.change.RemoveInverse;
import org.semanticweb.owl.model.change.RemoveObjectPropertyInstance;
import org.semanticweb.owl.model.change.RemoveObjectPropertyRange;
import org.semanticweb.owl.model.change.RemovePropertyAxiom;
import org.semanticweb.owl.model.change.RemoveSuperClass;
import org.semanticweb.owl.model.change.RemoveSuperProperty;
import org.semanticweb.owl.model.change.SetDeprecated;
import org.semanticweb.owl.model.change.SetFunctional;
import org.semanticweb.owl.model.change.SetInverseFunctional;
import org.semanticweb.owl.model.change.SetLinkTarget;
import org.semanticweb.owl.model.change.SetLogicalURI;
import org.semanticweb.owl.model.change.SetOneToOne;
import org.semanticweb.owl.model.change.SetSymmetric;
import org.semanticweb.owl.model.change.SetTransitive;

public class OWLOntologyImpl
extends OWLNamedObjectImpl
implements OWLOntology,
ChangeVisitor,
OntologyChangeSource {
    protected HashMap classes;
    protected HashMap annotationProperties;
    protected HashMap dataProperties;
    protected HashMap objectProperties;
    protected HashMap individuals;
    protected HashMap datatypes;
    protected int anonymousIndividuals;
    protected Set classAxioms;
    protected Set propertyAxioms;
    protected Set individualAxioms;
    protected Set importedOntologies;
    protected boolean mutable;
    protected URI physicalURI;
    protected Map foreignEntities;
    protected ChangeVisitor visitorProxy;
    protected Set changeListeners;
    static Logger logger = Logger.getLogger((Class)(class$org$semanticweb$owl$impl$model$OWLOntologyImpl == null ? (class$org$semanticweb$owl$impl$model$OWLOntologyImpl = OWLOntologyImpl.class$("org.semanticweb.owl.impl.model.OWLOntologyImpl")) : class$org$semanticweb$owl$impl$model$OWLOntologyImpl));
    static /* synthetic */ Class class$org$semanticweb$owl$impl$model$OWLOntologyImpl;

    public OWLOntologyImpl(OWLDataFactoryImpl factory, URI logicalURI, URI physicalURI) {
        super(factory);
        this.uri = logicalURI;
        this.physicalURI = physicalURI;
        this.classes = new HashMap();
        this.annotationProperties = new HashMap();
        this.dataProperties = new HashMap();
        this.objectProperties = new HashMap();
        this.individuals = new HashMap();
        this.datatypes = new HashMap();
        this.anonymousIndividuals = 0;
        this.classAxioms = ListFactory.getSet();
        this.propertyAxioms = ListFactory.getSet();
        this.individualAxioms = ListFactory.getSet();
        this.importedOntologies = ListFactory.getSet();
        this.foreignEntities = ListFactory.getMap();
        this.mutable = true;
        this.visitorProxy = this.getChangeVisitor();
        this.changeListeners = ListFactory.getSet();
    }

    public void applyChanges(List changeList) throws OWLException {
        logger.info((Object)"Implement me!");
    }

    public URI getPhysicalURI() {
        return this.physicalURI;
    }

    public URI getLogicalURI() {
        return this.uri;
    }

    public Set getClasses() {
        return ListFactory.getSet(this.classes.values());
    }

    public Set getAnnotationProperties() {
        return ListFactory.getSet(this.annotationProperties.values());
    }

    public Set getDataProperties() {
        return ListFactory.getSet(this.dataProperties.values());
    }

    public Set getObjectProperties() {
        return ListFactory.getSet(this.objectProperties.values());
    }

    public Set getIndividuals() {
        return ListFactory.getSet(this.individuals.values());
    }

    public Set getForeignOntologies() {
        HashSet<URI> result = new HashSet<URI>();
        Iterator itera = this.getObjectProperties().iterator();
        while (itera.hasNext()) {
            OWLObjectProperty prop = (OWLObjectProperty)itera.next();
            if (!prop.isLink()) continue;
            result.add(prop.getLinkTarget());
        }
        return result;
    }

    public Set getLinkProperties() {
        HashSet<OWLObjectProperty> result = new HashSet<OWLObjectProperty>();
        Iterator itera = this.getObjectProperties().iterator();
        while (itera.hasNext()) {
            OWLObjectProperty prop = (OWLObjectProperty)itera.next();
            if (!prop.isLink()) continue;
            result.add(prop);
        }
        return result;
    }

    public Map getForeignEntities() {
        return this.foreignEntities;
    }

    public Set getDatatypes() {
        return ListFactory.getSet(this.datatypes.values());
    }

    public Set getClassAxioms() {
        return ListFactory.getSet(this.classAxioms);
    }

    public Set getPropertyAxioms() {
        return ListFactory.getSet(this.propertyAxioms);
    }

    public Set getIndividualAxioms() {
        return ListFactory.getSet(this.individualAxioms);
    }

    public Set getIncludedOntologies() {
        return ListFactory.getSet(this.importedOntologies);
    }

    public Set getPriorVersion() {
        return ListFactory.getSet();
    }

    public Set getBackwardCompatibleWith() {
        return ListFactory.getSet();
    }

    public Set getIncompatibleWith() {
        return ListFactory.getSet();
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void accept(OWLObjectVisitor visitor) throws OWLException {
        visitor.visit((OWLOntology)this);
    }

    protected ChangeVisitor getChangeVisitor() {
        return new ChangeVisitorAdapter(){

            public void visit(AddEntity event) throws OWLException {
                if (event.getOntology() != OWLOntologyImpl.this) {
                    throw new OWLException("Inappropriate change event");
                }
                logger.debug((Object)("Adding: " + event));
                EntityAdder adder = new EntityAdder((OntologyChange)event);
                event.getEntity().accept((OWLEntityVisitor)adder);
            }

            public void visit(AddDataType event) throws OWLException {
                if (event.getOntology() != OWLOntologyImpl.this) {
                    throw new OWLException("Inappropriate change event");
                }
                logger.debug((Object)("Adding: " + event));
                OWLOntologyImpl.this.datatypes.put(event.getDatatype().getURI(), event.getDatatype());
                OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
            }

            public void visit(RemoveEntity event) throws OWLException {
                if (event.getOntology() != OWLOntologyImpl.this) {
                    throw new OWLException("Inappropriate change event");
                }
                logger.debug((Object)("Removing: " + event.getEntity().getURI()));
                EntityRemover remover = new EntityRemover();
                event.getEntity().accept((OWLEntityVisitor)remover);
            }

            public void visit(AddIndividualAxiom event) throws OWLException {
                if (event.getOntology() != OWLOntologyImpl.this) {
                    throw new OWLException("Inappropriate change event");
                }
                OWLOntologyImpl.this.individualAxioms.add(event.getAxiom());
                OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
            }

            public void visit(RemoveIndividualAxiom event) throws OWLException {
                HashSet<OWLIndividualAxiom> removeAxiomSet;
                if (event.getOntology() == OWLOntologyImpl.this) {
                    OWLIndividualAxiom removeAxiom = event.getAxiom();
                    removeAxiomSet = new HashSet<OWLIndividualAxiom>();
                    Iterator iter = OWLOntologyImpl.this.individualAxioms.iterator();
                    while (iter.hasNext()) {
                        OWLIndividualAxiom axiom = (OWLIndividualAxiom)iter.next();
                        if (axiom instanceof OWLSameIndividualsAxiom && removeAxiom instanceof OWLSameIndividualsAxiom && ((Object)((OWLSameIndividualsAxiom)axiom).getIndividuals()).equals(((OWLSameIndividualsAxiom)removeAxiom).getIndividuals())) {
                            removeAxiomSet.add(axiom);
                        }
                        if (!(axiom instanceof OWLDifferentIndividualsAxiom) || !(removeAxiom instanceof OWLDifferentIndividualsAxiom) || !((Object)((OWLDifferentIndividualsAxiom)axiom).getIndividuals()).equals(((OWLDifferentIndividualsAxiom)removeAxiom).getIndividuals())) continue;
                        removeAxiomSet.add(axiom);
                    }
                } else {
                    throw new OWLException("Inappropriate change event");
                }
                OWLOntologyImpl.this.individualAxioms.removeAll(removeAxiomSet);
                OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
            }

            public void visit(AddClassAxiom event) throws OWLException {
                if (event.getOntology() != OWLOntologyImpl.this) {
                    throw new OWLException("Inappropriate change event");
                }
                logger.debug((Object)("Axiom: " + event.getAxiom()));
                OWLOntologyImpl.this.classAxioms.add(event.getAxiom());
                OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
            }

            public void visit(RemoveClassAxiom event) throws OWLException {
                HashSet<OWLClassAxiom> removeAxiomSet;
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Axiom: " + event.getAxiom()));
                    OWLClassAxiom removeAxiom = event.getAxiom();
                    removeAxiomSet = new HashSet<OWLClassAxiom>();
                    Iterator iter = OWLOntologyImpl.this.classAxioms.iterator();
                    while (iter.hasNext()) {
                        OWLClassAxiom axiom = (OWLClassAxiom)iter.next();
                        if (axiom instanceof OWLDisjointClassesAxiom && removeAxiom instanceof OWLDisjointClassesAxiom && ((Object)((OWLDisjointClassesAxiom)axiom).getDisjointClasses()).equals(((OWLDisjointClassesAxiom)removeAxiom).getDisjointClasses())) {
                            removeAxiomSet.add(axiom);
                        }
                        if (axiom instanceof OWLEquivalentClassesAxiom && removeAxiom instanceof OWLEquivalentClassesAxiom && ((Object)((OWLEquivalentClassesAxiom)axiom).getEquivalentClasses()).equals(((OWLEquivalentClassesAxiom)removeAxiom).getEquivalentClasses())) {
                            removeAxiomSet.add(axiom);
                        }
                        if (!(axiom instanceof OWLSubClassAxiom) || !(removeAxiom instanceof OWLSubClassAxiom)) continue;
                        OWLSubClassAxiom subCAxiom = (OWLSubClassAxiom)axiom;
                        OWLSubClassAxiom remSCAxiom = (OWLSubClassAxiom)removeAxiom;
                        if (!subCAxiom.getSubClass().equals(remSCAxiom.getSubClass()) || !subCAxiom.getSuperClass().equals(remSCAxiom.getSuperClass())) continue;
                        removeAxiomSet.add(axiom);
                    }
                } else {
                    throw new OWLException("Inappropriate change event");
                }
                OWLOntologyImpl.this.classAxioms.removeAll(removeAxiomSet);
                OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
            }

            public void visit(AddPropertyAxiom event) throws OWLException {
                if (event.getOntology() != OWLOntologyImpl.this) {
                    throw new OWLException("Inappropriate change event");
                }
                OWLOntologyImpl.this.propertyAxioms.add(event.getAxiom());
                OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
            }

            public void visit(RemovePropertyAxiom event) throws OWLException {
                HashSet<OWLPropertyAxiom> removeAxiomSet;
                if (event.getOntology() == OWLOntologyImpl.this) {
                    OWLPropertyAxiom removeAxiom = event.getAxiom();
                    removeAxiomSet = new HashSet<OWLPropertyAxiom>();
                    Iterator iter = OWLOntologyImpl.this.propertyAxioms.iterator();
                    while (iter.hasNext()) {
                        OWLPropertyAxiom axiom = (OWLPropertyAxiom)iter.next();
                        if (axiom instanceof OWLEquivalentPropertiesAxiom && removeAxiom instanceof OWLEquivalentPropertiesAxiom) {
                            try {
                                OWLEquivalentPropertiesAxiom equpAxiom = (OWLEquivalentPropertiesAxiom)axiom;
                                OWLEquivalentPropertiesAxiom remEPAxiom = (OWLEquivalentPropertiesAxiom)removeAxiom;
                                if (((Object)equpAxiom.getProperties()).equals(remEPAxiom.getProperties())) {
                                    removeAxiomSet.add(axiom);
                                }
                            }
                            catch (OWLException e) {
                                e.printStackTrace();
                            }
                        }
                        if (!(axiom instanceof OWLSubPropertyAxiom) || !(removeAxiom instanceof OWLSubPropertyAxiom)) continue;
                        try {
                            OWLSubPropertyAxiom subpAxiom = (OWLSubPropertyAxiom)axiom;
                            OWLSubPropertyAxiom remSPAxiom = (OWLSubPropertyAxiom)removeAxiom;
                            if (!subpAxiom.getSubProperty().equals(remSPAxiom.getSubProperty()) || !subpAxiom.getSuperProperty().equals(remSPAxiom.getSuperProperty())) continue;
                            removeAxiomSet.add(axiom);
                        }
                        catch (OWLException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    throw new OWLException("Inappropriate change event");
                }
                OWLOntologyImpl.this.propertyAxioms.removeAll(removeAxiomSet);
                OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
            }

            public void visit(AddSuperClass event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Added: " + event));
                    try {
                        ((OWLClassImpl)event.getOWLClass()).addSuperClass(OWLOntologyImpl.this, event.getDescription());
                        if (event.getDescription() instanceof OWLClassImpl) {
                            ((OWLClassImpl)event.getDescription()).addSubClass(OWLOntologyImpl.this, (OWLDescription)event.getOWLClass());
                        }
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getOWLClass().getClass() + " in " + OWLOntologyImpl.this);
                    }
                } else {
                    throw new OWLException("Inappropriate change event");
                }
            }

            public void visit(RemoveSuperClass event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Removed: " + event));
                    try {
                        ((OWLClassImpl)event.getOWLClass()).removeSuperClass(OWLOntologyImpl.this, event.getDescription());
                        if (event.getDescription() instanceof OWLClassImpl) {
                            ((OWLClassImpl)event.getDescription()).removeSubClass(OWLOntologyImpl.this, (OWLDescription)event.getOWLClass());
                        }
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getOWLClass().getClass() + " in " + OWLOntologyImpl.this);
                    }
                } else {
                    throw new OWLException("Inappropriate change event");
                }
            }

            public void visit(AddEquivalentClass event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Added: " + event));
                    try {
                        ((OWLClassImpl)event.getOWLClass()).addEquivalentClass(OWLOntologyImpl.this, event.getDescription());
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getOWLClass().getClass() + " in " + OWLOntologyImpl.this);
                    }
                } else {
                    throw new OWLException("Inappropriate change event");
                }
            }

            public void visit(RemoveEquivalentClass event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Removed: " + event));
                    try {
                        ((OWLClassImpl)event.getOWLClass()).removeEquivalentClass(OWLOntologyImpl.this, event.getDescription());
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getOWLClass().getClass() + " in " + OWLOntologyImpl.this);
                    }
                } else {
                    throw new OWLException("Inappropriate change event");
                }
            }

            public void visit(AddEnumeration event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Added: " + event));
                    try {
                        ((OWLClassImpl)event.getOWLClass()).addEnumeration(OWLOntologyImpl.this, event.getEnumeration());
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getOWLClass().getClass() + " in " + OWLOntologyImpl.this);
                    }
                }
            }

            public void visit(RemoveEnumeration event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Removed: " + event));
                    try {
                        ((OWLClassImpl)event.getOWLClass()).removeEnumeration(OWLOntologyImpl.this, event.getEnumeration());
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getOWLClass().getClass() + " in " + OWLOntologyImpl.this);
                    }
                }
            }

            public void visit(AddSuperProperty event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Added: " + event));
                    try {
                        ((OWLPropertyImpl)event.getProperty()).addSuperProperty(OWLOntologyImpl.this, event.getSuperProperty());
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getProperty().getClass() + " in " + OWLOntologyImpl.this);
                    }
                } else {
                    throw new OWLException("Inappropriate change event");
                }
            }

            public void visit(RemoveSuperProperty event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Removed: " + event));
                    try {
                        ((OWLPropertyImpl)event.getProperty()).removeSuperProperty(OWLOntologyImpl.this, event.getSuperProperty());
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getProperty().getClass() + " in " + OWLOntologyImpl.this);
                    }
                } else {
                    throw new OWLException("Inappropriate change event");
                }
            }

            public void visit(AddIndividualClass event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Added: " + event));
                    try {
                        ((OWLIndividualImpl)event.getIndividual()).addType(OWLOntologyImpl.this, event.getDescription());
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getIndividual().getClass() + " in " + OWLOntologyImpl.this);
                    }
                } else {
                    throw new OWLException("Inappropriate change event");
                }
            }

            public void visit(RemoveIndividualClass event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Removed: " + event));
                    try {
                        ((OWLIndividualImpl)event.getIndividual()).removeType(OWLOntologyImpl.this, event.getDescription());
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getIndividual().getClass() + " in " + OWLOntologyImpl.this);
                    }
                } else {
                    throw new OWLException("Inappropriate change event");
                }
            }

            public void visit(AddObjectPropertyInstance event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Added: " + event));
                    try {
                        ((OWLIndividualImpl)event.getSubject()).addObjectPropertyValue(OWLOntologyImpl.this, event.getProperty(), event.getObject());
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getSubject().getClass() + " in " + OWLOntologyImpl.this);
                    }
                } else {
                    throw new OWLException("Inappropriate change event");
                }
            }

            public void visit(RemoveObjectPropertyInstance event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Removed: " + event));
                    try {
                        ((OWLIndividualImpl)event.getSubject()).removeObjectPropertyValue(OWLOntologyImpl.this, event.getProperty(), event.getObject());
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getSubject().getClass() + " in " + OWLOntologyImpl.this);
                    }
                } else {
                    throw new OWLException("Inappropriate change event");
                }
            }

            public void visit(AddDataPropertyInstance event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Added: " + event));
                    try {
                        ((OWLIndividualImpl)event.getSubject()).addDataPropertyValue(OWLOntologyImpl.this, event.getProperty(), event.getObject());
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getSubject().getClass() + " in " + OWLOntologyImpl.this);
                    }
                } else {
                    throw new OWLException("Inappropriate change event");
                }
            }

            public void visit(RemoveDataPropertyInstance event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Removed: " + event));
                    try {
                        ((OWLIndividualImpl)event.getSubject()).removeDataPropertyValue(OWLOntologyImpl.this, event.getProperty(), event.getObject());
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getSubject().getClass() + " in " + OWLOntologyImpl.this);
                    }
                } else {
                    throw new OWLException("Inappropriate change event");
                }
            }

            public void visit(SetDeprecated event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Added: " + event));
                    try {
                        OWLDeprecatableObjectImpl odc = (OWLDeprecatableObjectImpl)event.getObject();
                        odc.setDeprecated(OWLOntologyImpl.this, event.isDeprecated());
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getObject().getClass() + " in " + OWLOntologyImpl.this);
                    }
                }
            }

            public void visit(AddAnnotationInstance event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Added: " + event));
                    try {
                        OWLAnnotationInstance annotationInstance = OWLOntologyImpl.this.getOWLDataFactory().getOWLAnnotationInstance(event.getSubject(), event.getProperty(), event.getContent());
                        ((OWLObjectImpl)event.getSubject()).addAnnotation(OWLOntologyImpl.this, annotationInstance);
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getSubject().getClass() + " in " + OWLOntologyImpl.this);
                    }
                } else {
                    throw new OWLException("Inappropriate change event");
                }
            }

            public void visit(RemoveAnnotationInstance event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Removed: " + event));
                    try {
                        OWLAnnotationInstance annotationInstance = OWLOntologyImpl.this.getOWLDataFactory().getOWLAnnotationInstance(event.getSubject(), event.getProperty(), event.getContent());
                        ((OWLObjectImpl)event.getSubject()).removeAnnotation(OWLOntologyImpl.this, annotationInstance);
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getSubject().getClass() + " in " + OWLOntologyImpl.this);
                    }
                } else {
                    throw new OWLException("Inappropriate change event");
                }
            }

            public void visit(SetLinkTarget event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Added: " + event));
                    try {
                        OWLObjectProperty prop = (OWLObjectProperty)event.getProperty();
                        URI ur = event.getLinkTarget();
                        prop.setLinkTarget(ur);
                        OWLOntologyImpl.this.getObjectProperties().remove(prop);
                        OWLOntologyImpl.this.getObjectProperties().add(prop);
                    }
                    catch (Exception ex) {
                        throw new OWLException("Error found when setting link target ");
                    }
                }
            }

            public void visit(SetFunctional event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Added: " + event));
                    try {
                        OWLPropertyImpl prop = (OWLPropertyImpl)event.getProperty();
                        prop.setFunctional(OWLOntologyImpl.this, event.isFunctional());
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getProperty().getClass() + " in " + OWLOntologyImpl.this);
                    }
                }
            }

            public void visit(SetInverseFunctional event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Added: " + event));
                    try {
                        OWLObjectPropertyImpl prop = (OWLObjectPropertyImpl)event.getProperty();
                        prop.setInverseFunctional(OWLOntologyImpl.this, event.isInverseFunctional());
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getProperty().getClass() + " in " + OWLOntologyImpl.this);
                    }
                }
            }

            public void visit(SetSymmetric event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Added: " + event));
                    try {
                        OWLObjectPropertyImpl prop = (OWLObjectPropertyImpl)event.getProperty();
                        prop.setSymmetric(OWLOntologyImpl.this, event.isSymmetric());
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getProperty().getClass() + " in " + OWLOntologyImpl.this);
                    }
                }
            }

            public void visit(SetTransitive event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Added: " + event));
                    try {
                        OWLObjectPropertyImpl prop = (OWLObjectPropertyImpl)event.getProperty();
                        prop.setTransitive(OWLOntologyImpl.this, event.isTransitive());
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getProperty().getClass() + " in " + OWLOntologyImpl.this);
                    }
                }
            }

            public void visit(SetOneToOne event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Added: " + event));
                    try {
                        OWLObjectPropertyImpl prop = (OWLObjectPropertyImpl)event.getProperty();
                        prop.setOneToOne(OWLOntologyImpl.this, event.isOneToOne());
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getProperty().getClass() + " in " + OWLOntologyImpl.this);
                    }
                }
            }

            public void visit(AddInverse event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Added: " + event));
                    try {
                        OWLObjectPropertyImpl prop = (OWLObjectPropertyImpl)event.getProperty();
                        prop.addInverse(OWLOntologyImpl.this, event.getInverse());
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getProperty().getClass() + " in " + OWLOntologyImpl.this);
                    }
                }
            }

            public void visit(RemoveInverse event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Removed: " + event));
                    try {
                        OWLObjectPropertyImpl prop = (OWLObjectPropertyImpl)event.getProperty();
                        prop.removeInverse(OWLOntologyImpl.this, event.getInverse());
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getProperty().getClass() + " in " + OWLOntologyImpl.this);
                    }
                }
            }

            public void visit(AddDomain event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Added: " + event));
                    try {
                        OWLPropertyImpl prop = (OWLPropertyImpl)event.getProperty();
                        prop.addDomain(OWLOntologyImpl.this, event.getDomain());
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getProperty().getClass() + " in " + OWLOntologyImpl.this);
                    }
                }
            }

            public void visit(RemoveDomain event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Removed: " + event));
                    try {
                        OWLPropertyImpl prop = (OWLPropertyImpl)event.getProperty();
                        prop.removeDomain(OWLOntologyImpl.this, event.getDomain());
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getProperty().getClass() + " in " + OWLOntologyImpl.this);
                    }
                }
            }

            public void visit(AddObjectPropertyRange event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Added: " + event));
                    try {
                        OWLObjectPropertyImpl prop = (OWLObjectPropertyImpl)event.getProperty();
                        prop.addRange(OWLOntologyImpl.this, event.getRange());
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getProperty().getClass() + " in " + OWLOntologyImpl.this);
                    }
                }
            }

            public void visit(RemoveObjectPropertyRange event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Removed: " + event));
                    try {
                        OWLObjectPropertyImpl prop = (OWLObjectPropertyImpl)event.getProperty();
                        prop.removeRange(OWLOntologyImpl.this, event.getRange());
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getProperty().getClass() + " in " + OWLOntologyImpl.this);
                    }
                }
            }

            public void visit(AddDataPropertyRange event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Added: " + event));
                    try {
                        OWLDataPropertyImpl prop = (OWLDataPropertyImpl)event.getProperty();
                        prop.addRange(OWLOntologyImpl.this, event.getRange());
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getProperty().getClass() + " in " + OWLOntologyImpl.this);
                    }
                }
            }

            public void visit(RemoveDataPropertyRange event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Removed: " + event));
                    try {
                        OWLDataPropertyImpl prop = (OWLDataPropertyImpl)event.getProperty();
                        prop.removeRange(OWLOntologyImpl.this, event.getRange());
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getProperty().getClass() + " in " + OWLOntologyImpl.this);
                    }
                }
            }

            public void visit(AddForeignEntity event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Added: " + event));
                    try {
                        OWLEntity ent = event.getForeignEntity();
                        URI forOnt = event.getForeignOntology();
                        OWLOntologyImpl.this.getForeignEntities().put(ent, forOnt);
                    }
                    catch (NullPointerException ex) {
                        throw new OWLException("Unable to obtain foreign entity  in " + event);
                    }
                }
            }

            public void visit(RemoveForeignEntity event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Removed: " + event));
                    try {
                        OWLEntity ent = event.getForeignEntity();
                        OWLOntologyImpl.this.getForeignEntities().remove(ent);
                    }
                    catch (NullPointerException ex) {
                        throw new OWLException("Unable to obtain foreign entity  in " + event);
                    }
                }
            }

            public void visit(AddImport event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Added: " + event));
                    try {
                        OWLOntologyImpl onto = (OWLOntologyImpl)event.getImportOntology();
                        OWLOntologyImpl.this.importedOntologies.add(onto);
                        if (OWLOntologyImpl.this.getForeignOntologies().contains(onto.getURI())) {
                            Iterator iter = OWLOntologyImpl.this.getLinkProperties().iterator();
                            while (iter.hasNext()) {
                                OWLObjectProperty prop = (OWLObjectProperty)iter.next();
                                if (!prop.getLinkTarget().equals(onto.getURI())) continue;
                                SetLinkTarget oc = new SetLinkTarget((OWLOntology)OWLOntologyImpl.this, prop, null, null);
                                this.applyChange((OntologyChange)oc);
                            }
                            Iterator it = OWLOntologyImpl.this.getForeignEntities().keySet().iterator();
                            HashSet<OWLEntity> removedSet = new HashSet<OWLEntity>();
                            while (it.hasNext()) {
                                OWLEntity entidad = (OWLEntity)it.next();
                                if (!OWLOntologyImpl.this.getForeignEntities().get(entidad).equals(onto.getURI())) continue;
                                removedSet.add(entidad);
                            }
                            Iterator j = removedSet.iterator();
                            while (j.hasNext()) {
                                RemoveForeignEntity oc = new RemoveForeignEntity((OWLOntology)OWLOntologyImpl.this, (OWLEntity)j.next(), null);
                                this.applyChange((OntologyChange)oc);
                            }
                        }
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getOntology().getClass() + " in " + OWLOntologyImpl.this);
                    }
                }
            }

            protected void applyChange(OntologyChange oc) throws OWLException {
                oc.accept((ChangeVisitor)OWLOntologyImpl.this);
            }

            public void visit(RemoveImport event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Removed: " + event));
                    try {
                        OWLOntologyImpl onto = (OWLOntologyImpl)event.getImportOntology();
                        OWLOntologyImpl.this.importedOntologies.remove(onto);
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getOntology().getClass() + " in " + OWLOntologyImpl.this);
                    }
                }
            }

            public void visit(SetLogicalURI event) throws OWLException {
                if (event.getOntology() == OWLOntologyImpl.this) {
                    logger.debug((Object)("Change: " + event));
                    try {
                        ((OWLConnectionImpl)OWLOntologyImpl.this.getOWLConnection()).changeOntologyLogicalURI(OWLOntologyImpl.this, event.getURI());
                        OWLOntologyImpl.this.uri = event.getURI();
                        OWLOntologyImpl.this.notifyListeners((OntologyChange)event);
                    }
                    catch (ClassCastException ex) {
                        throw new OWLException("Trying to use unsuitable implementation class: " + event.getOntology().getClass() + " in " + OWLOntologyImpl.this);
                    }
                }
            }
        };
    }

    public OWLClass getClass(URI uri) {
        return (OWLClass)this.classes.get(uri);
    }

    public OWLAnnotationProperty getAnnotationProperty(URI uri) {
        return (OWLAnnotationProperty)this.annotationProperties.get(uri);
    }

    public OWLDataProperty getDataProperty(URI uri) {
        return (OWLDataProperty)this.dataProperties.get(uri);
    }

    public OWLObjectProperty getObjectProperty(URI uri) {
        return (OWLObjectProperty)this.objectProperties.get(uri);
    }

    public OWLIndividual getIndividual(URI uri) {
        return (OWLIndividual)this.individuals.get(uri);
    }

    public OWLDataType getDatatype(URI uri) {
        return (OWLDataType)this.datatypes.get(uri);
    }

    public void visit(AddAnnotationInstance event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(AddEntity event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(AddDataType event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(RemoveEntity event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(AddImport event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(AddIndividualAxiom event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(AddClassAxiom event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(AddPropertyAxiom event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(AddSuperClass event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(AddSuperProperty event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(AddIndividualClass event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(AddEquivalentClass event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(AddEnumeration event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(AddDomain event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(AddDataPropertyRange event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(AddObjectPropertyRange event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(AddInverse event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(SetFunctional event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(SetTransitive event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(SetSymmetric event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(SetInverseFunctional event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(SetOneToOne event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(SetDeprecated event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(AddObjectPropertyInstance event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(AddDataPropertyInstance event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(RemoveClassAxiom event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(RemoveSuperClass event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(RemoveEquivalentClass event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(RemoveEnumeration event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(SetLogicalURI event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    protected void filterEvent(OntologyChange event) throws OWLException {
    }

    protected void handleEvent(OntologyChange event) throws OWLException {
        this.filterEvent(event);
        AddAllEntitiesStrategy strategy = new AddAllEntitiesStrategy();
        ArrayList<OntologyChange> original = new ArrayList<OntologyChange>();
        original.add(event);
        List changes = strategy.computeChanges(original);
        Iterator it = changes.iterator();
        while (it.hasNext()) {
            OntologyChange newOc = (OntologyChange)it.next();
            newOc.accept(this.visitorProxy);
        }
    }

    protected void notifyListeners(OntologyChange event) throws OWLException {
        Iterator it = this.changeListeners.iterator();
        while (it.hasNext()) {
            ((OntologyChangeListener)it.next()).ontologyChanged(event);
        }
    }

    public void addOntologyChangeListener(OntologyChangeListener listener) throws OWLException {
        this.changeListeners.add(listener);
    }

    public void removeOntologyChangeListener(OntologyChangeListener listener) throws OWLException {
        this.changeListeners.remove(listener);
    }

    public void visit(RemoveDomain event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(RemoveDataPropertyRange event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(RemoveObjectPropertyRange event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(RemovePropertyAxiom event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(RemoveIndividualAxiom event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(RemoveDataPropertyInstance event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(RemoveObjectPropertyInstance event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(RemoveSuperProperty event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(RemoveAnnotationInstance event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(RemoveImport event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(RemoveIndividualClass event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(RemoveInverse event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public boolean isForeign(OWLEntity e) {
        return this.foreignEntities.containsKey(e);
    }

    public void visit(SetLinkTarget event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(AddForeignEntity event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public void visit(RemoveForeignEntity event) throws OWLException {
        this.handleEvent((OntologyChange)event);
    }

    public URI getForeignOntology(OWLEntity e) {
        if (this.getForeignEntities().containsKey(e)) {
            return (URI)this.getForeignEntities().get(e);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            OWLOntologyImpl ont = (OWLOntologyImpl)obj;
            if (this.classes.equals(ont.classes) && this.annotationProperties.equals(ont.annotationProperties) && this.dataProperties.equals(ont.dataProperties) && this.objectProperties.equals(ont.objectProperties) && this.individuals.equals(ont.individuals) && this.datatypes.equals(ont.datatypes) && this.anonymousIndividuals == ont.anonymousIndividuals && ((Object)this.classAxioms).equals(ont.classAxioms) && ((Object)this.propertyAxioms).equals(ont.propertyAxioms) && ((Object)this.individualAxioms).equals(ont.individualAxioms) && this.mutable == ont.mutable && ((Object)this.foreignEntities).equals(ont.foreignEntities)) {
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class EntityRemover
    implements OWLEntityVisitor {
        protected EntityRemover() {
        }

        public void visit(OWLClass entity) throws OWLException {
            if (OWLOntologyImpl.this.classes.remove(entity.getURI()) == null) {
                throw new OWLException("Couldn't remove: " + entity.getURI());
            }
            try {
                if (!((OWLEntityImpl)entity).removeOntology(OWLOntologyImpl.this)) {
                    throw new OWLException("Couldn't remove: ");
                }
            }
            catch (ClassCastException ex) {
                throw new OWLException("Trying to remove unsuitable implementation class: " + entity.getClass() + " to " + OWLOntologyImpl.this);
            }
        }

        public void visit(OWLObjectProperty entity) throws OWLException {
            if (OWLOntologyImpl.this.objectProperties.remove(entity.getURI()) == null) {
                throw new OWLException("Couldn't remove: ");
            }
            try {
                if (!((OWLEntityImpl)entity).removeOntology(OWLOntologyImpl.this)) {
                    throw new OWLException("Couldn't remove: ");
                }
            }
            catch (ClassCastException ex) {
                throw new OWLException("Trying to remove unsuitable implementation class: " + entity.getClass() + " to " + OWLOntologyImpl.this);
            }
        }

        public void visit(OWLAnnotationProperty entity) throws OWLException {
            if (OWLOntologyImpl.this.annotationProperties.remove(entity.getURI()) == null) {
                throw new OWLException("Couldn't remove: ");
            }
            try {
                if (!((OWLEntityImpl)entity).removeOntology(OWLOntologyImpl.this)) {
                    throw new OWLException("Couldn't remove: ");
                }
            }
            catch (ClassCastException ex) {
                throw new OWLException("Trying to remove unsuitable implementation class: " + entity.getClass() + " to " + OWLOntologyImpl.this);
            }
        }

        public void visit(OWLDataProperty entity) throws OWLException {
            if (OWLOntologyImpl.this.dataProperties.remove(entity.getURI()) == null) {
                throw new OWLException("Couldn't remove: ");
            }
            try {
                if (!((OWLEntityImpl)entity).removeOntology(OWLOntologyImpl.this)) {
                    throw new OWLException("Couldn't remove: ");
                }
            }
            catch (ClassCastException ex) {
                throw new OWLException("Trying to remove unsuitable implementation class: " + entity.getClass() + " to " + OWLOntologyImpl.this);
            }
        }

        public void visit(OWLIndividual entity) throws OWLException {
            if (OWLOntologyImpl.this.individuals.remove(entity.getURI()) == null) {
                throw new OWLException("Couldn't remove: ");
            }
            try {
                if (!((OWLEntityImpl)entity).removeOntology(OWLOntologyImpl.this)) {
                    throw new OWLException("Couldn't remove: ");
                }
            }
            catch (ClassCastException ex) {
                throw new OWLException("Trying to remove unsuitable implementation class: " + entity.getClass() + " to " + OWLOntologyImpl.this);
            }
        }
    }

    protected class EntityAdder
    implements OWLEntityVisitor {
        protected OntologyChange cause;

        EntityAdder(OntologyChange oc) {
            this.cause = oc;
        }

        public void visit(OWLClass entity) throws OWLException {
            if (!OWLOntologyImpl.this.classes.containsKey(entity.getURI())) {
                OWLOntologyImpl.this.classes.put(entity.getURI(), entity);
                try {
                    ((OWLEntityImpl)entity).addOntology(OWLOntologyImpl.this);
                }
                catch (ClassCastException ex) {
                    throw new OWLException("Trying to add unsuitable implementation class: " + entity.getClass() + " to " + OWLOntologyImpl.this);
                }
                OWLOntologyImpl.this.notifyListeners(this.cause);
            }
        }

        public void visit(OWLObjectProperty entity) throws OWLException {
            if (!OWLOntologyImpl.this.objectProperties.containsKey(entity.getURI())) {
                OWLOntologyImpl.this.objectProperties.put(entity.getURI(), entity);
                try {
                    ((OWLEntityImpl)entity).addOntology(OWLOntologyImpl.this);
                }
                catch (ClassCastException ex) {
                    throw new OWLException("Trying to add unsuitable implementation class: " + entity.getClass() + " to " + OWLOntologyImpl.this);
                }
                OWLOntologyImpl.this.notifyListeners(this.cause);
            }
        }

        public void visit(OWLAnnotationProperty entity) throws OWLException {
            if (!OWLOntologyImpl.this.annotationProperties.containsKey(entity.getURI())) {
                OWLOntologyImpl.this.annotationProperties.put(entity.getURI(), entity);
                try {
                    ((OWLEntityImpl)entity).addOntology(OWLOntologyImpl.this);
                }
                catch (ClassCastException ex) {
                    throw new OWLException("Trying to add unsuitable implementation class: " + entity.getClass() + " to " + OWLOntologyImpl.this);
                }
                OWLOntologyImpl.this.notifyListeners(this.cause);
            }
        }

        public void visit(OWLDataProperty entity) throws OWLException {
            if (!OWLOntologyImpl.this.dataProperties.containsKey(entity.getURI())) {
                OWLOntologyImpl.this.dataProperties.put(entity.getURI(), entity);
                try {
                    ((OWLEntityImpl)entity).addOntology(OWLOntologyImpl.this);
                }
                catch (ClassCastException ex) {
                    throw new OWLException("Trying to add unsuitable implementation class: " + entity.getClass() + " to " + OWLOntologyImpl.this);
                }
                OWLOntologyImpl.this.notifyListeners(this.cause);
            }
        }

        public void visit(OWLIndividual entity) throws OWLException {
            if (!OWLOntologyImpl.this.individuals.containsKey(entity.getURI())) {
                if (entity.isAnonymous()) {
                    ++OWLOntologyImpl.this.anonymousIndividuals;
                    OWLOntologyImpl.this.individuals.put(entity.getAnonId(), entity);
                } else {
                    OWLOntologyImpl.this.individuals.put(entity.getURI(), entity);
                }
                try {
                    ((OWLEntityImpl)entity).addOntology(OWLOntologyImpl.this);
                }
                catch (ClassCastException ex) {
                    throw new OWLException("Trying to add unsuitable implementation class: " + entity.getClass() + " to " + OWLOntologyImpl.this);
                }
                OWLOntologyImpl.this.notifyListeners(this.cause);
            }
        }
    }
}

