/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity.test;

import com.clarkparsia.modularity.IncrementalClassifier;
import com.clarkparsia.modularity.ModuleExtractor;
import com.clarkparsia.owlapi.OWL;
import com.clarkparsia.owlapi.OntologyUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import org.junit.Assert;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.owlapi.Reasoner;
import org.mindswap.pellet.utils.Comparators;
import org.semanticweb.owl.inference.OWLClassReasoner;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.RemoveAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUtils {
    public static <T> void assertToStringEquals(String msg, T[] expected, T[] computed) {
        Comparator comparator = Comparators.stringComparator;
        ArrayList<T> onlyInComputed = new ArrayList<T>();
        ArrayList<T> onlyInExpected = new ArrayList<T>();
        ArrayList<T> both = new ArrayList<T>();
        Arrays.sort(expected, comparator);
        Arrays.sort(computed, comparator);
        int i = 0;
        int j = 0;
        while (i < computed.length && j < expected.length) {
            if (computed[i].equals(expected[j])) {
                both.add(computed[i]);
                ++i;
                ++j;
                continue;
            }
            if (comparator.compare(computed[i], expected[j]) < 0) {
                onlyInComputed.add(computed[i]);
                ++i;
                continue;
            }
            onlyInExpected.add(expected[j]);
            ++j;
        }
        while (i < computed.length) {
            onlyInComputed.add(computed[i++]);
        }
        while (j < expected.length) {
            onlyInExpected.add(expected[j++]);
        }
        if (!onlyInComputed.isEmpty() || !onlyInExpected.isEmpty()) {
            System.err.println(msg);
            System.err.println("Both " + both.size() + " " + both);
            System.err.println("Computed " + onlyInComputed.size() + " " + onlyInComputed);
            System.err.println("Expected " + onlyInExpected.size() + " " + onlyInExpected);
            System.err.println();
            Assert.fail((String)msg);
        }
    }

    public static List<OWLOntologyChange> createChanges(OWLOntology ontology, Collection<? extends OWLAxiom> axioms, boolean add) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        for (OWLAxiom oWLAxiom : axioms) {
            AddAxiom change = add ? new AddAxiom(ontology, oWLAxiom) : new RemoveAxiom(ontology, oWLAxiom);
            changes.add((OWLOntologyChange)change);
        }
        return changes;
    }

    public static <E> Set<E> flatten(Set<Set<E>> setOfSets) {
        HashSet<E> result = new HashSet<E>();
        for (Set<E> set : setOfSets) {
            result.addAll(set);
        }
        return result;
    }

    public static double[] getSizes(Collection<? extends Collection<?>> collections) {
        double[] sizes = new double[collections.size()];
        int i = 0;
        for (Collection<?> collection : collections) {
            sizes[i++] = collection.size();
        }
        return sizes;
    }

    public static OWLAxiom selectRandomAxiom(OWLOntology ontology) throws OWLException {
        Set<OWLAxiom> selectedAxioms = TestUtils.selectRandomAxioms(ontology, 1);
        return selectedAxioms.iterator().next();
    }

    public static Set<OWLAxiom> selectRandomAxioms(OWLOntology ontology, int count) {
        ArrayList axioms = new ArrayList(ontology.getClassAxioms());
        axioms.addAll(ontology.getObjectPropertyAxioms());
        return TestUtils.selectRandomElements(axioms, count);
    }

    public static <T> Set<T> selectRandomElements(Collection<T> coll, int K) {
        int N = coll.size();
        if (K > N) {
            throw new IllegalArgumentException(K + " >= " + N);
        }
        List<Object> list = coll instanceof RandomAccess ? (List<Object>)coll : new ArrayList<T>(coll);
        Random rand = new Random();
        for (int k = 0; k < K; ++k) {
            int j = rand.nextInt(N - k) + k;
            Collections.swap(list, k, j);
        }
        return new HashSet(list.subList(0, K));
    }

    public static void assertTaxonomiesEquals(Collection<OWLClass> classes, OWLClassReasoner a, IncrementalClassifier b) throws OWLReasonerException {
        for (OWLClass cls : classes) {
            Set aEquivalents = a.getEquivalentClasses((OWLDescription)cls);
            Set bEquivalents = b.getEquivalentClasses((OWLDescription)cls);
            Assert.assertEquals((String)("Equivalents different for Class: " + cls), (Object)aEquivalents, (Object)bEquivalents);
            Set aSupers = a.getSuperClasses((OWLDescription)cls);
            Set bSupers = b.getSuperClasses((OWLDescription)cls);
            Assert.assertEquals((String)("Supers different for Class: " + cls), (Object)aSupers, (Object)bSupers);
        }
    }

    public static void runUpdateTest(OWLOntology ontology, ModuleExtractor modExtractor, Collection<OWLAxiom> additions, Collection<OWLAxiom> deletions) throws OWLException {
        Reasoner unified = new Reasoner(OWL.manager);
        IncrementalClassifier modular = new IncrementalClassifier(OWL.manager, unified, modExtractor);
        unified.loadOntologies(Collections.singleton(ontology));
        modular.loadOntologies(Collections.singleton(ontology));
        PelletOptions.USE_CLASSIFICATION_MONITOR = PelletOptions.MonitorType.CONSOLE;
        modular.classify();
        HashSet<Object> chkClses = new HashSet<OWLClass>(ontology.getReferencedClasses());
        chkClses.add(OWL.Nothing);
        TestUtils.assertTaxonomiesEquals(chkClses, (OWLClassReasoner)unified, modular);
        OntologyUtils.addAxioms((OWLOntology)ontology, additions);
        OntologyUtils.removeAxioms((OWLOntology)ontology, deletions);
        modular.classify();
        unified.classify();
        modular.timers.print();
        chkClses = new HashSet(ontology.getReferencedClasses());
        chkClses.add(OWL.Nothing);
        TestUtils.assertTaxonomiesEquals(chkClses, (OWLClassReasoner)unified, modular);
        modular.dispose();
    }

    public static <T> Set<T> set(T ... elements) {
        switch (elements.length) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(elements[0]);
            }
        }
        return new HashSet<T>(Arrays.asList(elements));
    }
}

