/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.classification;

import com.clarkparsia.owlapi.OWL;
import com.clarkparsia.owlapi.OntologyUtils;
import com.clarkparsia.pellet.test.classification.AbstractClassificationTest;
import java.util.ArrayList;
import org.junit.Assert;
import org.mindswap.pellet.owlapi.Reasoner;
import org.semanticweb.owl.model.AxiomType;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLSubClassAxiom;

public class OWLAPIClassificationTest
extends AbstractClassificationTest {
    public void testClassification(String inputOnt, String classifiedOnt) throws OWLOntologyCreationException {
        boolean entailed;
        OWLOntology premise = OntologyUtils.loadOntology((String)inputOnt);
        OWLOntology conclusion = OntologyUtils.loadOntology((String)classifiedOnt);
        Reasoner reasoner = new Reasoner(OWL.manager);
        reasoner.loadOntology(premise);
        reasoner.classify();
        ArrayList<OWLSubClassAxiom> nonEntailments = new ArrayList<OWLSubClassAxiom>();
        for (OWLSubClassAxiom axiom : conclusion.getAxioms(AxiomType.SUBCLASS)) {
            entailed = reasoner.getSubClasses(axiom.getSuperClass()).contains(reasoner.getAllEquivalentClasses(axiom.getSubClass()));
            if (entailed) continue;
            if (AbstractClassificationTest.FAIL_AT_FIRST_ERROR) {
                Assert.fail((String)("Not entailed: " + axiom));
                continue;
            }
            nonEntailments.add(axiom);
        }
        for (OWLSubClassAxiom axiom : conclusion.getAxioms(AxiomType.EQUIVALENT_CLASSES)) {
            entailed = reasoner.isEntailed((OWLAxiom)axiom);
            if (entailed) continue;
            if (AbstractClassificationTest.FAIL_AT_FIRST_ERROR) {
                Assert.fail((String)("Not entailed: " + axiom));
                continue;
            }
            nonEntailments.add(axiom);
        }
        Assert.assertTrue((String)((Object)nonEntailments).toString(), (boolean)nonEntailments.isEmpty());
    }
}

