/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.query;

import com.clarkparsia.pellet.sparqldl.jena.SparqlDLExecutionFactory;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.util.ArrayList;
import java.util.List;
import junit.framework.JUnit4TestAdapter;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mindswap.pellet.jena.PelletReasonerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class TestGroundBooleanQueryComponents {
    private static String sourceDir = "test/data/";
    private static String sourceURL = sourceDir + "misc/food.owl";
    private static String queryPrefix = sourceDir + "/query/ground-boolean-query-components-";
    private SparqlDLExecutionFactory.QueryEngineType queryEngineType;
    private String queryURL;
    private boolean expectedResult;
    private static OntModel model;

    @Parameterized.Parameters
    public static List<Object[]> getParameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (SparqlDLExecutionFactory.QueryEngineType queryEngineType : SparqlDLExecutionFactory.QueryEngineType.values()) {
            for (int q = 1; q <= 4; ++q) {
                String queryFile = queryPrefix + q + ".rq";
                boolean result = q < 3;
                params.add(new Object[]{queryEngineType, queryFile, result});
            }
        }
        return params;
    }

    @BeforeClass
    public static void setUp() {
        sourceURL = "file:" + sourceURL;
        model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(sourceURL);
        model.prepare();
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestGroundBooleanQueryComponents.class);
    }

    public TestGroundBooleanQueryComponents(SparqlDLExecutionFactory.QueryEngineType queryEngineType, String queryURL, boolean expectedResult) {
        this.queryEngineType = queryEngineType;
        this.queryURL = queryURL;
        this.expectedResult = expectedResult;
    }

    @Test
    public void test() {
        Query query = QueryFactory.read((String)this.queryURL);
        DataSource dataset = DatasetFactory.create((Model)model);
        QueryExecution qe = SparqlDLExecutionFactory.create((Query)query, (Dataset)dataset, null, (SparqlDLExecutionFactory.QueryEngineType)this.queryEngineType);
        Assert.assertEquals((String)("Failed query engine: " + this.queryEngineType + " query: " + this.queryURL), (Object)this.expectedResult, (Object)qe.execAsk());
    }
}

