/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.tbox;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.Collections;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import org.junit.Before;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.tbox.TBox;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Pair;

public class TBoxTests {
    private TBox tbox;
    private ATermAppl A = ATermUtils.makeTermAppl((String)"A");
    private ATermAppl B = ATermUtils.makeTermAppl((String)"B");
    private ATermAppl C = ATermUtils.makeTermAppl((String)"C");
    private ATermAppl D = ATermUtils.makeTermAppl((String)"D");

    public static Test suite() {
        return new JUnit4TestAdapter(TBoxTests.class);
    }

    private void prepareTBox() {
        this.tbox.absorb();
        this.tbox.normalize();
        this.tbox.internalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void removedByAbsorbReaddedOnChange() {
        boolean oldTracing = PelletOptions.USE_TRACING;
        PelletOptions.USE_TRACING = true;
        try {
            Assert.assertTrue((boolean)this.tbox.addClass(this.A));
            Assert.assertTrue((boolean)this.tbox.addClass(this.B));
            Assert.assertTrue((boolean)this.tbox.addClass(this.C));
            Assert.assertTrue((boolean)this.tbox.addClass(this.D));
            ATermAppl axiom1 = ATermUtils.makeEqClasses((ATerm)this.A, (ATerm)ATermUtils.makeOr((ATermAppl)this.C, (ATermAppl)this.D));
            Assert.assertTrue((boolean)this.tbox.addAxiom(axiom1));
            ATermAppl axiom2 = ATermUtils.makeSub((ATerm)this.A, (ATerm)this.B);
            Assert.assertTrue((boolean)this.tbox.addAxiom(axiom2));
            Pair unfoldForAxiom2 = new Pair((Object)this.B, Collections.singleton(axiom2));
            this.prepareTBox();
            Assert.assertFalse((boolean)this.tbox.unfold(this.A).contains(unfoldForAxiom2));
            this.tbox.removeAxiom(axiom1);
            this.prepareTBox();
            Assert.assertTrue((boolean)this.tbox.unfold(this.A).contains(unfoldForAxiom2));
        }
        finally {
            PelletOptions.USE_TRACING = oldTracing;
        }
    }

    @org.junit.Test
    public void assertedAxioms() {
        this.tbox.addClass(this.A);
        this.tbox.addClass(this.B);
        this.tbox.addClass(this.C);
        this.tbox.addClass(this.D);
        ATermAppl axiom = ATermUtils.makeSub((ATerm)ATermUtils.makeAnd((ATerm)this.A, (ATerm)this.B), (ATerm)ATermUtils.makeNot((ATerm)this.B));
        this.tbox.addAxiom(axiom);
        this.prepareTBox();
        Assert.assertTrue((this.tbox.getAxioms().size() > 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.tbox.getAxioms().contains(axiom));
        Assert.assertEquals(Collections.singleton(axiom), (Object)this.tbox.getAssertedAxioms());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void removeAssertedAxioms() {
        boolean oldTracing = PelletOptions.USE_TRACING;
        PelletOptions.USE_TRACING = true;
        try {
            this.tbox.addClass(this.A);
            this.tbox.addClass(this.B);
            this.tbox.addClass(this.C);
            this.tbox.addClass(this.D);
            ATermAppl axiom = ATermUtils.makeSub((ATerm)ATermUtils.makeAnd((ATerm)this.A, (ATerm)this.B), (ATerm)ATermUtils.makeNot((ATerm)this.B));
            this.tbox.addAxiom(axiom);
            this.prepareTBox();
            this.tbox.removeAxiom(axiom);
            this.prepareTBox();
            Assert.assertTrue((boolean)this.tbox.getAxioms().isEmpty());
            Assert.assertTrue((boolean)this.tbox.getAssertedAxioms().isEmpty());
        }
        finally {
            PelletOptions.USE_TRACING = oldTracing;
        }
    }

    @Before
    public void resetTBox() {
        KnowledgeBase kb = new KnowledgeBase();
        this.tbox = kb.getTBox();
    }
}

