/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.test.rdfxml;

import com.clarkparsia.pellint.rdfxml.DoubtfulSet;
import com.clarkparsia.pellint.util.CollectionUtil;
import java.util.Collections;
import java.util.Set;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;

public class DoubtfulSetTest
extends TestCase {
    private DoubtfulSet<String> m_Set;
    private String[] m_Str;

    @Before
    public void setUp() {
        this.m_Set = new DoubtfulSet();
        this.m_Str = new String[5];
        for (int i = 0; i < this.m_Str.length; ++i) {
            this.m_Str[i] = "A" + i;
        }
    }

    @Test
    public void testAdd() {
        DoubtfulSetTest.assertTrue((boolean)this.m_Set.isEmpty());
        this.m_Set.add((Object)this.m_Str[0]);
        DoubtfulSetTest.assertEquals((int)1, (int)this.m_Set.size());
        DoubtfulSetTest.assertTrue((boolean)this.m_Set.contains((Object)this.m_Str[0]));
        DoubtfulSetTest.assertFalse((boolean)this.m_Set.containsDefinite((Object)this.m_Str[0]));
        DoubtfulSetTest.assertFalse((boolean)this.m_Set.contains((Object)this.m_Str[1]));
        DoubtfulSetTest.assertFalse((boolean)this.m_Set.containsDefinite((Object)this.m_Str[1]));
        DoubtfulSetTest.assertEquals(Collections.singleton(this.m_Str[0]), (Object)this.m_Set.getDoubtfulElements());
        DoubtfulSetTest.assertTrue((boolean)this.m_Set.getDefiniteElements().isEmpty());
        this.m_Set.add((Object)this.m_Str[0]);
        DoubtfulSetTest.assertEquals((int)1, (int)this.m_Set.size());
    }

    @Test
    public void testAddDefinite() {
        this.m_Set.add((Object)this.m_Str[0]);
        this.m_Set.addDefinite((Object)this.m_Str[1]);
        this.m_Set.add((Object)this.m_Str[2]);
        this.m_Set.addDefinite((Object)this.m_Str[2]);
        this.m_Set.addDefinite((Object)this.m_Str[3]);
        this.m_Set.add((Object)this.m_Str[3]);
        DoubtfulSetTest.assertEquals((int)4, (int)this.m_Set.size());
        DoubtfulSetTest.assertFalse((boolean)this.m_Set.containsDefinite((Object)this.m_Str[0]));
        DoubtfulSetTest.assertTrue((boolean)this.m_Set.containsDefinite((Object)this.m_Str[1]));
        DoubtfulSetTest.assertTrue((boolean)this.m_Set.containsDefinite((Object)this.m_Str[2]));
        DoubtfulSetTest.assertTrue((boolean)this.m_Set.containsDefinite((Object)this.m_Str[3]));
        DoubtfulSetTest.assertEquals(Collections.singleton(this.m_Str[0]), (Object)this.m_Set.getDoubtfulElements());
        DoubtfulSetTest.assertEquals((Object)CollectionUtil.asSet((Object[])new String[]{this.m_Str[1], this.m_Str[2], this.m_Str[3]}), (Object)this.m_Set.getDefiniteElements());
    }

    @Test
    public void testRemove() {
        this.m_Set.add((Object)this.m_Str[0]);
        this.m_Set.add((Object)this.m_Str[1]);
        this.m_Set.addDefinite((Object)this.m_Str[2]);
        this.m_Set.addDefinite((Object)this.m_Str[3]);
        this.m_Set.remove((Object)this.m_Str[0]);
        this.m_Set.remove((Object)this.m_Str[2]);
        this.m_Set.remove((Object)this.m_Str[4]);
        DoubtfulSetTest.assertEquals(Collections.singleton(this.m_Str[1]), (Object)this.m_Set.getDoubtfulElements());
        DoubtfulSetTest.assertEquals(Collections.singleton(this.m_Str[3]), (Object)this.m_Set.getDefiniteElements());
        this.m_Set.clear();
        DoubtfulSetTest.assertTrue((boolean)this.m_Set.getDoubtfulElements().isEmpty());
        DoubtfulSetTest.assertTrue((boolean)this.m_Set.getDefiniteElements().isEmpty());
    }

    @Test
    public void testIteration() {
        this.m_Set.add((Object)this.m_Str[0]);
        this.m_Set.add((Object)this.m_Str[1]);
        this.m_Set.addDefinite((Object)this.m_Str[2]);
        this.m_Set.addDefinite((Object)this.m_Str[3]);
        Set set = CollectionUtil.makeSet();
        for (int i = 0; i <= 3; ++i) {
            set.add(this.m_Str[i]);
        }
        DoubtfulSetTest.assertTrue((boolean)((Object)set).equals(this.m_Set));
        DoubtfulSetTest.assertTrue((boolean)this.m_Set.equals((Object)set));
    }
}

