/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.test.util;

import com.clarkparsia.pellint.util.OptimizedDirectedMultigraph;
import junit.framework.TestCase;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.junit.Before;
import org.junit.Test;

public class OptimizedDirectedMultigraphTest
extends TestCase {
    private static final String[] V = new String[]{"a", "b", "c"};
    private OptimizedDirectedMultigraph<String> m_Graph;

    @Before
    public void setUp() {
        this.m_Graph = new OptimizedDirectedMultigraph();
        for (String v : V) {
            this.m_Graph.addVertex((Object)v);
        }
    }

    @Test
    public void testAddEdgeToNonExistentVertices() {
        try {
            this.m_Graph.addEdge((Object)"alien1", (Object)"alien2");
            OptimizedDirectedMultigraphTest.fail((String)"Adding edge to non-existent vertices should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddEdgeLoop() {
        try {
            this.m_Graph.addEdge((Object)V[0], (Object)V[0]);
            OptimizedDirectedMultigraphTest.fail((String)"Adding a loop should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddEdgeSimple() {
        DefaultWeightedEdge edge = (DefaultWeightedEdge)this.m_Graph.getEdge((Object)V[0], (Object)V[1]);
        OptimizedDirectedMultigraphTest.assertNull((Object)edge);
        edge = this.m_Graph.addEdge((Object)"a", (Object)"b");
        OptimizedDirectedMultigraphTest.assertEquals((int)1, (int)this.m_Graph.getEdgeMultiplicity(edge));
        edge = (DefaultWeightedEdge)this.m_Graph.getEdge((Object)"a", (Object)"b");
        OptimizedDirectedMultigraphTest.assertEquals((int)1, (int)this.m_Graph.getEdgeMultiplicity(edge));
    }

    @Test
    public void testAddEdgeMultiple() {
        this.m_Graph.addEdge((Object)"a", (Object)"b");
        this.m_Graph.addEdge((Object)"a", (Object)"b");
        this.m_Graph.addEdge((Object)"b", (Object)"a");
        this.m_Graph.addEdge((Object)"b", (Object)"a");
        this.m_Graph.addEdge((Object)"a", (Object)"c");
        DefaultWeightedEdge edge = (DefaultWeightedEdge)this.m_Graph.getEdge((Object)"a", (Object)"b");
        OptimizedDirectedMultigraphTest.assertEquals((int)2, (int)this.m_Graph.getEdgeMultiplicity(edge));
        edge = (DefaultWeightedEdge)this.m_Graph.getEdge((Object)"b", (Object)"a");
        OptimizedDirectedMultigraphTest.assertEquals((int)2, (int)this.m_Graph.getEdgeMultiplicity(edge));
        edge = (DefaultWeightedEdge)this.m_Graph.getEdge((Object)"a", (Object)"c");
        OptimizedDirectedMultigraphTest.assertEquals((int)1, (int)this.m_Graph.getEdgeMultiplicity(edge));
    }

    @Test
    public void testAddEdgeWithMultiplicity() {
        this.m_Graph.addEdge((Object)"a", (Object)"b", 10);
        this.m_Graph.addEdge((Object)"a", (Object)"b", 1);
        this.m_Graph.addEdge((Object)"a", (Object)"b", 1);
        DefaultWeightedEdge edge = (DefaultWeightedEdge)this.m_Graph.getEdge((Object)"a", (Object)"b");
        OptimizedDirectedMultigraphTest.assertEquals((int)12, (int)this.m_Graph.getEdgeMultiplicity(edge));
    }

    @Test
    public void testAddEdgeWithInvalidMultiplicity() {
        try {
            this.m_Graph.addEdge((Object)"a", (Object)"b", 0);
            OptimizedDirectedMultigraphTest.fail((String)"Adding non-positive multiplicity should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_Graph.addEdge((Object)"a", (Object)"b", -1);
            OptimizedDirectedMultigraphTest.fail((String)"Adding non-positive multiplicity should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveEdge() {
        this.m_Graph.addEdge((Object)"a", (Object)"b", 10);
        this.m_Graph.removeEdge((Object)"a", (Object)"b");
        DefaultWeightedEdge edge = (DefaultWeightedEdge)this.m_Graph.getEdge((Object)"a", (Object)"b");
        OptimizedDirectedMultigraphTest.assertNull((Object)edge);
    }
}

