/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import java.net.URI;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.owlapi.Reasoner;
import org.mindswap.pellet.test.PelletTestSuite;
import org.mindswap.pellet.utils.SetUtils;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.vocab.XSDVocabulary;

public class OWLAPIAxiomConversionTests {
    public static String base = "file:" + PelletTestSuite.base + "misc/";
    private static String ns = "urn:test#";
    private static OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
    private static OWLDataFactory factory = manager.getOWLDataFactory();
    private static OWLClass c1 = factory.getOWLClass(URI.create(ns + "c1"));
    private static OWLClass c2 = factory.getOWLClass(URI.create(ns + "c2"));
    private static OWLClass c3 = factory.getOWLClass(URI.create(ns + "c3"));
    private static OWLObjectProperty op1 = factory.getOWLObjectProperty(URI.create(ns + "op1"));
    private static OWLObjectProperty op2 = factory.getOWLObjectProperty(URI.create(ns + "op2"));
    private static OWLDataProperty dp1 = factory.getOWLDataProperty(URI.create(ns + "dp1"));
    private static OWLDataProperty dp2 = factory.getOWLDataProperty(URI.create(ns + "dp2"));
    private static OWLIndividual ind1 = factory.getOWLIndividual(URI.create(ns + "ind1"));
    private static OWLIndividual ind2 = factory.getOWLIndividual(URI.create(ns + "ind2"));
    private static OWLIndividual ind3 = factory.getOWLIndividual(URI.create(ns + "ind3"));
    private static OWLIndividual ind4 = factory.getOWLAnonymousIndividual(URI.create(ns + "ind4"));
    private static OWLConstant lit1 = factory.getOWLTypedConstant("lit1", factory.getOWLDataType(XSDVocabulary.STRING.getURI()));
    private static OWLDataType d1 = factory.getOWLDataType(URI.create(ns + "d1"));
    private static boolean DEFAULT_TRACING = PelletOptions.USE_TRACING;

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(OWLAPIAxiomConversionTests.class);
    }

    @BeforeClass
    public static void turnOnTracing() {
        DEFAULT_TRACING = PelletOptions.USE_TRACING;
        PelletOptions.USE_TRACING = true;
    }

    @AfterClass
    public static void turnOffTracing() {
        PelletOptions.USE_TRACING = DEFAULT_TRACING;
    }

    private void testExplanation(OWLAxiom axiom) {
        try {
            URI uri = URI.create(ns + "ont");
            manager.removeOntology(uri);
            OWLOntology ont = manager.createOntology(uri);
            manager.applyChange((OWLOntologyChange)new AddAxiom(ont, axiom));
            Reasoner reasoner = new Reasoner(manager);
            reasoner.getKB().setDoExplanation(true);
            reasoner.loadOntology(ont);
            Assert.assertTrue((String)"Entailment failed", (boolean)reasoner.isEntailed(axiom));
            Set explanation = reasoner.getExplanation();
            Assert.assertEquals((String)"Unexpected explanation", (Object)SetUtils.create((Object[])new OWLAxiom[]{axiom}), (Object)explanation);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Explanation failed");
        }
    }

    @Test
    public void testSubClassAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLSubClassAxiom((OWLDescription)c1, (OWLDescription)c2));
    }

    @Test
    public void testNegativeObjectPropertyAssertion() {
        this.testExplanation((OWLAxiom)factory.getOWLNegativeObjectPropertyAssertionAxiom(ind1, (OWLObjectPropertyExpression)op1, ind2));
    }

    @Test
    public void testAntiSymmetricObjectPropertyAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLAntiSymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)op1));
    }

    @Test
    public void testReflexiveObjectPropertyAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLReflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)op1));
    }

    @Test
    public void testDisjointClassesAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLDisjointClassesAxiom(SetUtils.create((Object[])new OWLClass[]{c1, c2})));
        this.testExplanation((OWLAxiom)factory.getOWLDisjointClassesAxiom(SetUtils.create((Object[])new OWLClass[]{c1, c2, c3})));
    }

    @Test
    public void testDataPropertyDomainAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)dp1, (OWLDescription)c1));
    }

    @Test
    public void testObjectPropertyDomainAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)op1, (OWLDescription)c1));
    }

    @Test
    public void testEquivalentObjectPropertiesAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLEquivalentObjectPropertiesAxiom(SetUtils.create((Object[])new OWLObjectProperty[]{op1, op2})));
    }

    @Test
    public void testNegativeDataPropertyAssertion() {
        this.testExplanation((OWLAxiom)factory.getOWLNegativeDataPropertyAssertionAxiom(ind1, (OWLDataPropertyExpression)dp1, lit1));
    }

    @Test
    public void testDifferentIndividualsAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLDifferentIndividualsAxiom(SetUtils.create((Object[])new OWLIndividual[]{ind1, ind2})));
        this.testExplanation((OWLAxiom)factory.getOWLDifferentIndividualsAxiom(SetUtils.create((Object[])new OWLIndividual[]{ind1, ind2, ind3})));
    }

    @Test
    public void testDisjointDataPropertiesAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLDisjointDataPropertiesAxiom(SetUtils.create((Object[])new OWLDataProperty[]{dp1, dp2})));
    }

    @Test
    public void testDisjointObjectPropertiesAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLDisjointObjectPropertiesAxiom(SetUtils.create((Object[])new OWLObjectProperty[]{op1, op2})));
    }

    @Test
    public void testObjectPropertyRangeAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)op1, (OWLDescription)c1));
    }

    @Test
    public void testObjectPropertyAssertionAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLObjectPropertyAssertionAxiom(ind1, (OWLObjectPropertyExpression)op1, ind2));
    }

    @Test
    public void testFunctionalObjectPropertyAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)op1));
    }

    @Test
    public void testObjectSubPropertyAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLSubObjectPropertyAxiom((OWLObjectPropertyExpression)op1, (OWLObjectPropertyExpression)op2));
    }

    public void _testDisjointUnionAxiom() {
    }

    @Test
    public void testSymmetricObjectPropertyAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLSymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)op1));
    }

    public void testDataPropertyRangeAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)dp1, (OWLDataRange)d1));
    }

    @Test
    public void testFunctionalDataPropertyAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLFunctionalDataPropertyAxiom((OWLDataPropertyExpression)dp1));
    }

    @Test
    public void testEquivalentDataPropertiesAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLEquivalentDataPropertiesAxiom(SetUtils.create((Object[])new OWLDataProperty[]{dp1, dp2})));
    }

    @Test
    public void testClassAssertionAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLClassAssertionAxiom(ind1, (OWLDescription)c1));
    }

    @Test
    @Ignore
    public void testClassAssertionAnonymousIndividualAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLClassAssertionAxiom(ind4, (OWLDescription)c1));
    }

    @Test
    public void testEquivalentClassesAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLEquivalentClassesAxiom(SetUtils.create((Object[])new OWLClass[]{c1, c2})));
    }

    @Test
    public void testDataPropertyAssertionAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLDataPropertyAssertionAxiom(ind1, (OWLDataPropertyExpression)dp1, lit1));
    }

    @Test
    public void testTransitiveObjectPropertyAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLTransitiveObjectPropertyAxiom((OWLObjectPropertyExpression)op1));
    }

    @Test
    public void testIrreflexiveObjectProperty() {
        this.testExplanation((OWLAxiom)factory.getOWLIrreflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)op1));
    }

    @Test
    public void testDataSubPropertyAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLSubDataPropertyAxiom((OWLDataPropertyExpression)dp1, (OWLDataPropertyExpression)dp2));
    }

    @Test
    public void testInverseFunctionalObjectPropertyAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLInverseFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)op1));
    }

    @Test
    public void testSameIndividualsAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLSameIndividualsAxiom(SetUtils.create((Object[])new OWLIndividual[]{ind1, ind2})));
    }

    public void _testObjectPropertyChainSubPropertyAxiom() {
    }

    @Test
    public void testInverseObjectPropertiesAxiom() {
        this.testExplanation((OWLAxiom)factory.getOWLInverseObjectPropertiesAxiom((OWLObjectPropertyExpression)op1, (OWLObjectPropertyExpression)op2));
    }
}

