/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.owlapi.OWL;
import com.clarkparsia.pellet.utils.TermFactory;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.TimeoutException;
import org.mindswap.pellet.owlapi.AxiomConverter;
import org.mindswap.pellet.owlapi.Reasoner;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.test.PelletTestSuite;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.progress.ConsoleProgressMonitor;
import org.mindswap.pellet.utils.progress.ProgressMonitor;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.io.OWLOntologyInputSource;
import org.semanticweb.owl.io.StringInputSource;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLOntologyURIMapper;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.RemoveAxiom;
import org.semanticweb.owl.model.SWRLAtomDObject;
import org.semanticweb.owl.model.SWRLAtomIObject;
import org.semanticweb.owl.model.SWRLClassAtom;
import org.semanticweb.owl.model.SWRLDataValuedPropertyAtom;
import org.semanticweb.owl.model.SWRLObjectPropertyAtom;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;
import org.semanticweb.owl.vocab.XSDVocabulary;
import uk.ac.manchester.cs.owl.OWLOntologyURIMapperImpl;

public class OWLAPITests {
    public static String base = "file:" + PelletTestSuite.base + "misc/";

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(OWLAPITests.class);
    }

    @Test
    public void testOWL2() throws OWLException {
        String ns = "http://www.example.org/test#";
        URI ontURI = URI.create(base + "owl2.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ont = manager.loadOntology(ontURI);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ont);
        Assert.assertTrue((boolean)reasoner.isConsistent());
        OWLClass owlThing = manager.getOWLDataFactory().getOWLClass(OWLRDFVocabulary.OWL_THING.getURI());
        OWLClass C = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "C"));
        OWLClass D = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "D"));
        OWLClass D1 = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "D1"));
        OWLClass D2 = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "D2"));
        OWLClass D3 = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "D3"));
        OWLClass test1 = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "test1"));
        OWLClass test2 = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "test2"));
        OWLClass test3 = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "test3"));
        OWLClass OlderThan10 = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "OlderThan10"));
        OWLClass YoungerThan20 = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "YoungerThan20"));
        OWLClass Teenager = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "Teenager"));
        OWLClass Teen = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "Teen"));
        OWLIndividual ind1 = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "ind1"));
        OWLIndividual ind3 = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "ind3"));
        OWLIndividual ind4 = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "ind4"));
        OWLIndividual ind5 = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "ind5"));
        OWLIndividual ind6 = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "ind6"));
        OWLObjectProperty p = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "p"));
        OWLObjectProperty r = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "r"));
        OWLObjectProperty invR = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "invR"));
        OWLObjectProperty ir = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "ir"));
        OWLObjectProperty as = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "as"));
        OWLObjectProperty d1 = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "d1"));
        OWLObjectProperty d2 = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "d2"));
        Assert.assertTrue((boolean)reasoner.isConsistent());
        Assert.assertTrue((boolean)reasoner.isReflexive(r));
        Assert.assertTrue((boolean)reasoner.isReflexive(invR));
        Assert.assertTrue((boolean)reasoner.isIrreflexive(ir));
        Assert.assertTrue((boolean)reasoner.isAntiSymmetric(as));
        OWLObjectUnionOf union = manager.getOWLDataFactory().getOWLObjectUnionOf(SetUtils.create((Object[])new OWLDescription[]{D1, D2, D3}));
        Assert.assertTrue((boolean)reasoner.isEquivalentClass((OWLDescription)D, (OWLDescription)union));
        Assert.assertTrue((boolean)reasoner.isEquivalentClass((OWLDescription)D, (OWLDescription)test1));
        Assert.assertTrue((boolean)reasoner.isDisjointWith((OWLDescription)D1, (OWLDescription)D2));
        Assert.assertTrue((boolean)reasoner.isDisjointWith((OWLDescription)D1, (OWLDescription)D3));
        Assert.assertTrue((boolean)reasoner.isDisjointWith((OWLDescription)D2, (OWLDescription)D3));
        Assume.assumeTrue((boolean)reasoner.isDisjointWith(d1, d2));
        Assert.assertTrue((boolean)reasoner.isDisjointWith(d2, d1));
        Assert.assertFalse((boolean)reasoner.isDisjointWith(p, r));
        Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(ind1, (OWLObjectPropertyExpression)r, ind1));
        Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(ind1, (OWLObjectPropertyExpression)invR, ind1));
        Assert.assertTrue((boolean)reasoner.isDifferentFrom(ind1, ind3));
        Assert.assertTrue((boolean)reasoner.isDifferentFrom(ind1, ind4));
        Assert.assertTrue((boolean)reasoner.isDifferentFrom(ind5, ind6));
        Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(ind1, (OWLObjectPropertyExpression)p, ind1));
        Assert.assertTrue((boolean)reasoner.hasType(ind1, (OWLDescription)test2));
        Assert.assertTrue((boolean)reasoner.hasType(ind1, (OWLDescription)test3));
        PelletTestCase.assertIteratorValues(SetUtils.union((Collection)reasoner.getTypes(ind1, false)).iterator(), new Object[]{owlThing, C, test2, test3});
        Assert.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)Teenager, (OWLDescription)OlderThan10));
        Assert.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)Teenager, (OWLDescription)YoungerThan20));
        Assert.assertTrue((boolean)reasoner.isEquivalentClass((OWLDescription)Teenager, (OWLDescription)Teen));
    }

    @Test
    public void testUncle() throws OWLException {
        String ns = "http://www.example.org/test#";
        URI ontURI = URI.create(base + "uncle.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ont = manager.loadOntology(ontURI);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ont);
        OWLIndividual Bob = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "Bob"));
        OWLIndividual Sam = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "Sam"));
        OWLObjectProperty uncleOf = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "uncleOf"));
        this.assertPropertyValues(reasoner, Bob, uncleOf, Sam);
    }

    @Test
    public void testSibling() throws OWLException {
        String ns = "http://www.example.org/test#";
        URI ontURI = URI.create(base + "sibling.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ont = manager.loadOntology(ontURI);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ont);
        OWLIndividual Bob = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "Bob"));
        OWLIndividual John = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "John"));
        OWLIndividual Jane = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "Jane"));
        OWLObjectProperty hasBrother = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "hasBrother"));
        OWLObjectProperty hasSister = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "hasSister"));
        this.assertPropertyValues(reasoner, Bob, hasBrother, John);
        this.assertPropertyValues(reasoner, Bob, hasSister, Jane);
    }

    public void assertPropertyValues(Reasoner reasoner, OWLIndividual subj, OWLObjectProperty pred, OWLIndividual ... values) {
        PelletTestCase.assertIteratorValues(reasoner.getRelatedIndividuals(subj, (OWLObjectPropertyExpression)pred).iterator(), values);
        PelletTestCase.assertIteratorValues(((Set)reasoner.getObjectPropertyRelationships(subj).get(pred)).iterator(), values);
    }

    @Test
    public void testPropertyChain() throws OWLException {
        String ns = "http://www.example.org/test#";
        URI ontURI = URI.create(base + "propertyChain.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ont = manager.loadOntology(ontURI);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ont);
        OWLClass C = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "C"));
        OWLClass S0 = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "S0"));
        OWLClass R0 = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "R0"));
        OWLClass R1 = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "R1"));
        OWLObjectProperty r = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "r"));
        OWLObjectProperty s = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "s"));
        OWLIndividual[] a = new OWLIndividual[17];
        for (int i = 0; i < a.length; ++i) {
            a[i] = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "a" + i));
        }
        Object[] theList = new OWLIndividual[]{a[1], a[2], a[3], a[4], a[5], a[6], a[8], a[10], a[12], a[14], a[16]};
        Assert.assertTrue((boolean)reasoner.isConsistent());
        Assert.assertTrue((boolean)reasoner.isTransitive(r));
        Assert.assertFalse((boolean)reasoner.isTransitive(s));
        PelletTestCase.assertIteratorValues(reasoner.getIndividuals((OWLDescription)C, false).iterator(), theList);
        PelletTestCase.assertIteratorValues(reasoner.getIndividuals((OWLDescription)S0, false).iterator(), theList);
        PelletTestCase.assertIteratorValues(reasoner.getIndividuals((OWLDescription)R0, false).iterator(), new OWLIndividual[]{a[7], a[9]});
        PelletTestCase.assertIteratorValues(reasoner.getIndividuals((OWLDescription)R1, false).iterator(), new OWLIndividual[]{a[2], a[3], a[4], a[5], a[6]});
        PelletTestCase.assertIteratorValues(reasoner.getRelatedIndividuals(a[0], (OWLObjectPropertyExpression)r).iterator(), new OWLIndividual[]{a[7], a[9]});
        PelletTestCase.assertIteratorValues(reasoner.getRelatedIndividuals(a[1], (OWLObjectPropertyExpression)r).iterator(), new OWLIndividual[]{a[2], a[3], a[4], a[5], a[6]});
        PelletTestCase.assertIteratorValues(reasoner.getRelatedIndividuals(a[0], (OWLObjectPropertyExpression)s).iterator(), theList);
    }

    @Test
    public void testQualifiedCardinality1() throws OWLException {
        String ns = "http://www.example.org/test#";
        URI ontURI = URI.create(base + "qcr.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ont = manager.loadOntology(ontURI);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ont);
        OWLClass sub = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "sub"));
        OWLClass sup = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "sup"));
        Assert.assertTrue((boolean)reasoner.isConsistent());
        Assert.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)sub, (OWLDescription)sup));
        Assert.assertTrue((boolean)reasoner.getDescendantClasses((OWLDescription)sup).contains(SetUtils.singleton((Object)sub)));
        Assert.assertTrue((boolean)reasoner.getAncestorClasses((OWLDescription)sub).contains(SetUtils.singleton((Object)sup)));
    }

    @Test
    public void testQualifiedCardinality2() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl d = TermFactory.term((String)"d");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl f = TermFactory.term((String)"f");
        ATermAppl sub = TermFactory.term((String)"sub");
        ATermAppl sup = TermFactory.term((String)"sup");
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)f);
        kb.addFunctionalProperty(f);
        kb.addClass(c);
        kb.addClass(d);
        kb.addClass(sub);
        kb.addClass(sup);
        kb.addSubClass(sub, sup);
        Assert.assertTrue((boolean)kb.isSubClassOf(TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.and((ATermAppl)c, (ATermAppl)d)), TermFactory.some((ATermAppl)p, (ATermAppl)c)));
        Assert.assertTrue((boolean)kb.isSubClassOf(TermFactory.max((ATermAppl)p, (int)1, (ATermAppl)sup), TermFactory.max((ATermAppl)p, (int)2, (ATermAppl)sub)));
        Assert.assertTrue((boolean)kb.isSubClassOf(TermFactory.and((ATermAppl)TermFactory.max((ATermAppl)f, (int)1, (ATermAppl)TermFactory.TOP), (ATermAppl)TermFactory.all((ATermAppl)f, (ATermAppl)c)), TermFactory.max((ATermAppl)f, (int)1, (ATermAppl)c)));
        Assert.assertTrue((boolean)kb.isSubClassOf(TermFactory.and((ATermAppl)TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)c), (ATermAppl)TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.not((ATermAppl)c))), TermFactory.min((ATermAppl)p, (int)4, (ATermAppl)TermFactory.TOP)));
    }

    @Test
    public void testReflexive2() throws OWLException {
        String ns = "http://www.example.org/test#";
        String foaf = "http://xmlns.com/foaf/0.1/";
        URI ontURI = URI.create(base + "reflexive.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ont = manager.loadOntology(ontURI);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ont);
        OWLObjectProperty[] knows = new OWLObjectProperty[]{manager.getOWLDataFactory().getOWLObjectProperty(URI.create(foaf + "knows")), manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "knows2")), manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "knows3"))};
        OWLIndividual[] people = new OWLIndividual[5];
        for (int i = 0; i < people.length; ++i) {
            people[i] = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "P" + (i + 1)));
            for (int j = 0; j < knows.length; ++j) {
                Assert.assertTrue((String)(people[i] + " " + knows[j]), (boolean)reasoner.hasObjectPropertyRelationship(people[i], (OWLObjectPropertyExpression)knows[j], people[i]));
                PelletTestCase.assertIteratorValues(reasoner.getRelatedIndividuals(people[i], (OWLObjectPropertyExpression)knows[j]).iterator(), new OWLIndividual[]{people[i]});
            }
        }
        Map answers = PelletTestCase.createMap(new Object[][]{{people[0], people[0]}, {people[1], people[1]}, {people[2], people[2]}, {people[3], people[3]}, {people[4], people[4]}});
        Map result = reasoner.getObjectPropertyAssertions(knows[0]);
        Assert.assertEquals((Object)answers, (Object)result);
    }

    @Test
    public void testInfiniteChain() throws Exception {
        URI ontURI = URI.create(base + "infiniteChain.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ont = manager.loadOntology(ontURI);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ont);
        Assert.assertTrue((!reasoner.isConsistent() ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveLiteral() throws Exception {
        String ns = "http://www.example.org/test#";
        URI ontURI = URI.create(base + "RemoveLiteral.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ont = manager.loadOntology(ontURI);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ont);
        OWLDataProperty pInt = manager.getOWLDataFactory().getOWLDataProperty(URI.create(ns + "pInt"));
        OWLDataProperty pDouble = manager.getOWLDataFactory().getOWLDataProperty(URI.create(ns + "pDouble"));
        OWLDataProperty pBoolean = manager.getOWLDataFactory().getOWLDataProperty(URI.create(ns + "pBoolean"));
        OWLIndividual ind = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "ind"));
        Assert.assertTrue((boolean)reasoner.isConsistent());
        OWLConstant valDouble = reasoner.getRelatedValue(ind, (OWLDataPropertyExpression)pDouble);
        RemoveAxiom change = new RemoveAxiom(ont, (OWLAxiom)manager.getOWLDataFactory().getOWLDataPropertyAssertionAxiom(ind, (OWLDataPropertyExpression)pDouble, valDouble));
        manager.applyChange((OWLOntologyChange)change);
        reasoner.refresh();
        Assert.assertTrue((boolean)reasoner.getRelatedValues(ind, (OWLDataPropertyExpression)pDouble).isEmpty());
        OWLConstant valInt = reasoner.getRelatedValue(ind, (OWLDataPropertyExpression)pInt);
        change = new RemoveAxiom(ont, (OWLAxiom)manager.getOWLDataFactory().getOWLDataPropertyAssertionAxiom(ind, (OWLDataPropertyExpression)pInt, valInt));
        manager.applyChange((OWLOntologyChange)change);
        reasoner.refresh();
        Assert.assertTrue((boolean)reasoner.getRelatedValues(ind, (OWLDataPropertyExpression)pInt).isEmpty());
        OWLConstant valBoolean = reasoner.getRelatedValue(ind, (OWLDataPropertyExpression)pBoolean);
        change = new RemoveAxiom(ont, (OWLAxiom)manager.getOWLDataFactory().getOWLDataPropertyAssertionAxiom(ind, (OWLDataPropertyExpression)pBoolean, valBoolean));
        manager.applyChange((OWLOntologyChange)change);
        reasoner.refresh();
        Assert.assertTrue((boolean)reasoner.getRelatedValues(ind, (OWLDataPropertyExpression)pBoolean).isEmpty());
        Assert.assertTrue((boolean)reasoner.getDataPropertyRelationships(ind).isEmpty());
        OWLTypedConstant newVal = manager.getOWLDataFactory().getOWLTypedConstant("0.0", manager.getOWLDataFactory().getOWLDataType(XSDVocabulary.DOUBLE.getURI()));
        change = new AddAxiom(ont, (OWLAxiom)manager.getOWLDataFactory().getOWLDataPropertyAssertionAxiom(ind, (OWLDataPropertyExpression)pDouble, (OWLConstant)newVal));
        manager.applyChange((OWLOntologyChange)change);
        reasoner.refresh();
        Assert.assertTrue((boolean)reasoner.isConsistent());
    }

    @Test
    @Ignore(value="AUTO_XML_SCHEMA_LOADING is not supported anymore")
    public void testUserDefinedDatatypes() throws Exception {
        PelletOptions.AUTO_XML_SCHEMA_LOADING = true;
        String ns = "http://www.mindswap.org/ontologies/family.owl#";
        OWLOntologyURIMapperImpl mapper = new OWLOntologyURIMapperImpl();
        URI ontURI = URI.create(base + "family-ages.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        manager.addURIMapper((OWLOntologyURIMapper)mapper);
        OWLOntology ont = manager.loadOntology(ontURI);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ont);
        OWLClass Child = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "Child"));
        OWLClass Teenage = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "Teenage"));
        OWLClass Adult = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "Adult"));
        OWLClass Senior = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "Senior"));
        OWLIndividual Daughter = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "Daughter"));
        OWLIndividual Son = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "Son"));
        OWLIndividual Dad = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "Dad"));
        OWLIndividual Grandpa = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "Grandpa"));
        Assert.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)Senior, (OWLDescription)Adult));
        PelletTestCase.assertIteratorValues(reasoner.getSubClasses((OWLDescription)Adult).iterator(), new Object[]{SetUtils.singleton((Object)Senior)});
        Assert.assertTrue((boolean)reasoner.hasType(Daughter, (OWLDescription)Child));
        Assert.assertTrue((boolean)reasoner.hasType(Son, (OWLDescription)Teenage));
        Assert.assertTrue((boolean)reasoner.hasType(Dad, (OWLDescription)Adult));
        Assert.assertTrue((boolean)reasoner.hasType(Grandpa, (OWLDescription)Senior));
        PelletOptions.AUTO_XML_SCHEMA_LOADING = false;
    }

    @Test
    public void testFamily() throws OWLException {
        String ns = "http://www.example.org/family#";
        URI ontURI = URI.create(base + "family.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ont = manager.loadOntology(ontURI);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ont);
        OWLObjectProperty hasBrother = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "hasBrother"));
        OWLObjectProperty hasSon = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "hasSon"));
        OWLObjectProperty hasFather = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "hasFather"));
        OWLObjectProperty hasParent = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "hasParent"));
        OWLObjectProperty hasChild = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "hasChild"));
        OWLObjectProperty hasMother = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "hasMother"));
        OWLObjectProperty hasDaughter = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "hasDaughter"));
        OWLObjectProperty hasAncestor = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "hasAncestor"));
        OWLObjectProperty likes = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "likes"));
        OWLObjectProperty isMarriedTo = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "isMarriedTo"));
        OWLObjectProperty dislikes = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "dislikes"));
        OWLObjectProperty hasSister = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "hasSister"));
        OWLObjectProperty hasDescendant = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "hasDescendant"));
        OWLObjectProperty hasSibling = manager.getOWLDataFactory().getOWLObjectProperty(URI.create(ns + "hasSibling"));
        OWLClass Child = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "Child"));
        OWLClass Person = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "Person"));
        OWLClass PersonWithAtLeastTwoMaleChildren = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "PersonWithAtLeastTwoMaleChildren"));
        OWLClass PersonWithAtLeastTwoFemaleChildren = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "PersonWithAtLeastTwoFemaleChildren"));
        OWLClass PersonWithAtLeastTwoChildren = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "PersonWithAtLeastTwoChildren"));
        OWLClass PersonWithAtLeastFourChildren = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "PersonWithAtLeastFourChildren"));
        OWLClass Teen = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "Teen"));
        OWLClass Teenager = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "Teenager"));
        OWLClass Male = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "Male"));
        OWLClass Adult = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "Adult"));
        OWLClass Female = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "Female"));
        OWLClass Senior = manager.getOWLDataFactory().getOWLClass(URI.create(ns + "Senior"));
        OWLIndividual grandmother = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "grandmother"));
        OWLIndividual grandfather = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "grandfather"));
        OWLIndividual father = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "father"));
        OWLIndividual son = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "son"));
        OWLIndividual mother = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "mother"));
        OWLIndividual daughter = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "daughter"));
        OWLIndividual personX = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "personX"));
        OWLIndividual personY = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "personY"));
        OWLIndividual personZ = manager.getOWLDataFactory().getOWLIndividual(URI.create(ns + "personZ"));
        Assert.assertTrue((boolean)reasoner.isConsistent());
        KnowledgeBase kb = reasoner.getKB();
        for (int test = 0; test < 2; ++test) {
            if (test != 0) {
                kb.realize();
            }
            Assert.assertTrue((boolean)reasoner.isTransitive(hasAncestor));
            Assert.assertFalse((boolean)reasoner.isFunctional(hasAncestor));
            Assert.assertTrue((boolean)reasoner.isTransitive(hasDescendant));
            Assert.assertFalse((boolean)reasoner.isFunctional(hasDescendant));
            Assert.assertTrue((boolean)reasoner.isSymmetric(isMarriedTo));
            Assert.assertTrue((boolean)reasoner.isIrreflexive(isMarriedTo));
            Assert.assertTrue((boolean)reasoner.isSubPropertyOf(hasParent, hasAncestor));
            Assert.assertTrue((boolean)reasoner.isSubPropertyOf(hasFather, hasAncestor));
            Assert.assertTrue((boolean)reasoner.isSubPropertyOf(hasMother, hasAncestor));
            Assert.assertTrue((boolean)reasoner.isSubPropertyOf(hasChild, hasDescendant));
            Assume.assumeTrue((boolean)reasoner.isDisjointWith(likes, dislikes));
            Assume.assumeTrue((boolean)reasoner.isDisjointWith(dislikes, likes));
            Assume.assumeTrue((boolean)reasoner.isDisjointWith(hasFather, hasMother));
            Assume.assumeTrue((boolean)reasoner.isDisjointWith(hasMother, hasFather));
            Assert.assertTrue((boolean)reasoner.hasType(grandfather, (OWLDescription)Person));
            Assert.assertTrue((boolean)reasoner.hasType(grandfather, (OWLDescription)PersonWithAtLeastTwoChildren));
            Assert.assertTrue((boolean)reasoner.hasType(grandfather, (OWLDescription)PersonWithAtLeastTwoMaleChildren));
            Assert.assertTrue((boolean)reasoner.hasType(grandfather, (OWLDescription)Male));
            Assert.assertTrue((boolean)reasoner.hasType(grandfather, (OWLDescription)Senior));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(grandfather, (OWLObjectPropertyExpression)isMarriedTo, grandmother));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(grandfather, (OWLObjectPropertyExpression)hasChild, father));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(grandfather, (OWLObjectPropertyExpression)hasSon, father));
            Assert.assertTrue((boolean)reasoner.isDifferentFrom(grandfather, grandmother));
            Assert.assertTrue((boolean)reasoner.isDifferentFrom(grandfather, father));
            Assert.assertTrue((boolean)reasoner.isDifferentFrom(grandfather, mother));
            Assert.assertTrue((boolean)reasoner.isDifferentFrom(grandfather, son));
            Assert.assertTrue((boolean)reasoner.isDifferentFrom(grandfather, daughter));
            Assert.assertTrue((boolean)reasoner.hasType(grandmother, (OWLDescription)Person));
            Assert.assertTrue((boolean)reasoner.hasType(grandmother, (OWLDescription)Female));
            Assert.assertTrue((boolean)reasoner.hasType(grandmother, (OWLDescription)Senior));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(grandmother, (OWLObjectPropertyExpression)isMarriedTo, grandfather));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(grandmother, (OWLObjectPropertyExpression)hasChild, father));
            Assert.assertFalse((boolean)reasoner.hasObjectPropertyRelationship(grandmother, (OWLObjectPropertyExpression)hasSon, father));
            Assert.assertTrue((boolean)reasoner.hasType(father, (OWLDescription)Person));
            Assert.assertTrue((boolean)reasoner.hasType(father, (OWLDescription)Male));
            Assert.assertTrue((boolean)reasoner.hasType(father, (OWLDescription)Adult));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(father, (OWLObjectPropertyExpression)hasParent, grandfather));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(father, (OWLObjectPropertyExpression)hasParent, grandmother));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(father, (OWLObjectPropertyExpression)hasFather, grandfather));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(father, (OWLObjectPropertyExpression)hasMother, grandmother));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(father, (OWLObjectPropertyExpression)hasChild, son));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(father, (OWLObjectPropertyExpression)hasSon, son));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(father, (OWLObjectPropertyExpression)hasChild, daughter));
            Assert.assertFalse((boolean)reasoner.hasObjectPropertyRelationship(father, (OWLObjectPropertyExpression)hasDaughter, daughter));
            Assert.assertTrue((boolean)reasoner.hasType(mother, (OWLDescription)Person));
            Assert.assertTrue((boolean)reasoner.hasType(mother, (OWLDescription)Female));
            Assert.assertTrue((boolean)reasoner.hasType(son, (OWLDescription)Male));
            Assert.assertTrue((boolean)reasoner.hasType(son, (OWLDescription)Teenager));
            Assert.assertTrue((boolean)reasoner.hasType(son, (OWLDescription)Teen));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(son, (OWLObjectPropertyExpression)hasParent, father));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(son, (OWLObjectPropertyExpression)hasFather, father));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(son, (OWLObjectPropertyExpression)hasSibling, daughter));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(son, (OWLObjectPropertyExpression)hasSister, daughter));
            Assert.assertTrue((boolean)reasoner.hasType(daughter, (OWLDescription)Female));
            Assert.assertTrue((boolean)reasoner.hasType(daughter, (OWLDescription)Child));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(daughter, (OWLObjectPropertyExpression)hasAncestor, grandfather));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(daughter, (OWLObjectPropertyExpression)hasAncestor, grandmother));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(daughter, (OWLObjectPropertyExpression)hasParent, father));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(daughter, (OWLObjectPropertyExpression)hasFather, father));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(daughter, (OWLObjectPropertyExpression)hasParent, mother));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(daughter, (OWLObjectPropertyExpression)hasMother, mother));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(daughter, (OWLObjectPropertyExpression)hasSibling, son));
            Assert.assertFalse((boolean)reasoner.hasObjectPropertyRelationship(daughter, (OWLObjectPropertyExpression)hasBrother, son));
            Assert.assertTrue((boolean)reasoner.isDifferentFrom(personX, personY));
            Assert.assertTrue((boolean)reasoner.isDifferentFrom(personX, personZ));
            Assert.assertTrue((boolean)reasoner.isDifferentFrom(personY, personZ));
            Assert.assertTrue((boolean)reasoner.isEquivalentClass((OWLDescription)Teen, (OWLDescription)Teenager));
            Assert.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)Senior, (OWLDescription)Adult));
            Assert.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)PersonWithAtLeastTwoMaleChildren, (OWLDescription)Person));
            Assert.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)PersonWithAtLeastTwoFemaleChildren, (OWLDescription)Person));
            Assert.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)PersonWithAtLeastTwoChildren, (OWLDescription)Person));
            Assert.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)PersonWithAtLeastFourChildren, (OWLDescription)Person));
            Assert.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)PersonWithAtLeastFourChildren, (OWLDescription)PersonWithAtLeastTwoChildren));
            Assert.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)PersonWithAtLeastTwoMaleChildren, (OWLDescription)PersonWithAtLeastTwoChildren));
            Assert.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)PersonWithAtLeastTwoFemaleChildren, (OWLDescription)PersonWithAtLeastTwoChildren));
            Assert.assertFalse((boolean)reasoner.isSubClassOf((OWLDescription)PersonWithAtLeastTwoFemaleChildren, (OWLDescription)PersonWithAtLeastTwoMaleChildren));
            Assert.assertFalse((boolean)reasoner.isSubClassOf((OWLDescription)PersonWithAtLeastTwoMaleChildren, (OWLDescription)PersonWithAtLeastTwoFemaleChildren));
        }
    }

    @Test
    public void testAnonInverse() throws OWLException {
        String ns = "http://www.example.org/test#";
        URI ontURI = URI.create(base + "anon_inverse.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLDataFactory factory = manager.getOWLDataFactory();
        OWLOntology ont = manager.loadOntology(ontURI);
        OWLClass C = factory.getOWLClass(URI.create(ns + "C"));
        OWLClass D = factory.getOWLClass(URI.create(ns + "D"));
        OWLObjectProperty r = factory.getOWLObjectProperty(URI.create(ns + "r"));
        OWLObjectSomeRestriction desc = factory.getOWLObjectSomeRestriction((OWLObjectPropertyExpression)factory.getOWLObjectPropertyInverse((OWLObjectPropertyExpression)r), (OWLDescription)D);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.loadOntologies(Collections.singleton(ont));
        Assert.assertEquals(Collections.singleton(Collections.singleton(C)), (Object)reasoner.getSubClasses((OWLDescription)desc));
        Assert.assertTrue((boolean)reasoner.isInverseFunctional(factory.getOWLObjectProperty(URI.create(ns + "functionalP"))));
        Assert.assertTrue((boolean)reasoner.isFunctional(factory.getOWLObjectProperty(URI.create(ns + "inverseFunctionalP"))));
        Assert.assertTrue((boolean)reasoner.isTransitive(factory.getOWLObjectProperty(URI.create(ns + "transitiveP"))));
        Assert.assertTrue((boolean)reasoner.isSymmetric(factory.getOWLObjectProperty(URI.create(ns + "symmetricP"))));
        Assert.assertTrue((boolean)reasoner.isReflexive(factory.getOWLObjectProperty(URI.create(ns + "reflexiveP"))));
        Assert.assertTrue((boolean)reasoner.isIrreflexive(factory.getOWLObjectProperty(URI.create(ns + "irreflexiveP"))));
        Assert.assertTrue((boolean)reasoner.isAntiSymmetric(factory.getOWLObjectProperty(URI.create(ns + "asymmetricP"))));
        OWLObjectProperty p1 = factory.getOWLObjectProperty(URI.create(ns + "p1"));
        OWLObjectProperty p2 = factory.getOWLObjectProperty(URI.create(ns + "p2"));
        OWLObjectProperty p3 = factory.getOWLObjectProperty(URI.create(ns + "p3"));
        Assert.assertTrue((boolean)reasoner.isEquivalentProperty(p1, p2));
        Assert.assertTrue((boolean)reasoner.isEquivalentProperty(p1, p3));
        Assert.assertTrue((boolean)reasoner.isEquivalentProperty(p2, p3));
    }

    @Test
    public void testDLSafeRules() throws OWLOntologyCreationException, OWLReasonerException {
        String ns = "http://owldl.com/ontologies/dl-safe.owl#";
        URI ontURI = URI.create(base + "dl-safe.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLDataFactory factory = manager.getOWLDataFactory();
        OWLOntology ont = manager.loadOntology(ontURI);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ont);
        OWLObjectProperty hates = factory.getOWLObjectProperty(URI.create(ns + "hates"));
        OWLObjectProperty sibling = factory.getOWLObjectProperty(URI.create(ns + "sibling"));
        OWLClass BadChild = factory.getOWLClass(URI.create(ns + "BadChild"));
        OWLClass Child = factory.getOWLClass(URI.create(ns + "Child"));
        OWLClass Grandchild = factory.getOWLClass(URI.create(ns + "Grandchild"));
        OWLClass Person = factory.getOWLClass(URI.create(ns + "Person"));
        OWLIndividual Abel = factory.getOWLIndividual(URI.create(ns + "Abel"));
        OWLIndividual Cain = factory.getOWLIndividual(URI.create(ns + "Cain"));
        OWLIndividual Oedipus = factory.getOWLIndividual(URI.create(ns + "Oedipus"));
        OWLIndividual Remus = factory.getOWLIndividual(URI.create(ns + "Remus"));
        OWLIndividual Romulus = factory.getOWLIndividual(URI.create(ns + "Romulus"));
        for (int test = 0; test < 2; ++test) {
            if (test != 0) {
                reasoner.realise();
            }
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(Abel, (OWLObjectPropertyExpression)sibling, Cain));
            PelletTestCase.assertIteratorValues(reasoner.getRelatedIndividuals(Abel, (OWLObjectPropertyExpression)sibling).iterator(), new Object[]{Cain});
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(Cain, (OWLObjectPropertyExpression)sibling, Abel));
            PelletTestCase.assertIteratorValues(reasoner.getRelatedIndividuals(Cain, (OWLObjectPropertyExpression)sibling).iterator(), new Object[]{Abel});
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(Cain, (OWLObjectPropertyExpression)hates, Abel));
            Assert.assertFalse((boolean)reasoner.hasObjectPropertyRelationship(Abel, (OWLObjectPropertyExpression)hates, Cain));
            Assert.assertTrue((boolean)reasoner.hasType(Cain, (OWLDescription)Grandchild));
            Assert.assertTrue((boolean)reasoner.hasType(Cain, (OWLDescription)BadChild));
            Assert.assertFalse((boolean)reasoner.hasObjectPropertyRelationship(Romulus, (OWLObjectPropertyExpression)sibling, Remus));
            Assert.assertTrue((boolean)reasoner.hasType(Romulus, (OWLDescription)Grandchild));
            Assert.assertFalse((boolean)reasoner.hasType(Romulus, (OWLDescription)BadChild));
            Assert.assertTrue((boolean)reasoner.hasType(Oedipus, (OWLDescription)Child));
        }
        PelletTestCase.assertIteratorValues(SetUtils.union((Collection)reasoner.getTypes(Cain, true)).iterator(), new Object[]{BadChild, Child, Person});
    }

    @Test
    public void testDLSafeConstants() throws OWLReasonerException, OWLOntologyCreationException {
        String ns = "http://owldl.com/ontologies/dl-safe-constants.owl#";
        URI ontURI = URI.create(base + "dl-safe-constants.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLDataFactory factory = manager.getOWLDataFactory();
        OWLOntology ont = manager.loadOntology(ontURI);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ont);
        OWLClass DreamTeamMember = factory.getOWLClass(URI.create(ns + "DreamTeamMember"));
        OWLClass DreamTeamMember1 = factory.getOWLClass(URI.create(ns + "DreamTeamMember1"));
        OWLClass DreamTeamMember2 = factory.getOWLClass(URI.create(ns + "DreamTeamMember2"));
        OWLIndividual Alice = factory.getOWLIndividual(URI.create(ns + "Alice"));
        OWLIndividual Bob = factory.getOWLIndividual(URI.create(ns + "Bob"));
        OWLIndividual Charlie = factory.getOWLIndividual(URI.create(ns + "Charlie"));
        for (int test = 0; test < 1; ++test) {
            if (test != 0) {
                reasoner.realise();
            }
            PelletTestCase.assertIteratorValues(reasoner.getIndividuals((OWLDescription)DreamTeamMember, false).iterator(), new Object[]{Alice, Bob, Charlie});
            PelletTestCase.assertIteratorValues(reasoner.getIndividuals((OWLDescription)DreamTeamMember1, false).iterator(), new Object[]{Alice, Bob, Charlie});
            PelletTestCase.assertIteratorValues(reasoner.getIndividuals((OWLDescription)DreamTeamMember2, false).iterator(), new Object[]{Alice, Bob, Charlie});
        }
    }

    @Test
    public void testInvalidTransitivity() throws Exception {
        String ns = "http://www.example.org/test#";
        URI ontURI = URI.create(ns);
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLDataFactory factory = manager.getOWLDataFactory();
        OWLOntology ont = manager.createOntology(ontURI);
        OWLClass C = factory.getOWLClass(URI.create(ns + "C"));
        OWLObjectProperty p1 = factory.getOWLObjectProperty(URI.create(ns + "p1"));
        manager.applyChange((OWLOntologyChange)new AddAxiom(ont, (OWLAxiom)factory.getOWLTransitiveObjectPropertyAxiom((OWLObjectPropertyExpression)p1)));
        OWLObjectProperty p2 = factory.getOWLObjectProperty(URI.create(ns + "p2"));
        OWLIndividual x = factory.getOWLIndividual(URI.create(ns + "x"));
        OWLIndividual y = factory.getOWLIndividual(URI.create(ns + "y"));
        OWLIndividual z = factory.getOWLIndividual(URI.create(ns + "z"));
        manager.applyChange((OWLOntologyChange)new AddAxiom(ont, (OWLAxiom)factory.getOWLClassAssertionAxiom(x, (OWLDescription)factory.getOWLObjectAllRestriction((OWLObjectPropertyExpression)p1, (OWLDescription)C))));
        manager.applyChange((OWLOntologyChange)new AddAxiom(ont, (OWLAxiom)factory.getOWLObjectPropertyAssertionAxiom(x, (OWLObjectPropertyExpression)p1, y)));
        manager.applyChange((OWLOntologyChange)new AddAxiom(ont, (OWLAxiom)factory.getOWLObjectPropertyAssertionAxiom(y, (OWLObjectPropertyExpression)p1, z)));
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ont);
        Assert.assertTrue((boolean)reasoner.hasType(y, (OWLDescription)C));
        Assert.assertTrue((boolean)reasoner.hasType(z, (OWLDescription)C));
        OWLAxiom[] axioms = new OWLAxiom[]{factory.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)p1), factory.getOWLInverseFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)p1), factory.getOWLIrreflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)p1), factory.getOWLAntiSymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)p1), factory.getOWLDisjointObjectPropertiesAxiom(PelletTestCase.set(p1, p2)), factory.getOWLSubClassAxiom((OWLDescription)C, (OWLDescription)factory.getOWLObjectMinCardinalityRestriction((OWLObjectPropertyExpression)p1, 2)), factory.getOWLClassAssertionAxiom(x, (OWLDescription)factory.getOWLObjectMaxCardinalityRestriction((OWLObjectPropertyExpression)p1, 3)), factory.getOWLDisjointClassesAxiom(PelletTestCase.set(C, factory.getOWLObjectMinCardinalityRestriction((OWLObjectPropertyExpression)p1, 2)))};
        for (int i = 0; i < axioms.length; ++i) {
            manager.applyChange((OWLOntologyChange)new AddAxiom(ont, axioms[i]));
            reasoner = new Reasoner(manager);
            reasoner.setOntology(ont);
            Assert.assertTrue((String)axioms[i].toString(), (boolean)reasoner.isEntailed((OWLAxiom)factory.getOWLClassAssertionAxiom(y, (OWLDescription)C)));
            Assert.assertFalse((String)axioms[i].toString(), (boolean)reasoner.isEntailed((OWLAxiom)factory.getOWLClassAssertionAxiom(z, (OWLDescription)C)));
            manager.applyChange((OWLOntologyChange)new RemoveAxiom(ont, axioms[i]));
        }
    }

    @Test
    public void testInvalidTransitivity2() throws OWLOntologyCreationException {
        URI ontURI = URI.create(base + "invalidTransitivity.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ont = manager.loadOntology(ontURI);
        for (OWLAxiom axiom : ont.getAxioms()) {
            System.out.println(axiom);
        }
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ont);
        KnowledgeBase kb = reasoner.getKB();
        kb.prepare();
        for (Role r : kb.getRBox().getRoles()) {
            Assert.assertTrue((String)r.toString(), (boolean)r.isSimple());
            Assert.assertFalse((String)r.toString(), (boolean)r.isTransitive());
        }
        for (ATermAppl p : kb.getObjectProperties()) {
            Assert.assertFalse((String)p.toString(), (boolean)kb.isTransitiveProperty(p));
        }
    }

    @Test
    public void testSameAs1() throws OWLException {
        String ns = "urn:test:";
        URI ontURI = URI.create(base + "invalidTransitivity.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLDataFactory factory = manager.getOWLDataFactory();
        OWLOntology ont = manager.createOntology(ontURI);
        OWLIndividual a = factory.getOWLIndividual(URI.create(ns + "a"));
        OWLIndividual b = factory.getOWLIndividual(URI.create(ns + "b"));
        OWLIndividual c = factory.getOWLIndividual(URI.create(ns + "c"));
        OWLObjectProperty p = factory.getOWLObjectProperty(URI.create(ns + "p"));
        OWLObjectProperty q = factory.getOWLObjectProperty(URI.create(ns + "q"));
        HashSet<Object> axioms = new HashSet<Object>();
        axioms.add(factory.getOWLObjectPropertyAssertionAxiom(a, (OWLObjectPropertyExpression)p, c));
        axioms.add(factory.getOWLObjectPropertyAssertionAxiom(b, (OWLObjectPropertyExpression)p, b));
        axioms.add(factory.getOWLObjectPropertyAssertionAxiom(c, (OWLObjectPropertyExpression)q, a));
        axioms.add(factory.getOWLSameIndividualsAxiom(SetUtils.create((Object[])new OWLIndividual[]{b, c})));
        axioms.add(factory.getOWLObjectPropertyAssertionAxiom(a, (OWLObjectPropertyExpression)q, c));
        manager.addAxioms(ont, axioms);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.loadOntology(ont);
        Assert.assertEquals((Object)reasoner.getSameAsIndividuals(a), Collections.emptySet());
        Assert.assertEquals((Object)reasoner.getSameAsIndividuals(b), Collections.singleton(c));
        Assert.assertEquals((Object)reasoner.getSameAsIndividuals(c), Collections.singleton(b));
        Assert.assertEquals(reasoner.getObjectPropertyRelationships(a).get(p), (Object)SetUtils.create((Object[])new OWLIndividual[]{b, c}));
        Assert.assertEquals(reasoner.getObjectPropertyRelationships(a).get(q), (Object)SetUtils.create((Object[])new OWLIndividual[]{b, c}));
        Assert.assertEquals(reasoner.getObjectPropertyRelationships(b).get(p), (Object)SetUtils.create((Object[])new OWLIndividual[]{b, c}));
        Assert.assertEquals(reasoner.getObjectPropertyRelationships(b).get(q), (Object)SetUtils.create((Object[])new OWLIndividual[]{a}));
        Assert.assertEquals(reasoner.getObjectPropertyRelationships(c).get(p), (Object)SetUtils.create((Object[])new OWLIndividual[]{b, c}));
        Assert.assertEquals(reasoner.getObjectPropertyRelationships(c).get(q), (Object)SetUtils.create((Object[])new OWLIndividual[]{a}));
    }

    @Test
    public void testSameAs3() throws OWLException {
        String ns = "urn:test:";
        URI ontURI = URI.create(base + "test.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLDataFactory factory = manager.getOWLDataFactory();
        OWLOntology ont = manager.createOntology(ontURI);
        OWLIndividual i1 = factory.getOWLIndividual(URI.create(ns + "i1"));
        OWLIndividual i2 = factory.getOWLIndividual(URI.create(ns + "i2"));
        OWLIndividual i3 = factory.getOWLIndividual(URI.create(ns + "i3"));
        OWLClass c = factory.getOWLClass(URI.create(ns + "c"));
        HashSet<Object> axioms = new HashSet<Object>();
        axioms.add(factory.getOWLEquivalentClassesAxiom((OWLDescription)c, (OWLDescription)factory.getOWLObjectOneOf(new OWLIndividual[]{i1, i2})));
        axioms.add(factory.getOWLClassAssertionAxiom(i3, (OWLDescription)c));
        manager.addAxioms(ont, axioms);
        Reasoner reasoner = new Reasoner(manager);
        Assert.assertTrue((!reasoner.isSameAs(i1, i2) ? 1 : 0) != 0);
        Assert.assertTrue((!reasoner.isSameAs(i1, i3) ? 1 : 0) != 0);
        Assert.assertEquals((Object)reasoner.getSameAsIndividuals(i1), Collections.emptySet());
        Assert.assertTrue((!reasoner.isSameAs(i2, i1) ? 1 : 0) != 0);
        Assert.assertTrue((!reasoner.isSameAs(i2, i3) ? 1 : 0) != 0);
        Assert.assertEquals((Object)reasoner.getSameAsIndividuals(i2), Collections.emptySet());
        Assert.assertTrue((!reasoner.isSameAs(i3, i1) ? 1 : 0) != 0);
        Assert.assertTrue((!reasoner.isSameAs(i3, i2) ? 1 : 0) != 0);
        Assert.assertEquals((Object)reasoner.getSameAsIndividuals(i2), Collections.emptySet());
    }

    @Test
    public void testRealizeByIndividualsNPE() throws Exception {
        PelletOptions.REALIZE_INDIVIDUAL_AT_A_TIME = false;
        TimedProgressMonitor monitor = new TimedProgressMonitor(1);
        URI ontURI = URI.create(base + "food.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        Reasoner pellet = new Reasoner(manager);
        KnowledgeBase kb = pellet.getKB();
        OWLOntology ont = manager.loadOntology(ontURI);
        pellet.loadOntology(ont);
        kb.classify();
        kb.getTaxonomyBuilder().setProgressMonitor((ProgressMonitor)monitor);
        kb.realize();
        Assert.assertFalse((boolean)kb.isRealized());
    }

    @Test
    public void testClassificationTimeout() throws Exception {
        boolean timeout = false;
        URI ontURI = URI.create(base + "food.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        Reasoner pellet = new Reasoner(manager);
        KnowledgeBase kb = pellet.getKB();
        Timer timer = kb.timers.createTimer("classify");
        timer.setTimeout(1L);
        OWLOntology ont = manager.loadOntology(ontURI);
        pellet.loadOntology(ont);
        try {
            kb.classify();
        }
        catch (TimeoutException e) {
            timeout = true;
        }
        Assert.assertTrue((boolean)timeout);
        Assert.assertFalse((boolean)kb.isClassified());
    }

    @Test
    public void testRealizationTimeout() throws Exception {
        boolean timeout = false;
        URI ontURI = URI.create(base + "food.owl");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        Reasoner pellet = new Reasoner(manager);
        KnowledgeBase kb = pellet.getKB();
        Timer timer = kb.timers.createTimer("realize");
        timer.setTimeout(1L);
        OWLOntology ont = manager.loadOntology(ontURI);
        pellet.loadOntology(ont);
        try {
            kb.classify();
        }
        catch (TimeoutException e) {
            timeout = true;
        }
        Assert.assertFalse((boolean)timeout);
        Assert.assertTrue((boolean)kb.isClassified());
        try {
            kb.realize();
        }
        catch (TimeoutException e) {
            timeout = true;
        }
        Assert.assertTrue((boolean)timeout);
        Assert.assertFalse((boolean)kb.isRealized());
    }

    @Test
    public void testAxiomConverterRules1() {
        KnowledgeBase kb = new KnowledgeBase();
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLDataFactory df = manager.getOWLDataFactory();
        AxiomConverter converter = new AxiomConverter(kb, df);
        ATermAppl C = ATermUtils.makeTermAppl((String)"C");
        ATermAppl D = ATermUtils.makeTermAppl((String)"D");
        ATermAppl x = ATermUtils.makeVar((String)"x");
        kb.addClass(C);
        kb.addClass(D);
        ATermAppl[] head = new ATermAppl[]{ATermUtils.makeTypeAtom((ATermAppl)x, (ATermAppl)D)};
        ATermAppl[] body = new ATermAppl[]{ATermUtils.makeTypeAtom((ATermAppl)x, (ATermAppl)C)};
        ATermAppl rule = ATermUtils.makeRuleAtom((ATermAppl[])head, (ATermAppl[])body);
        OWLAxiom actual = converter.convert(rule);
        HashSet<SWRLClassAtom> antecedent = new HashSet<SWRLClassAtom>();
        HashSet<SWRLClassAtom> consequent = new HashSet<SWRLClassAtom>();
        antecedent.add(df.getSWRLClassAtom((OWLDescription)df.getOWLClass(URI.create("C")), (SWRLAtomIObject)df.getSWRLAtomIVariable(URI.create("x"))));
        consequent.add(df.getSWRLClassAtom((OWLDescription)df.getOWLClass(URI.create("D")), (SWRLAtomIObject)df.getSWRLAtomIVariable(URI.create("x"))));
        SWRLRule expected = df.getSWRLRule(antecedent, consequent);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAxiomConverterRules2() {
        KnowledgeBase kb = new KnowledgeBase();
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLDataFactory df = manager.getOWLDataFactory();
        AxiomConverter converter = new AxiomConverter(kb, df);
        ATermAppl C = ATermUtils.makeTermAppl((String)"C");
        ATermAppl D = ATermUtils.makeTermAppl((String)"D");
        ATermAppl i = ATermUtils.makeTermAppl((String)"i");
        kb.addClass(C);
        kb.addClass(D);
        kb.addIndividual(i);
        ATermAppl[] head = new ATermAppl[]{ATermUtils.makeTypeAtom((ATermAppl)i, (ATermAppl)D)};
        ATermAppl[] body = new ATermAppl[]{ATermUtils.makeTypeAtom((ATermAppl)i, (ATermAppl)C)};
        ATermAppl rule = ATermUtils.makeRuleAtom((ATermAppl[])head, (ATermAppl[])body);
        OWLAxiom actual = converter.convert(rule);
        HashSet<SWRLClassAtom> antecedent = new HashSet<SWRLClassAtom>();
        HashSet<SWRLClassAtom> consequent = new HashSet<SWRLClassAtom>();
        antecedent.add(df.getSWRLClassAtom((OWLDescription)df.getOWLClass(URI.create("C")), (SWRLAtomIObject)df.getSWRLAtomIndividualObject(df.getOWLIndividual(URI.create("i")))));
        consequent.add(df.getSWRLClassAtom((OWLDescription)df.getOWLClass(URI.create("D")), (SWRLAtomIObject)df.getSWRLAtomIndividualObject(df.getOWLIndividual(URI.create("i")))));
        SWRLRule expected = df.getSWRLRule(antecedent, consequent);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAxiomConverterRules3() {
        KnowledgeBase kb = new KnowledgeBase();
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLDataFactory df = manager.getOWLDataFactory();
        AxiomConverter converter = new AxiomConverter(kb, df);
        ATermAppl p = ATermUtils.makeTermAppl((String)"p");
        ATermAppl q = ATermUtils.makeTermAppl((String)"q");
        ATermAppl x = ATermUtils.makeVar((String)"x");
        ATermAppl y = ATermUtils.makeVar((String)"y");
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)q);
        ATermAppl[] head = new ATermAppl[]{ATermUtils.makePropAtom((ATermAppl)q, (ATermAppl)x, (ATermAppl)y)};
        ATermAppl[] body = new ATermAppl[]{ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)x, (ATermAppl)y)};
        ATermAppl rule = ATermUtils.makeRuleAtom((ATermAppl[])head, (ATermAppl[])body);
        OWLAxiom actual = converter.convert(rule);
        HashSet<SWRLObjectPropertyAtom> antecedent = new HashSet<SWRLObjectPropertyAtom>();
        HashSet<SWRLObjectPropertyAtom> consequent = new HashSet<SWRLObjectPropertyAtom>();
        antecedent.add(df.getSWRLObjectPropertyAtom((OWLObjectPropertyExpression)df.getOWLObjectProperty(URI.create("p")), (SWRLAtomIObject)df.getSWRLAtomIVariable(URI.create("x")), (SWRLAtomIObject)df.getSWRLAtomIVariable(URI.create("y"))));
        consequent.add(df.getSWRLObjectPropertyAtom((OWLObjectPropertyExpression)df.getOWLObjectProperty(URI.create("q")), (SWRLAtomIObject)df.getSWRLAtomIVariable(URI.create("x")), (SWRLAtomIObject)df.getSWRLAtomIVariable(URI.create("y"))));
        SWRLRule expected = df.getSWRLRule(antecedent, consequent);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAxiomConverterRules4() {
        KnowledgeBase kb = new KnowledgeBase();
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLDataFactory df = manager.getOWLDataFactory();
        AxiomConverter converter = new AxiomConverter(kb, df);
        ATermAppl r = ATermUtils.makeTermAppl((String)"r");
        ATermAppl s = ATermUtils.makeTermAppl((String)"s");
        ATermAppl x = ATermUtils.makeVar((String)"x");
        ATermAppl y = ATermUtils.makeVar((String)"y");
        kb.addDatatypeProperty((ATerm)r);
        kb.addDatatypeProperty((ATerm)s);
        ATermAppl[] head = new ATermAppl[]{ATermUtils.makePropAtom((ATermAppl)r, (ATermAppl)x, (ATermAppl)y)};
        ATermAppl[] body = new ATermAppl[]{ATermUtils.makePropAtom((ATermAppl)s, (ATermAppl)x, (ATermAppl)y)};
        ATermAppl rule = ATermUtils.makeRuleAtom((ATermAppl[])head, (ATermAppl[])body);
        OWLAxiom actual = converter.convert(rule);
        HashSet<SWRLDataValuedPropertyAtom> antecedent = new HashSet<SWRLDataValuedPropertyAtom>();
        HashSet<SWRLDataValuedPropertyAtom> consequent = new HashSet<SWRLDataValuedPropertyAtom>();
        antecedent.add(df.getSWRLDataValuedPropertyAtom((OWLDataPropertyExpression)df.getOWLDataProperty(URI.create("s")), (SWRLAtomIObject)df.getSWRLAtomIVariable(URI.create("x")), (SWRLAtomDObject)df.getSWRLAtomDVariable(URI.create("y"))));
        consequent.add(df.getSWRLDataValuedPropertyAtom((OWLDataPropertyExpression)df.getOWLDataProperty(URI.create("r")), (SWRLAtomIObject)df.getSWRLAtomIVariable(URI.create("x")), (SWRLAtomDObject)df.getSWRLAtomDVariable(URI.create("y"))));
        SWRLRule expected = df.getSWRLRule(antecedent, consequent);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void typeInhertianceWithAnonIndividual() throws OWLOntologyCreationException {
        String ns = "foo://test#";
        String src = "@prefix ex: <" + ns + "> .\r\n" + "@prefix rdfs:  <http://www.w3.org/2000/01/rdf-schema#> .\r\n" + "@prefix owl: <http://www.w3.org/2002/07/owl#> .\r\n" + "\r\n" + "ex:C rdfs:subClassOf ex:D .\r\n" + "[] a ex:C .";
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        Reasoner pellet = new Reasoner(manager);
        OWLOntology ont = manager.loadOntology((OWLOntologyInputSource)new StringInputSource(src));
        pellet.loadOntology(ont);
        OWLClass D = OWL.Class((String)(ns + "D"));
        Assert.assertTrue((pellet.getIndividuals((OWLDescription)D, true).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((pellet.getIndividuals((OWLDescription)D, false).size() == 1 ? 1 : 0) != 0);
    }

    public static class TimedProgressMonitor
    extends ConsoleProgressMonitor {
        private int limit;

        public TimedProgressMonitor(int limit) {
            this.limit = limit;
        }

        public void taskFinished() {
            super.taskFinished();
        }

        public void taskStarted() {
            super.taskStarted();
        }

        public boolean isCanceled() {
            long elapsedTime = System.currentTimeMillis() - this.startTime;
            return elapsedTime > (long)this.limit;
        }
    }
}

