/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import aterm.ATerm;
import aterm.ATermAppl;
import java.net.URI;
import junit.framework.JUnit4TestAdapter;
import org.junit.Assert;
import org.junit.Test;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.owlapi.Reasoner;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.utils.ATermUtils;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.vocab.OWLRestrictedDataRangeFacetVocabulary;
import org.semanticweb.owl.vocab.XSDVocabulary;

public class TestIsClass {
    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestIsClass.class);
    }

    @Test
    public void testIsClass1() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl p = PelletTestCase.term("p");
        ATermAppl l = ATermUtils.makeTermAppl((String)"l");
        ATermAppl v = ATermUtils.makeValue((ATerm)ATermUtils.makeLiteral((ATermAppl)l));
        ATermAppl c = ATermUtils.makeSomeValues((ATerm)p, (ATerm)v);
        kb.addProperty(p);
        Assert.assertTrue((boolean)kb.isClass((ATerm)c));
    }

    @Test
    public void testIsClass2() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl l = ATermUtils.makeTermAppl((String)"l");
        ATermAppl v = ATermUtils.makeValue((ATerm)ATermUtils.makeLiteral((ATermAppl)l));
        Assert.assertFalse((boolean)kb.isClass((ATerm)v));
    }

    @Test
    public void testIsClass3() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl l1 = ATermUtils.makeTermAppl((String)"l1");
        ATermAppl l2 = ATermUtils.makeTermAppl((String)"l2");
        ATermAppl v1 = ATermUtils.makeValue((ATerm)ATermUtils.makeLiteral((ATermAppl)l1));
        ATermAppl v2 = ATermUtils.makeValue((ATerm)ATermUtils.makeLiteral((ATermAppl)l2));
        ATermAppl t = ATermUtils.makeOr((ATermAppl)v1, (ATermAppl)v2);
        Assert.assertFalse((boolean)kb.isClass((ATerm)t));
    }

    @Test
    public void testIsClass4() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl l = ATermUtils.makeTermAppl((String)"l");
        ATermAppl v = ATermUtils.makeValue((ATerm)ATermUtils.makeLiteral((ATermAppl)l));
        ATermAppl n = ATermUtils.makeNot((ATerm)v);
        Assert.assertFalse((boolean)kb.isClass((ATerm)n));
    }

    @Test
    public void testIsClass5() throws OWLException {
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLDataFactory factory = manager.getOWLDataFactory();
        OWLOntology ontology = manager.createOntology(URI.create("http://example.org"));
        OWLDataType dataRange = factory.getOWLDataType(XSDVocabulary.INTEGER.getURI());
        OWLDataRangeFacetRestriction dataRangeFacetRestriction = factory.getOWLDataRangeFacetRestriction(OWLRestrictedDataRangeFacetVocabulary.MIN_EXCLUSIVE, 1);
        OWLDataRangeRestriction dataRangeRestriction = factory.getOWLDataRangeRestriction((OWLDataRange)dataRange, new OWLDataRangeFacetRestriction[]{dataRangeFacetRestriction});
        OWLDataProperty p = factory.getOWLDataProperty(URI.create("http://example#p"));
        OWLDataSomeRestriction dataSomeRestriction = factory.getOWLDataSomeRestriction((OWLDataPropertyExpression)p, (OWLDataRange)dataRangeRestriction);
        OWLClass c = factory.getOWLClass(URI.create("http://example#c"));
        OWLSubClassAxiom sc = factory.getOWLSubClassAxiom((OWLDescription)c, (OWLDescription)dataSomeRestriction);
        manager.addAxiom(ontology, (OWLAxiom)sc);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.loadOntology(ontology);
        Assert.assertTrue((boolean)reasoner.isConsistent());
        KnowledgeBase kb = reasoner.getKB();
        Assert.assertTrue((boolean)kb.isClass((ATerm)PelletTestCase.term("http://example#c")));
        ATermAppl term = reasoner.getLoader().term((OWLObject)dataSomeRestriction);
        term = ATermUtils.normalize((ATermAppl)term);
        Assert.assertTrue((boolean)kb.isClass((ATerm)term));
    }
}

