/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test.inctest;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import junit.framework.JUnit4TestAdapter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.datatypes.RDFSLiteral;
import org.mindswap.pellet.datatypes.XSDString;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class IncConsistencyTests {
    private KnowledgeBase kb;
    private boolean preUCQ;
    private boolean preUIC;
    private boolean preUSR;
    private boolean preUT;
    private boolean preUID;
    private boolean ucq;
    private boolean uic;
    private boolean uid;
    private static final boolean PRINT_ABOX = false;
    private ATermAppl robert = TermFactory.term((String)"Robert");
    private ATermAppl mary = TermFactory.term((String)"Mary");
    private ATermAppl chris = TermFactory.term((String)"Chris");
    private ATermAppl john = TermFactory.term((String)"John");
    private ATermAppl bill = TermFactory.term((String)"Bill");
    private ATermAppl victor = TermFactory.term((String)"Victor");
    private ATermAppl mbox = TermFactory.term((String)"mbox");
    private ATermAppl relative = TermFactory.term((String)"relative");
    private ATermAppl sibling = TermFactory.term((String)"sibling");
    private ATermAppl person = TermFactory.term((String)"person");
    private ATermAppl animalOwner = TermFactory.term((String)"animalOwner");
    private ATermAppl owns = TermFactory.term((String)"owns");
    private ATermAppl ownedBy = TermFactory.term((String)"ownedBy");
    private ATermAppl knows = TermFactory.term((String)"knows");
    private ATermAppl notPerson = TermFactory.not((ATermAppl)this.person);
    private ATermAppl man = TermFactory.term((String)"man");
    private ATermAppl woman = TermFactory.term((String)"woman");
    private ATermAppl animal = TermFactory.term((String)"animal");
    private ATermAppl dog = TermFactory.term((String)"dog");
    private ATermAppl cat = TermFactory.term((String)"cat");
    private ATermAppl notCat = TermFactory.not((ATermAppl)this.cat);
    private ATermAppl notDog = TermFactory.not((ATermAppl)this.dog);
    private ATermAppl ssn = TermFactory.term((String)"ssn");
    private ATermAppl ownsAnimal = TermFactory.term((String)"ownsAnimal");

    @Parameterized.Parameters
    public static Collection<Object[]> getTestCases() {
        ArrayList<Object[]> cases = new ArrayList<Object[]>();
        cases.add(new Object[]{false, false, false});
        cases.add(new Object[]{true, false, false});
        cases.add(new Object[]{true, true, false});
        cases.add(new Object[]{true, true, true});
        return cases;
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(IncConsistencyTests.class);
    }

    public IncConsistencyTests(boolean ucq, boolean uic, boolean uid) {
        this.ucq = ucq;
        this.uic = uic;
        this.uid = uid;
    }

    @Test
    public void differentAfterReset() {
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.chris);
        this.kb.addDifferent(this.robert, this.chris);
        this.kb.addDatatypeProperty((ATerm)this.ssn);
        ATermAppl literal = ATermUtils.makeTypedLiteral((String)"xxx", (String)XSDString.instance.getURI());
        this.kb.addPropertyValue(this.ssn, this.chris, literal);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isDifferentFrom(this.robert, this.chris));
        Assert.assertTrue((boolean)this.kb.isDifferentFrom(this.chris, this.robert));
        Assert.assertTrue((boolean)this.kb.removePropertyValue(this.ssn, this.chris, literal));
        Assert.assertTrue((boolean)this.kb.isChanged(KnowledgeBase.ChangeType.ABOX_DEL));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isDifferentFrom(this.robert, this.chris));
        Assert.assertTrue((boolean)this.kb.isDifferentFrom(this.chris, this.robert));
    }

    @Test
    public void mergeDependsAfterReset() {
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.chris);
        this.kb.addSame(this.robert, this.chris);
        this.kb.addDatatypeProperty((ATerm)this.ssn);
        this.kb.addDatatypeProperty((ATerm)this.mbox);
        ATermAppl literal = ATermUtils.makeTypedLiteral((String)"xxx", (String)XSDString.instance.getURI());
        this.kb.addPropertyValue(this.ssn, this.chris, literal);
        this.kb.addPropertyValue(this.mbox, this.chris, literal);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertEquals((Object)Bool.TRUE, (Object)this.kb.hasKnownPropertyValue(this.chris, this.ssn, literal));
        Assert.assertEquals((Object)Bool.TRUE, (Object)this.kb.hasKnownPropertyValue(this.robert, this.ssn, literal));
        Assert.assertTrue((boolean)this.kb.removePropertyValue(this.mbox, this.chris, literal));
        Assert.assertTrue((boolean)this.kb.isChanged(KnowledgeBase.ChangeType.ABOX_DEL));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertEquals((Object)Bool.TRUE, (Object)this.kb.hasKnownPropertyValue(this.chris, this.ssn, literal));
        Assert.assertEquals((Object)Bool.TRUE, (Object)this.kb.hasKnownPropertyValue(this.robert, this.ssn, literal));
    }

    @Before
    public void setUp() {
        this.preUCQ = PelletOptions.USE_COMPLETION_QUEUE;
        this.preUIC = PelletOptions.USE_INCREMENTAL_CONSISTENCY;
        this.preUSR = PelletOptions.USE_SMART_RESTORE;
        this.preUID = PelletOptions.USE_INCREMENTAL_DELETION;
        this.preUT = PelletOptions.USE_TRACING;
        PelletOptions.USE_COMPLETION_QUEUE = this.ucq;
        PelletOptions.USE_INCREMENTAL_CONSISTENCY = this.uic;
        PelletOptions.USE_INCREMENTAL_DELETION = this.uid;
        PelletOptions.USE_TRACING = this.uid;
        PelletOptions.USE_SMART_RESTORE = true;
        PelletOptions.PRINT_ABOX = false;
        this.kb = new KnowledgeBase();
        this.kb.setDoExplanation(PelletOptions.USE_TRACING);
    }

    @After
    public void tearDown() throws Exception {
        PelletOptions.USE_COMPLETION_QUEUE = this.preUCQ;
        PelletOptions.USE_INCREMENTAL_CONSISTENCY = this.preUIC;
        PelletOptions.USE_SMART_RESTORE = this.preUSR;
        PelletOptions.USE_TRACING = this.preUT;
        PelletOptions.USE_INCREMENTAL_DELETION = this.preUID;
    }

    @Test
    public void testDisjunction() {
        this.kb.addClass(this.person);
        this.kb.addClass(this.animalOwner);
        this.kb.addClass(this.animal);
        this.kb.addClass(this.dog);
        this.kb.addClass(this.cat);
        this.kb.addDisjointClass(this.dog, this.cat);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addDomain((ATerm)this.sibling, this.person);
        this.kb.addDatatypeProperty((ATerm)this.ssn);
        this.kb.addObjectProperty((ATerm)this.mbox);
        this.kb.addObjectProperty((ATerm)this.ownsAnimal);
        this.kb.addDomain((ATerm)this.ownsAnimal, this.person);
        this.kb.addRange((ATerm)this.ownsAnimal, this.animal);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.mary);
        ATermAppl ssn1 = TermFactory.literal((String)"012345678");
        this.kb.addPropertyValue(this.ssn, this.robert, ssn1);
        ATermAppl catOrDog = TermFactory.or((ATermAppl)this.dog, (ATermAppl)this.cat);
        this.kb.addSubClass(this.animal, catOrDog);
        ATermAppl ownsSomeAnimal = TermFactory.some((ATermAppl)this.ownsAnimal, (ATermAppl)this.animal);
        this.kb.addClass(ownsSomeAnimal);
        this.kb.addSubClass(this.animalOwner, ownsSomeAnimal);
        ATermAppl ownsNoCats = TermFactory.all((ATermAppl)this.ownsAnimal, (ATermAppl)this.notCat);
        ATermAppl ownsNoDogs = TermFactory.all((ATermAppl)this.ownsAnimal, (ATermAppl)this.notDog);
        this.kb.addType(this.robert, ownsSomeAnimal);
        this.kb.addType(this.mary, ownsSomeAnimal);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addType(this.mary, ownsNoDogs);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addType(this.robert, ownsNoDogs);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addType(this.robert, ownsNoCats);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        this.kb.removeType(this.robert, ownsNoDogs);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addType(this.mary, ownsNoCats);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        this.kb.removeType(this.mary, ownsNoDogs);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        this.kb.removeType(this.mary, ownsNoCats);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addType(this.mary, ownsNoDogs);
        Assert.assertTrue((boolean)this.kb.isConsistent());
    }

    @Test
    public void testDisjunction2() {
        this.kb.addClass(this.person);
        this.kb.addClass(this.dog);
        this.kb.addClass(this.cat);
        this.kb.addClass(this.man);
        this.kb.addClass(this.woman);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addObjectProperty((ATerm)this.owns);
        this.kb.addObjectProperty((ATerm)this.ownedBy);
        this.kb.addInverseProperty(this.owns, this.ownedBy);
        this.kb.addObjectProperty((ATerm)this.knows);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.mary);
        ATermAppl ownsDog = TermFactory.some((ATermAppl)this.owns, (ATermAppl)this.dog);
        this.kb.addClass(ownsDog);
        this.kb.addSubClass(this.man, ownsDog);
        ATermAppl owersAreDogs = TermFactory.all((ATermAppl)this.ownedBy, (ATermAppl)this.dog);
        this.kb.addClass(owersAreDogs);
        this.kb.addSubClass(this.dog, owersAreDogs);
        ATermAppl manOrDog = TermFactory.or((ATermAppl)this.man, (ATermAppl)this.dog);
        this.kb.addClass(manOrDog);
        this.kb.addType(this.robert, manOrDog);
        this.kb.addType(this.robert, TermFactory.not((ATermAppl)this.dog));
        Assert.assertFalse((boolean)this.kb.isConsistent());
        this.kb.removeType(this.robert, TermFactory.not((ATermAppl)this.dog));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.getABox().getIndividual((ATerm)this.robert).hasType((ATerm)this.dog));
    }

    @Test
    public void testUC() {
        boolean preRoleA = PelletOptions.USE_ROLE_ABSORPTION;
        boolean preAb = PelletOptions.USE_ABSORPTION;
        PelletOptions.USE_ROLE_ABSORPTION = false;
        PelletOptions.USE_ABSORPTION = false;
        this.kb.addClass(this.person);
        this.kb.addObjectProperty((ATerm)this.knows);
        ATermAppl onlyKnowsPeople = TermFactory.all((ATermAppl)this.knows, (ATermAppl)this.person);
        this.kb.addClass(onlyKnowsPeople);
        this.kb.addClass(this.dog);
        this.kb.addClass(this.man);
        this.kb.addClass(this.woman);
        this.kb.addDisjointClass(this.man, this.woman);
        ATermAppl notDog = TermFactory.not((ATermAppl)this.dog);
        this.kb.addClass(notDog);
        ATermAppl personAndNotDog = TermFactory.and((ATermAppl)this.person, (ATermAppl)notDog);
        this.kb.addClass(personAndNotDog);
        ATermAppl manOrWoman = TermFactory.or((ATermAppl)this.man, (ATermAppl)this.woman);
        this.kb.addClass(manOrWoman);
        this.kb.addSubClass(manOrWoman, personAndNotDog);
        this.kb.addIndividual(this.robert);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.mary);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((!this.kb.getABox().getIndividual((ATerm)this.mary).getTypes(1).isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((!this.kb.getABox().getIndividual((ATerm)this.robert).getTypes(1).isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((!this.kb.getABox().getIndividual((ATerm)this.victor).getTypes(1).isEmpty() ? 1 : 0) != 0);
        PelletOptions.USE_ROLE_ABSORPTION = preRoleA;
        PelletOptions.USE_ABSORPTION = preAb;
    }

    @Test
    public void testMax() {
        this.kb.addClass(this.person);
        this.kb.addClass(this.dog);
        this.kb.addClass(this.cat);
        this.kb.addClass(this.man);
        this.kb.addClass(this.woman);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addObjectProperty((ATerm)this.owns);
        this.kb.addObjectProperty((ATerm)this.ownedBy);
        this.kb.addInverseProperty(this.owns, this.ownedBy);
        this.kb.addObjectProperty((ATerm)this.knows);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.chris);
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.john);
        this.kb.addIndividual(this.bill);
        this.kb.addPropertyValue(this.sibling, this.bill, this.mary);
        this.kb.addPropertyValue(this.sibling, this.bill, this.chris);
        this.kb.addPropertyValue(this.sibling, this.bill, this.victor);
        this.kb.addPropertyValue(this.sibling, this.robert, this.mary);
        this.kb.addPropertyValue(this.sibling, this.robert, this.chris);
        this.kb.addPropertyValue(this.sibling, this.robert, this.victor);
        this.kb.addPropertyValue(this.sibling, this.robert, this.john);
        ATermAppl twoSiblings = TermFactory.max((ATermAppl)this.sibling, (int)2, (ATermAppl)this.person);
        ATermAppl twoSiblingsOrDog = TermFactory.or((ATermAppl)twoSiblings, (ATermAppl)this.dog);
        this.kb.addType(this.robert, twoSiblingsOrDog);
        this.kb.addType(this.bill, twoSiblingsOrDog);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        ATermAppl[] inds = new ATermAppl[]{this.mary, this.chris, this.victor, this.john};
        for (int i = 0; i < inds.length - 1; ++i) {
            for (int j = i + 1; j < inds.length; ++j) {
                if (!this.kb.getABox().getIndividual((ATerm)inds[i]).isSame((Node)this.kb.getABox().getIndividual((ATerm)inds[j]))) continue;
                this.kb.addDifferent(inds[i], inds[j]);
            }
        }
        Assert.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addType(this.bill, TermFactory.not((ATermAppl)this.dog));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        this.kb.removeType(this.bill, TermFactory.not((ATermAppl)this.dog));
        Assert.assertTrue((boolean)this.kb.isConsistent());
    }

    @Test
    public void testMerge() {
        this.kb.addClass(this.person);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.chris);
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.john);
        this.kb.addIndividual(this.bill);
        this.kb.addPropertyValue(this.sibling, this.bill, this.mary);
        this.kb.addPropertyValue(this.sibling, this.bill, this.john);
        this.kb.addPropertyValue(this.sibling, this.chris, this.victor);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(this.bill, this.sibling, this.victor));
        this.kb.addSame(this.chris, this.bill);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(this.bill, this.sibling, this.victor));
        this.kb.addDifferent(this.bill, this.chris);
        Assert.assertFalse((boolean)this.kb.isConsistent());
    }

    @Test
    public void testMerge3() {
        this.kb.addClass(this.person);
        this.kb.addClass(this.man);
        this.kb.addClass(this.dog);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addObjectProperty((ATerm)this.owns);
        ATermAppl max = TermFactory.max((ATermAppl)this.sibling, (int)1, (ATermAppl)TermFactory.TOP);
        this.kb.addClass(max);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.chris);
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.john);
        this.kb.addIndividual(this.bill);
        this.kb.addPropertyValue(this.sibling, this.bill, this.mary);
        this.kb.addPropertyValue(this.sibling, this.bill, this.john);
        ATermAppl ownsDog = TermFactory.some((ATermAppl)this.owns, (ATermAppl)this.dog);
        this.kb.addClass(ownsDog);
        this.kb.addSubClass(this.man, ownsDog);
        ATermAppl manOrDog = TermFactory.or((ATermAppl)this.man, (ATermAppl)this.dog);
        this.kb.addClass(manOrDog);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.getABox().getNode((ATerm)this.mary).isSame(this.kb.getABox().getNode((ATerm)this.john)));
        this.kb.addType(this.bill, max);
        this.kb.addType(this.mary, manOrDog);
        this.kb.addType(this.chris, manOrDog);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.getABox().getNode((ATerm)this.mary).isSame(this.kb.getABox().getNode((ATerm)this.john)));
        this.kb.removeType(this.bill, max);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.getABox().getNode((ATerm)this.mary).isSame(this.kb.getABox().getNode((ATerm)this.john)));
        Assert.assertFalse((boolean)this.kb.getABox().getNode((ATerm)this.john).hasType((ATerm)this.dog));
        Assert.assertTrue((boolean)this.kb.getABox().getNode((ATerm)this.mary).hasType((ATerm)this.dog));
    }

    @Test
    public void testMerge2() {
        this.kb.addClass(this.person);
        this.kb.addClass(this.man);
        this.kb.addClass(this.woman);
        this.kb.addClass(this.dog);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addObjectProperty((ATerm)this.owns);
        ATermAppl max = TermFactory.max((ATermAppl)this.sibling, (int)1, (ATermAppl)TermFactory.TOP);
        this.kb.addClass(max);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.chris);
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.john);
        this.kb.addIndividual(this.bill);
        this.kb.addDisjointClass(this.man, this.woman);
        this.kb.addPropertyValue(this.sibling, this.bill, this.mary);
        this.kb.addPropertyValue(this.sibling, this.bill, this.john);
        ATermAppl ownsDog = TermFactory.some((ATermAppl)this.owns, (ATermAppl)this.dog);
        this.kb.addClass(ownsDog);
        this.kb.addSubClass(this.man, ownsDog);
        ATermAppl manOrDog = TermFactory.or((ATermAppl)this.man, (ATermAppl)this.dog);
        this.kb.addClass(manOrDog);
        this.kb.addType(this.mary, manOrDog);
        this.kb.addType(this.chris, manOrDog);
        this.kb.addType(this.mary, this.woman);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.getABox().getNode((ATerm)this.mary).isSame(this.kb.getABox().getNode((ATerm)this.john)));
        Assert.assertTrue((boolean)this.kb.getABox().getNode((ATerm)this.mary).hasType((ATerm)this.dog));
        Assert.assertFalse((boolean)this.kb.getABox().getNode((ATerm)this.john).hasType((ATerm)this.dog));
        this.kb.addType(this.bill, max);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.getABox().getNode((ATerm)this.mary).isSame(this.kb.getABox().getNode((ATerm)this.john)));
        Assert.assertTrue((boolean)this.kb.getABox().getNode((ATerm)this.john).getSame().hasType((ATerm)this.dog));
        this.kb.removeType(this.bill, max);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.getABox().getNode((ATerm)this.mary).isSame(this.kb.getABox().getNode((ATerm)this.john)));
        Assert.assertFalse((boolean)this.kb.getABox().getNode((ATerm)this.john).hasType((ATerm)this.dog));
        Assert.assertTrue((boolean)this.kb.getABox().getNode((ATerm)this.mary).hasType((ATerm)this.dog));
    }

    @Test
    public void testCompletionQueueBackjumping() {
        this.kb.addClass(this.person);
        this.kb.addClass(this.dog);
        this.kb.addClass(this.cat);
        this.kb.addClass(this.man);
        this.kb.addClass(this.woman);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addObjectProperty((ATerm)this.owns);
        this.kb.addObjectProperty((ATerm)this.ownedBy);
        this.kb.addInverseProperty(this.owns, this.ownedBy);
        this.kb.addObjectProperty((ATerm)this.knows);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.victor);
        ATermAppl ownsDog = TermFactory.some((ATermAppl)this.owns, (ATermAppl)this.dog);
        this.kb.addClass(ownsDog);
        this.kb.addSubClass(this.man, ownsDog);
        ATermAppl allCat = TermFactory.all((ATermAppl)this.owns, (ATermAppl)this.cat);
        this.kb.addClass(allCat);
        ATermAppl catAndMan = TermFactory.and((ATermAppl)allCat, (ATermAppl)this.man);
        this.kb.addClass(catAndMan);
        ATermAppl manOrWoman = TermFactory.or((ATermAppl)this.man, (ATermAppl)this.woman);
        this.kb.addClass(manOrWoman);
        this.kb.addType(this.robert, manOrWoman);
        this.kb.addType(this.victor, manOrWoman);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addType(this.victor, TermFactory.not((ATermAppl)this.man));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        this.kb.removeType(this.victor, TermFactory.not((ATermAppl)this.man));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.getABox().getIndividual((ATerm)this.victor).hasType((ATerm)TermFactory.not((ATermAppl)this.man)));
        this.kb.addType(this.robert, TermFactory.not((ATermAppl)this.man));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.getABox().getIndividual((ATerm)this.robert).hasType((ATerm)TermFactory.not((ATermAppl)this.man)));
        this.kb.removeType(this.robert, TermFactory.not((ATermAppl)this.man));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.getABox().getIndividual((ATerm)this.robert).hasType((ATerm)TermFactory.not((ATermAppl)this.man)));
        this.kb.addType(this.robert, TermFactory.not((ATermAppl)this.woman));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.getABox().getIndividual((ATerm)this.robert).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
    }

    @Test
    public void testRemoveBranch() {
        this.kb.addClass(this.person);
        this.kb.addClass(this.dog);
        this.kb.addClass(this.cat);
        this.kb.addClass(this.man);
        this.kb.addClass(this.woman);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addObjectProperty((ATerm)this.owns);
        this.kb.addObjectProperty((ATerm)this.ownedBy);
        this.kb.addInverseProperty(this.owns, this.ownedBy);
        this.kb.addObjectProperty((ATerm)this.knows);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.chris);
        this.kb.addIndividual(this.john);
        this.kb.addIndividual(this.bill);
        ATermAppl ownsDog = TermFactory.some((ATermAppl)this.owns, (ATermAppl)this.dog);
        this.kb.addClass(ownsDog);
        this.kb.addSubClass(this.man, ownsDog);
        ATermAppl allCat = TermFactory.all((ATermAppl)this.owns, (ATermAppl)this.cat);
        this.kb.addClass(allCat);
        ATermAppl catAndMan = TermFactory.and((ATermAppl)allCat, (ATermAppl)this.man);
        this.kb.addClass(catAndMan);
        ATermAppl manOrWoman = TermFactory.or((ATermAppl)this.man, (ATermAppl)this.woman);
        this.kb.addClass(manOrWoman);
        this.kb.addType(this.robert, manOrWoman);
        this.kb.addType(this.victor, manOrWoman);
        this.kb.addType(this.mary, manOrWoman);
        this.kb.addType(this.chris, manOrWoman);
        this.kb.addType(this.john, manOrWoman);
        this.kb.addType(this.bill, manOrWoman);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.getABox().getIndividual((ATerm)this.robert).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
        Assert.assertTrue((boolean)this.kb.getABox().getIndividual((ATerm)this.victor).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
        this.kb.removeType(this.victor, manOrWoman);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.getABox().getIndividual((ATerm)this.victor).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
        Assert.assertTrue((boolean)this.kb.getABox().getIndividual((ATerm)this.robert).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
        Assert.assertTrue((boolean)this.kb.getABox().getIndividual((ATerm)this.mary).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
        Assert.assertTrue((boolean)this.kb.getABox().getIndividual((ATerm)this.chris).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
        Assert.assertTrue((boolean)this.kb.getABox().getIndividual((ATerm)this.john).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
        Assert.assertTrue((boolean)this.kb.getABox().getIndividual((ATerm)this.bill).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
        Assert.assertTrue((this.kb.getABox().getBranches().size() == 5 ? 1 : 0) != 0);
        this.kb.addType(this.chris, TermFactory.not((ATermAppl)this.man));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.getABox().getIndividual((ATerm)this.chris).getTypes().contains(this.man));
        Assert.assertFalse((boolean)this.kb.getABox().getIndividual((ATerm)this.chris).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
        Assert.assertFalse((boolean)this.kb.getABox().getIndividual((ATerm)this.victor).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
        Assert.assertTrue((boolean)this.kb.getABox().getIndividual((ATerm)this.robert).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
        Assert.assertTrue((boolean)this.kb.getABox().getIndividual((ATerm)this.mary).hasRNeighbor(this.kb.getRBox().getRole((ATerm)this.owns)));
    }

    @Test
    public void testUpdatedIndividuals() {
        this.kb.addClass(this.person);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addObjectProperty((ATerm)this.relative);
        this.kb.addRange((ATerm)this.relative, this.person);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.mary);
        this.kb.addPropertyValue(this.relative, this.robert, this.mary);
        this.kb.addPropertyValue(this.sibling, this.robert, this.victor);
        ATermAppl siblingPerson = TermFactory.all((ATermAppl)this.sibling, (ATermAppl)this.person);
        this.kb.addClass(siblingPerson);
        this.kb.addType(this.victor, this.person);
        this.kb.addType(this.mary, this.person);
        this.kb.addType(this.robert, siblingPerson);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.getABox().getIndividual((ATerm)this.victor).hasType((ATerm)this.person));
        Assert.assertTrue((boolean)this.kb.getABox().getIndividual((ATerm)this.mary).hasType((ATerm)this.person));
        this.kb.removeType(this.victor, this.person);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.getABox().getIndividual((ATerm)this.victor).hasType((ATerm)this.person));
        this.kb.removeType(this.mary, this.person);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.getABox().getIndividual((ATerm)this.mary).hasType((ATerm)this.person));
    }

    @Test
    public void testClashDependency() {
        this.kb.addClass(this.person);
        this.kb.addClass(this.notPerson);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.mary);
        this.kb.addType(this.robert, this.person);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addType(this.robert, this.notPerson);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        this.kb.removeType(this.robert, this.notPerson);
        Assert.assertTrue((boolean)this.kb.isConsistent());
    }

    @Test
    public void testBlocking() {
        this.kb.addClass(this.person);
        this.kb.addClass(TermFactory.not((ATermAppl)this.person));
        this.kb.addDisjointClass(this.person, TermFactory.not((ATermAppl)this.person));
        this.kb.addObjectProperty((ATerm)this.knows);
        this.kb.addObjectProperty((ATerm)this.ownedBy);
        this.kb.addObjectProperty((ATerm)this.owns);
        this.kb.addInverseProperty(this.ownedBy, this.owns);
        ATermAppl allSPerson = TermFactory.all((ATermAppl)this.knows, (ATermAppl)TermFactory.not((ATermAppl)this.person));
        this.kb.addClass(allSPerson);
        ATermAppl allRInvallSPerson = TermFactory.all((ATermAppl)this.ownedBy, (ATermAppl)allSPerson);
        this.kb.addClass(allRInvallSPerson);
        ATermAppl allRInvallRInvallSPerson = TermFactory.all((ATermAppl)this.ownedBy, (ATermAppl)allRInvallSPerson);
        this.kb.addClass(allRInvallRInvallSPerson);
        ATermAppl allRInvallRInvallRInvallSPerson = TermFactory.all((ATermAppl)this.ownedBy, (ATermAppl)allRInvallRInvallSPerson);
        this.kb.addClass(allRInvallRInvallRInvallSPerson);
        ATermAppl allRallRInvallRInvallSPerson = TermFactory.all((ATermAppl)this.owns, (ATermAppl)allRInvallRInvallRInvallSPerson);
        this.kb.addClass(allRallRInvallRInvallSPerson);
        ATermAppl allRallRallRInvallRInvallSPerson = TermFactory.all((ATermAppl)this.owns, (ATermAppl)allRallRInvallRInvallSPerson);
        this.kb.addClass(allRallRallRInvallRInvallSPerson);
        ATermAppl allRallRallRallRInvallRInvallSPerson = TermFactory.all((ATermAppl)this.owns, (ATermAppl)allRallRallRInvallRInvallSPerson);
        this.kb.addClass(allRallRallRallRInvallRInvallSPerson);
        ATermAppl allSallRallRallRallRInvallRInvallSPerson = TermFactory.all((ATermAppl)this.knows, (ATermAppl)allRallRallRallRInvallRInvallSPerson);
        this.kb.addClass(allSallRallRallRallRInvallRInvallSPerson);
        ATermAppl neg = TermFactory.not((ATermAppl)allSallRallRallRallRInvallRInvallSPerson);
        neg = ATermUtils.normalize((ATermAppl)neg);
        this.kb.addClass(neg);
        this.kb.addClass(this.man);
        this.kb.addEquivalentClass(this.man, neg);
        this.kb.addClass(this.woman);
        ATermAppl someWoman = TermFactory.some((ATermAppl)this.owns, (ATermAppl)this.woman);
        this.kb.addClass(someWoman);
        this.kb.addSubClass(this.woman, someWoman);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.john);
        this.kb.addType(this.mary, this.woman);
        this.kb.addPropertyValue(this.knows, this.robert, this.mary);
        this.kb.addPropertyValue(this.knows, this.mary, this.john);
        this.kb.prepare();
        this.kb.isConsistent();
        this.kb.addType(this.john, this.person);
        this.kb.addType(this.robert, TermFactory.not((ATermAppl)this.man));
        boolean cons = this.kb.isConsistent();
        Assert.assertFalse((boolean)cons);
    }

    @Test
    public void testDisjunction3() {
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl E = TermFactory.term((String)"E");
        this.kb.addObjectProperty((ATerm)p);
        this.kb.addClass(C);
        this.kb.addClass(D);
        this.kb.addClass(E);
        this.kb.addIndividual(a);
        this.kb.addSubClass(C, TermFactory.some((ATermAppl)p, (ATermAppl)E));
        this.kb.addType(a, TermFactory.or((ATermAppl)C, (ATermAppl)D));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.isType(a, C));
        Assert.assertFalse((boolean)this.kb.isType(a, D));
        this.kb.addType(a, TermFactory.not((ATermAppl)C));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.isType(a, C));
        Assert.assertTrue((boolean)this.kb.isType(a, D));
        this.kb.removeType(a, TermFactory.not((ATermAppl)C));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.isType(a, C));
        Assert.assertFalse((boolean)this.kb.isType(a, D));
        this.kb.addType(a, TermFactory.not((ATermAppl)D));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isType(a, C));
        Assert.assertFalse((boolean)this.kb.isType(a, D));
        this.kb.addType(a, TermFactory.not((ATermAppl)C));
        Assert.assertFalse((boolean)this.kb.isConsistent());
        this.kb.removeType(a, TermFactory.not((ATermAppl)D));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.isType(a, C));
        Assert.assertTrue((boolean)this.kb.isType(a, D));
        this.kb.removeType(a, TermFactory.not((ATermAppl)C));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.isType(a, C));
        Assert.assertFalse((boolean)this.kb.isType(a, D));
        this.kb.addType(a, TermFactory.not((ATermAppl)D));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isType(a, C));
        Assert.assertFalse((boolean)this.kb.isType(a, D));
    }

    @Test
    public void testBacktracking() {
        this.kb.addClass(this.person);
        this.kb.addClass(this.dog);
        this.kb.addClass(this.cat);
        this.kb.addClass(this.man);
        this.kb.addClass(this.woman);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addObjectProperty((ATerm)this.owns);
        this.kb.addObjectProperty((ATerm)this.ownedBy);
        this.kb.addInverseProperty(this.owns, this.ownedBy);
        this.kb.addObjectProperty((ATerm)this.knows);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.victor);
        ATermAppl ownsDog = TermFactory.some((ATermAppl)this.owns, (ATermAppl)this.dog);
        this.kb.addClass(ownsDog);
        this.kb.addSubClass(this.man, ownsDog);
        ATermAppl owersAreDogs = TermFactory.all((ATermAppl)this.ownedBy, (ATermAppl)this.dog);
        this.kb.addClass(owersAreDogs);
        ATermAppl owersAreCats = TermFactory.all((ATermAppl)this.ownedBy, (ATermAppl)this.cat);
        this.kb.addClass(owersAreCats);
        this.kb.addSubClass(this.dog, owersAreDogs);
        this.kb.addClass(ATermUtils.negate((ATermAppl)this.dog));
        ATermAppl manOrDog = TermFactory.or((ATermAppl)ATermUtils.negate((ATermAppl)this.dog), (ATermAppl)this.woman);
        this.kb.addClass(manOrDog);
        this.kb.addType(this.victor, manOrDog);
        this.kb.addType(this.robert, owersAreCats);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addType(this.victor, this.man);
        this.kb.addPropertyValue(this.ownedBy, this.robert, this.mary);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.getABox().getIndividual((ATerm)this.mary).hasType((ATerm)this.cat));
    }

    @Test
    public void testBacktracking3() {
        this.kb.addClass(this.person);
        this.kb.addClass(this.dog);
        this.kb.addClass(this.cat);
        this.kb.addClass(this.man);
        this.kb.addClass(this.woman);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addObjectProperty((ATerm)this.owns);
        this.kb.addObjectProperty((ATerm)this.ownedBy);
        this.kb.addInverseProperty(this.owns, this.ownedBy);
        this.kb.addObjectProperty((ATerm)this.knows);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.victor);
        ATermAppl ownsDog = TermFactory.some((ATermAppl)this.owns, (ATermAppl)this.dog);
        ATermAppl manOrDog = TermFactory.or((ATermAppl)this.man, (ATermAppl)this.dog);
        ATermAppl catOrDog = TermFactory.or((ATermAppl)this.cat, (ATermAppl)this.dog);
        ATermAppl manOrDogAndWoman = TermFactory.and((ATermAppl)this.woman, (ATermAppl)manOrDog);
        ATermAppl catOrDogAndWoman = TermFactory.and((ATermAppl)this.woman, (ATermAppl)catOrDog);
        ATermAppl bigDisj = TermFactory.or((ATermAppl)manOrDogAndWoman, (ATermAppl)catOrDogAndWoman);
        this.kb.addType(this.victor, ownsDog);
        this.kb.addPropertyValue(this.owns, this.victor, this.robert);
        this.kb.addType(this.robert, this.dog);
        this.kb.addType(this.mary, bigDisj);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        this.kb.removePropertyValue(this.owns, this.victor, this.robert);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((this.kb.getABox().getIndividual((ATerm)this.victor).getRNeighborEdges(this.kb.getRBox().getRole((ATerm)this.owns)).size() > 0 ? 1 : 0) != 0);
        this.kb.addType(this.mary, TermFactory.not((ATermAppl)this.cat));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((this.kb.getABox().getIndividual((ATerm)this.victor).getRNeighborEdges(this.kb.getRBox().getRole((ATerm)this.owns)).size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBacktracking2() {
        this.kb.addClass(this.person);
        this.kb.addClass(this.dog);
        this.kb.addClass(this.cat);
        this.kb.addClass(this.man);
        this.kb.addClass(this.woman);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addObjectProperty((ATerm)this.owns);
        this.kb.addObjectProperty((ATerm)this.ownedBy);
        this.kb.addInverseProperty(this.owns, this.ownedBy);
        this.kb.addObjectProperty((ATerm)this.knows);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.chris);
        this.kb.addIndividual(this.bill);
        ATermAppl ownsDog = TermFactory.some((ATermAppl)this.owns, (ATermAppl)this.dog);
        this.kb.addClass(ownsDog);
        this.kb.addSubClass(this.man, ownsDog);
        ATermAppl owersAreDogs = TermFactory.all((ATermAppl)this.ownedBy, (ATermAppl)this.dog);
        this.kb.addClass(owersAreDogs);
        ATermAppl owersAreCats = TermFactory.all((ATermAppl)this.ownedBy, (ATermAppl)this.cat);
        this.kb.addClass(owersAreCats);
        ATermAppl owersownersAreCats = TermFactory.all((ATermAppl)this.ownedBy, (ATermAppl)owersAreCats);
        this.kb.addClass(owersownersAreCats);
        this.kb.addSubClass(this.dog, owersAreDogs);
        this.kb.addClass(ATermUtils.negate((ATermAppl)this.dog));
        ATermAppl manOrDog = TermFactory.or((ATermAppl)ATermUtils.negate((ATermAppl)this.dog), (ATermAppl)this.woman);
        this.kb.addClass(manOrDog);
        this.kb.addType(this.victor, manOrDog);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addType(this.robert, owersownersAreCats);
        this.kb.addPropertyValue(this.ownedBy, this.robert, this.mary);
        this.kb.addPropertyValue(this.ownedBy, this.mary, this.chris);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.getABox().getIndividual((ATerm)this.chris).hasType((ATerm)this.cat));
        this.kb.addType(this.victor, this.man);
        Assert.assertTrue((boolean)this.kb.getABox().getIndividual((ATerm)this.chris).hasType((ATerm)this.cat));
    }

    @Test
    public void testSimpleABoxRemove() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        kb.addClass(C);
        kb.addClass(D);
        kb.addIndividual(a);
        kb.addType(a, C);
        kb.addType(a, D);
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isType(a, C));
        Assert.assertTrue((boolean)kb.isType(a, D));
        kb.removeType(a, D);
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isType(a, C));
        Assert.assertFalse((boolean)kb.isType(a, D));
    }

    @Test
    public void testABoxRemovalWithAllValues() {
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl p = TermFactory.term((String)"p");
        this.kb.addClass(C);
        this.kb.addObjectProperty((ATerm)p);
        this.kb.addIndividual(a);
        this.kb.addIndividual(b);
        this.kb.addType(a, TermFactory.all((ATermAppl)p, (ATermAppl)C));
        this.kb.addType(b, C);
        this.kb.addPropertyValue(p, a, b);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isType(b, C));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(a, p, b));
        this.kb.removeType(b, C);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isType(b, C));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(a, p, b));
        this.kb.removePropertyValue(p, a, b);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.isType(b, C));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(a, p, b));
    }

    @Test
    public void testABoxRemovalWithFunctionality() {
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl p = TermFactory.term((String)"p");
        this.kb.addClass(C);
        this.kb.addObjectProperty((ATerm)p);
        this.kb.addFunctionalProperty(p);
        this.kb.addIndividual(a);
        this.kb.addIndividual(b);
        this.kb.addIndividual(c);
        this.kb.addType(c, C);
        this.kb.addPropertyValue(p, a, b);
        this.kb.addPropertyValue(p, a, c);
        Assert.assertTrue((boolean)this.kb.isType(b, C));
        Assert.assertTrue((boolean)this.kb.isType(c, C));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(a, p, b));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(a, p, c));
        Assert.assertTrue((boolean)this.kb.isSameAs(b, c));
        this.kb.removeType(b, C);
        Assert.assertTrue((boolean)this.kb.isType(b, C));
        Assert.assertTrue((boolean)this.kb.isType(c, C));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(a, p, b));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(a, p, c));
        Assert.assertTrue((boolean)this.kb.isSameAs(b, c));
        this.kb.removePropertyValue(p, a, b);
        Assert.assertFalse((boolean)this.kb.isType(b, C));
        Assert.assertTrue((boolean)this.kb.isType(c, C));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(a, p, b));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(a, p, c));
        Assert.assertFalse((boolean)this.kb.isSameAs(b, c));
    }

    @Test
    public void testABoxConsistencyChange() {
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl E = TermFactory.term((String)"E");
        this.kb.addClass(C);
        this.kb.addClass(D);
        this.kb.addClass(E);
        this.kb.addIndividual(a);
        this.kb.addType(a, C);
        this.kb.addType(a, D);
        this.kb.addType(a, E);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addType(a, TermFactory.not((ATermAppl)C));
        Assert.assertFalse((boolean)this.kb.isConsistent());
        this.kb.removeType(a, E);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        this.kb.removeType(a, C);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.isType(a, C));
        Assert.assertTrue((boolean)this.kb.isType(a, D));
        Assert.assertFalse((boolean)this.kb.isType(a, E));
    }

    @Test
    public void testABoxDoubleConsistencyChange() {
        Assume.assumeThat((Object)PelletOptions.USE_INCREMENTAL_DELETION, (Matcher)CoreMatchers.is((Object)false));
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl E = TermFactory.term((String)"E");
        this.kb.addClass(C);
        this.kb.addClass(D);
        this.kb.addClass(E);
        this.kb.addIndividual(a);
        this.kb.addIndividual(b);
        this.kb.addType(a, C);
        this.kb.addType(b, D);
        this.kb.addType(b, E);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addType(a, TermFactory.not((ATermAppl)C));
        this.kb.addType(b, TermFactory.not((ATermAppl)D));
        Assert.assertFalse((boolean)this.kb.isConsistent());
        this.kb.removeType(b, E);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        this.kb.removeType(b, D);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        this.kb.removeType(a, C);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.isType(a, C));
        Assert.assertFalse((boolean)this.kb.isType(b, D));
        Assert.assertFalse((boolean)this.kb.isType(b, E));
    }

    @Test
    public void testTBoxConsistencyChange() {
        boolean ut = PelletOptions.USE_TRACING;
        PelletOptions.USE_TRACING = true;
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl E = TermFactory.term((String)"E");
        ATermAppl F = TermFactory.term((String)"F");
        this.kb.addClass(C);
        this.kb.addClass(D);
        this.kb.addClass(E);
        this.kb.addIndividual(a);
        this.kb.addType(a, C);
        this.kb.addType(a, D);
        this.kb.addType(a, E);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addSubClass(C, TermFactory.not((ATermAppl)D));
        this.kb.addSubClass(C, F);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        this.kb.removeType(a, E);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        this.kb.addType(a, E);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        this.kb.removeType(a, C);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isType(a, D));
        Assert.assertTrue((boolean)this.kb.isType(a, TermFactory.not((ATermAppl)C)));
        Assert.assertFalse((boolean)this.kb.isType(a, C));
        Assert.assertTrue((boolean)this.kb.isType(a, E));
        this.kb.addType(a, C);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        this.kb.removeAxiom(ATermUtils.makeSub((ATerm)C, (ATerm)F));
        Assert.assertFalse((boolean)this.kb.isConsistent());
        this.kb.removeAxiom(ATermUtils.makeSub((ATerm)C, (ATerm)TermFactory.not((ATermAppl)D)));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        PelletOptions.USE_TRACING = ut;
    }

    @Test
    public void testClassificationStatus1() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl E = TermFactory.term((String)"E");
        kb.addClass(C);
        kb.addClass(D);
        kb.addClass(E);
        kb.addSubClass(C, D);
        kb.addSubClass(E, TermFactory.or((ATermAppl)C, (ATermAppl)D));
        Assert.assertFalse((boolean)kb.isClassified());
        Assert.assertFalse((boolean)kb.isRealized());
        kb.getToldTaxonomy();
        kb.addIndividual(TermFactory.term((String)"a"));
        kb.prepare();
        Assert.assertFalse((boolean)kb.isClassified());
        Assert.assertFalse((boolean)kb.isRealized());
    }

    @Test
    public void testClassificationStatus1EL() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl E = TermFactory.term((String)"E");
        kb.addClass(C);
        kb.addClass(D);
        kb.addClass(E);
        kb.addSubClass(C, D);
        Assert.assertFalse((boolean)kb.isClassified());
        Assert.assertFalse((boolean)kb.isRealized());
        kb.getToldTaxonomy();
        kb.addIndividual(TermFactory.term((String)"a"));
        kb.prepare();
        Assert.assertFalse((boolean)kb.isClassified());
        Assert.assertFalse((boolean)kb.isRealized());
    }

    @Test
    public void testClassificationStatus2() {
        KnowledgeBase kb = new KnowledgeBase();
        Timer classifyTimer = kb.timers.createTimer("classify");
        Timer realizeTimer = kb.timers.createTimer("realize");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl E = TermFactory.term((String)"E");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        kb.addClass(C);
        kb.addClass(D);
        kb.addClass(E);
        kb.addSubClass(C, D);
        kb.addEquivalentClass(C, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.TOP));
        kb.addEquivalentClass(E, TermFactory.some((ATermAppl)q, (ATermAppl)TermFactory.TOP));
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)q);
        kb.addSubProperty((ATerm)q, p);
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addType(a, C);
        kb.addPropertyValue(p, a, b);
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertEquals((long)0L, (long)classifyTimer.getCount());
        Assert.assertEquals((long)0L, (long)realizeTimer.getCount());
        Assert.assertFalse((boolean)kb.isClassified());
        Assert.assertFalse((boolean)kb.isRealized());
        kb.realize();
        Assert.assertEquals((long)1L, (long)classifyTimer.getCount());
        Assert.assertEquals((long)1L, (long)realizeTimer.getCount());
        kb.addType(b, E);
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isClassified());
        Assert.assertTrue((!kb.isRealized() ? 1 : 0) != 0);
        Assert.assertEquals(Collections.emptySet(), (Object)kb.getEquivalentClasses(C));
        Assert.assertEquals((long)1L, (long)classifyTimer.getCount());
        Assert.assertEquals(Collections.singleton(b), (Object)kb.getInstances(E));
        Assert.assertEquals((long)1L, (long)realizeTimer.getCount());
        Assert.assertEquals(Collections.singleton(b), (Object)kb.getInstances(E, true));
        Assert.assertEquals((long)2L, (long)realizeTimer.getCount());
        kb.addSubProperty((ATerm)p, q);
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((!kb.isClassified() ? 1 : 0) != 0);
        Assert.assertTrue((!kb.isRealized() ? 1 : 0) != 0);
        Assert.assertEquals(Collections.singleton(q), (Object)kb.getEquivalentProperties(p));
        Assert.assertEquals(Collections.singletonList(b), (Object)kb.getPropertyValues(q, a));
        Assert.assertTrue((!kb.isClassified() ? 1 : 0) != 0);
        Assert.assertTrue((!kb.isRealized() ? 1 : 0) != 0);
        Assert.assertEquals(Collections.singleton(E), (Object)kb.getEquivalentClasses(C));
        Assert.assertEquals((long)2L, (long)classifyTimer.getCount());
        Assert.assertEquals((Object)SetUtils.create((Object[])new ATermAppl[]{a, b}), (Object)kb.getInstances(E, true));
        Assert.assertEquals((long)3L, (long)realizeTimer.getCount());
    }

    @Test
    public void testCopyKB() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl E = TermFactory.term((String)"E");
        kb.addClass(C);
        kb.addClass(D);
        kb.addClass(E);
        kb.addSubClass(C, D);
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addType(a, C);
        Assert.assertFalse((boolean)kb.copy().isConsistencyDone());
        Assert.assertTrue((boolean)kb.isConsistent());
        KnowledgeBase copyKB = kb.copy();
        Assert.assertTrue((boolean)copyKB.isConsistencyDone());
        Assert.assertTrue((boolean)copyKB.getABox().isComplete());
        Assert.assertTrue((boolean)copyKB.isKnownType(a, C).isTrue());
        copyKB.addType(b, E);
        Assert.assertFalse((boolean)copyKB.isConsistencyDone());
        Assert.assertTrue((boolean)kb.isConsistencyDone());
        Assert.assertTrue((boolean)copyKB.isConsistent());
        Assert.assertTrue((boolean)kb.isType(a, C));
        Assert.assertTrue((boolean)kb.isType(a, D));
        Assert.assertFalse((boolean)kb.isType(b, E));
        Assert.assertTrue((boolean)kb.isSubClassOf(C, D));
        Assert.assertTrue((boolean)copyKB.isType(a, C));
        Assert.assertTrue((boolean)copyKB.isType(a, D));
        Assert.assertTrue((boolean)copyKB.isType(b, E));
        Assert.assertTrue((boolean)copyKB.isSubClassOf(C, D));
        copyKB.removeType(a, C);
        Assert.assertFalse((boolean)copyKB.isConsistencyDone());
        Assert.assertTrue((boolean)kb.isConsistencyDone());
        Assert.assertTrue((boolean)copyKB.isConsistent());
        Assert.assertTrue((boolean)kb.isType(a, C));
        Assert.assertTrue((boolean)kb.isType(a, D));
        Assert.assertFalse((boolean)kb.isType(b, E));
        Assert.assertFalse((boolean)copyKB.isType(a, C));
        Assert.assertFalse((boolean)copyKB.isType(a, D));
        Assert.assertTrue((boolean)copyKB.isType(b, E));
    }

    @Test
    public void testLiteralHasValue() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl lit = TermFactory.typedLiteral((String)"lit", (String)XSDString.instance.getURI());
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addObjectProperty((ATerm)p);
        kb.addDatatypeProperty((ATerm)q);
        kb.addPropertyValue(p, a, b);
        kb.addType(a, TermFactory.some((ATermAppl)q, (ATermAppl)TermFactory.value((ATermAppl)lit)));
        kb.ensureConsistency();
        Assert.assertTrue((boolean)kb.getABox().getLiteral((ATerm)lit).hasType((ATerm)RDFSLiteral.instance.getName()));
        kb.removePropertyValue(p, a, b);
        kb.ensureConsistency();
        Assert.assertTrue((boolean)kb.getABox().getLiteral((ATerm)lit).hasType((ATerm)RDFSLiteral.instance.getName()));
    }

    @Test
    public void testPrunedNode() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl B = TermFactory.term((String)"B");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        kb.addClass(A);
        kb.addClass(B);
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addSame(a, b);
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isSameAs(a, b));
        kb.addIndividual(a);
        kb.addType(a, A);
        kb.addIndividual(b);
        kb.addType(b, B);
        Assert.assertTrue((boolean)kb.isType(a, A));
        Assert.assertTrue((boolean)kb.isType(a, B));
        Assert.assertTrue((boolean)kb.isType(b, A));
        Assert.assertTrue((boolean)kb.isType(b, B));
    }
}

