/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.core.DataSourceGraph;
import com.hp.hpl.jena.query.core.DatasetGraph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.shared.LockMRSW;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public class DataSourceGraphImpl
implements DataSourceGraph {
    Graph defaultGraph = null;
    Map namedGraphs = null;
    Lock lock = null;

    public DataSourceGraphImpl(Graph graph) {
        this.defaultGraph = graph;
        this.namedGraphs = new HashMap();
    }

    public DataSourceGraphImpl(Dataset dataset) {
        this.cloneDataset(dataset);
    }

    public DataSourceGraphImpl(DatasetGraph dataset) {
        this.cloneDatasetGraph(dataset);
    }

    public DataSourceGraphImpl() {
    }

    public Graph getDefaultGraph() {
        return this.defaultGraph;
    }

    public void setDefaultGraph(Graph g) {
        this.defaultGraph = g;
    }

    public Graph getNamedGraph(String uri) {
        if (this.namedGraphs == null) {
            return null;
        }
        return (Graph)this.namedGraphs.get(uri);
    }

    public void addNamedGraph(String uri, Graph graph) {
        if (this.namedGraphs == null) {
            this.namedGraphs = new HashMap();
        }
        this.namedGraphs.put(uri, graph);
    }

    public boolean containsNamedGraph(String uri) {
        if (this.namedGraphs == null) {
            return false;
        }
        return this.namedGraphs.containsKey(uri);
    }

    public Iterator listNames() {
        if (this.namedGraphs == null) {
            return new NullIterator();
        }
        return this.namedGraphs.keySet().iterator();
    }

    public Lock getLock() {
        if (this.lock == null) {
            this.lock = new LockMRSW();
        }
        return this.lock;
    }

    private void cloneDataset(Dataset dataset) {
        if (dataset == null) {
            return;
        }
        if (dataset.getDefaultModel() != null) {
            this.defaultGraph = dataset.getDefaultModel().getGraph();
        }
        Iterator iter = dataset.listNames();
        while (iter.hasNext()) {
            String uri = (String)iter.next();
            Model m = dataset.getNamedModel(uri);
            if (m == null) continue;
            this.addNamedGraph(uri, m.getGraph());
        }
    }

    private void cloneDatasetGraph(DatasetGraph dataset) {
        if (!(dataset instanceof DataSourceGraphImpl)) {
            LogFactory.getLog((Class)DataSourceGraphImpl.class).fatal((Object)"Clone DatasetGraph: only DataSourceGraphImpl supported");
            return;
        }
        DataSourceGraphImpl ds = (DataSourceGraphImpl)dataset;
        this.namedGraphs = new HashMap(ds.namedGraphs);
        this.defaultGraph = ds.defaultGraph;
    }

    public String toString() {
        String s = "{";
        s = this.getDefaultGraph() == null ? s + "<null>" : s + "[" + this.getDefaultGraph().size() + "]";
        Iterator iter = this.listNames();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            s = s + ", (" + name + ", [" + this.getNamedGraph(name).size() + "])";
        }
        s = s + "}";
        return s;
    }
}

