/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBasicGraphPattern;
import com.hp.hpl.jena.query.core.ElementFilter;
import com.hp.hpl.jena.query.core.ElementVisitor;
import com.hp.hpl.jena.query.core.LabelMap;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ElementGroup
extends Element {
    private static Log log = LogFactory.getLog((Class)ElementGroup.class);
    List elements = new ArrayList();

    public void addElement(Element el) {
        this.elements.add(el);
    }

    public void addTriplePattern(Triple t) {
        this.ensureBGP().addTriple(t);
    }

    public void addElementFilter(ElementFilter el) {
        this.addElement(el);
    }

    private ElementBasicGraphPattern ensureBGP() {
        if (this.elements.size() == 0) {
            return this.pushBGP();
        }
        Element top = this.top();
        Object bgp = null;
        if (top instanceof ElementBasicGraphPattern) {
            return (ElementBasicGraphPattern)top;
        }
        return this.pushBGP();
    }

    private ElementBasicGraphPattern pushBGP() {
        ElementBasicGraphPattern bgp = new ElementBasicGraphPattern();
        this.elements.add(bgp);
        return bgp;
    }

    private void setTop(Element el) {
        this.elements.set(this.elements.size() - 1, el);
    }

    private Element top() {
        return (Element)this.elements.get(this.elements.size() - 1);
    }

    public int mark() {
        return this.elements.size();
    }

    public List getElements() {
        return this.elements;
    }

    public boolean isEmpty() {
        return this.elements.size() == 0;
    }

    public int hashCode() {
        int calcHashCode = 162;
        return calcHashCode ^= ((Object)this.getElements()).hashCode();
    }

    public boolean equalTo(Element el2, LabelMap labelMap) {
        if (el2 == null) {
            return false;
        }
        if (!(el2 instanceof ElementGroup)) {
            return false;
        }
        ElementGroup eg2 = (ElementGroup)el2;
        if (this.getElements().size() != eg2.getElements().size()) {
            return false;
        }
        for (int i = 0; i < this.getElements().size(); ++i) {
            Element e2;
            Element e1 = (Element)this.getElements().get(i);
            if (e1.equalTo(e2 = (Element)eg2.getElements().get(i), labelMap)) continue;
            return false;
        }
        return true;
    }

    public void visit(ElementVisitor v) {
        v.visit(this);
    }
}

