/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBasicGraphPattern;
import com.hp.hpl.jena.query.core.ElementDataset;
import com.hp.hpl.jena.query.core.ElementExtension;
import com.hp.hpl.jena.query.core.ElementFilter;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.ElementNamedGraph;
import com.hp.hpl.jena.query.core.ElementOptional;
import com.hp.hpl.jena.query.core.ElementUnion;
import com.hp.hpl.jena.query.core.ElementUnsaid;
import com.hp.hpl.jena.query.core.ElementVisitor;
import java.util.Iterator;
import java.util.ListIterator;

public class ElementWalker {
    public static void walk(Element el, ElementVisitor visitor) {
        el.visit(new Walker(visitor));
    }

    private static class Walker
    implements ElementVisitor {
        ElementVisitor proc;

        private Walker(ElementVisitor visitor) {
            this.proc = visitor;
        }

        public void visit(ElementBasicGraphPattern el) {
            this.proc.visit(el);
        }

        public void visit(ElementFilter el) {
            this.proc.visit(el);
        }

        public void visit(ElementUnion el) {
            ListIterator iter = el.getElements().listIterator();
            while (iter.hasNext()) {
                Element e2 = (Element)iter.next();
                e2.visit(this);
            }
            this.proc.visit(el);
        }

        public void visit(ElementGroup el) {
            Iterator iter = el.getElements().iterator();
            while (iter.hasNext()) {
                Element e2 = (Element)iter.next();
                e2.visit(this);
            }
            this.proc.visit(el);
        }

        public void visit(ElementOptional el) {
            if (el.getOptionalElement() != null) {
                el.getOptionalElement().visit(this);
            }
            this.proc.visit(el);
        }

        public void visit(ElementDataset el) {
            if (el.getPatternElement() != null) {
                el.getPatternElement().visit(this);
            }
            this.proc.visit(el);
        }

        public void visit(ElementNamedGraph el) {
            if (el.getElement() != null) {
                el.getElement().visit(this);
            }
            this.proc.visit(el);
        }

        public void visit(ElementUnsaid el) {
            if (el.getElement() != null) {
                el.getElement().visit(this);
            }
            this.proc.visit(el);
        }

        public void visit(ElementExtension el) {
            this.proc.visit(el);
        }
    }
}

