/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Variable;
import com.hp.hpl.jena.query.core.ARQConstants;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.expr.NodeVar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class Var
extends Node_Variable {
    public static Var alloc(String varName) {
        return new Var(varName);
    }

    public static Var alloc(Node_Variable v) {
        if (v instanceof Var) {
            return (Var)v;
        }
        return new Var(v);
    }

    public static Var alloc(Node v) {
        if (v instanceof Var) {
            return (Var)v;
        }
        if (v instanceof Node_Variable) {
            return new Var((Node_Variable)v);
        }
        throw new NotAVariableException("Node: " + v);
    }

    public static Var alloc(NodeVar nv) {
        return new Var(nv);
    }

    private Var(String varName) {
        super(varName);
    }

    private Var(Node_Variable v) {
        this(v.getName());
    }

    private Var(NodeVar v) {
        this(v.getVarName());
    }

    public Node asNode() {
        return this;
    }

    public String getVarName() {
        return this.getName();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Var)) {
            return false;
        }
        return super.equals((Object)((Var)((Object)other)));
    }

    public boolean isNamedVar() {
        return Var.isNamedVar(this.getName());
    }

    public boolean isSystemVar() {
        return Var.isSystemVarName(this.getName());
    }

    public boolean isBlankNodeVar() {
        return Var.isBlankNodeVarName(this.getName());
    }

    public boolean isAllocVar() {
        return Var.isAllocVarName(this.getName());
    }

    public static String canonical(String x) {
        if (x.startsWith("?")) {
            return x.substring(1);
        }
        if (x.startsWith("$")) {
            return x.substring(1);
        }
        return x;
    }

    public static boolean isVar(Node node) {
        if (node instanceof Var) {
            return true;
        }
        if (node.isVariable()) {
            throw new NotAVariableException("Node_variable (not a Var) found");
        }
        return false;
    }

    public static boolean isNamedVar(Node node) {
        return node.isVariable() && Var.isNamedVar(node.getName());
    }

    public static boolean isNamedVar(String x) {
        return !Var.isSystemVarName(x) && !Var.isBlankNodeVarName(x) && !Var.isAllocVarName(x);
    }

    public static boolean isBlankNodeVar(Node node) {
        return node.isVariable() && Var.isBlankNodeVarName(node.getName());
    }

    public static boolean isSystemVar(Node node) {
        return node.isVariable() && Var.isSystemVarName(node.getName());
    }

    public static boolean isSystemVarName(String x) {
        return x.startsWith("#");
    }

    public static boolean isBlankNodeVarName(String x) {
        return x.startsWith(ARQConstants.anonVarMarker);
    }

    public static boolean isAllocVarName(String x) {
        return x.startsWith("@");
    }

    public static List varList(List varNames) {
        ArrayList<Var> x = new ArrayList<Var>();
        ListIterator iter = varNames.listIterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof String) {
                x.add(Var.alloc((String)obj));
                continue;
            }
            if (obj instanceof Var) {
                x.add((Var)((Object)obj));
                continue;
            }
            throw new ARQInternalErrorException("Element of a var list is not a string or a var: " + obj);
        }
        return x;
    }

    public static Collection names(Collection vars) {
        ArrayList<String> x = new ArrayList<String>();
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof Var) {
                x.add(((Var)((Object)obj)).getVarName());
                continue;
            }
            if (obj instanceof String) {
                x.add((String)obj);
                continue;
            }
            throw new ARQInternalErrorException("Element of a var list is not a string or a var: " + obj);
        }
        return x;
    }

    static class NotAVariableException
    extends ARQInternalErrorException {
        NotAVariableException(String msg) {
            super(msg);
        }
    }
}

