/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.core.DataSourceGraphImpl;
import com.hp.hpl.jena.query.core.DataSourceImpl;
import com.hp.hpl.jena.query.core.DatasetGraph;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ResultBinding;
import com.hp.hpl.jena.query.core.Template;
import com.hp.hpl.jena.query.core.Var;
import com.hp.hpl.jena.query.describe.DescribeHandler;
import com.hp.hpl.jena.query.describe.DescribeHandlerRegistry;
import com.hp.hpl.jena.query.engine.Plan;
import com.hp.hpl.jena.query.engine.QueryExecutionGraph;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine.ResultSetStream;
import com.hp.hpl.jena.query.engine1.EngineConfig;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.QueryEngineUtils;
import com.hp.hpl.jena.query.engine1.iterator.QueryIter;
import com.hp.hpl.jena.query.util.Context;
import com.hp.hpl.jena.query.util.DatasetUtils;
import com.hp.hpl.jena.query.util.GraphUtils;
import com.hp.hpl.jena.query.util.NodeUtils;
import com.hp.hpl.jena.query.util.RelURI;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.FileManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class QueryEngineBase
implements QueryExecution,
QueryExecutionGraph {
    private static Log log = LogFactory.getLog((Class)QueryEngineBase.class);
    protected Query query;
    static int queryCount = 0;
    protected boolean queryExecutionInitialised = false;
    protected boolean queryExecutionClosed = false;
    protected int idQueryExecution;
    protected QueryIterator resultsIter;
    private Context context;
    protected Plan plan = null;
    private ExecutionContext execContext = null;
    protected QuerySolution startBinding = null;
    private FileManager fileManager = null;
    private Dataset dataset = null;
    private DatasetGraph datasetGraph = null;

    protected QueryEngineBase(Query q, Context context) {
        if (context == null) {
            context = new Context(EngineConfig.getContext());
        }
        this.query = q;
        this.idQueryExecution = ++queryCount;
        this.context = context;
    }

    public Query getQuery() {
        return this.query;
    }

    protected void init() {
        if (this.queryExecutionInitialised) {
            return;
        }
        this.startInitializing();
        this.query.setResultVars();
        if (this.getDataset() != null && this.getDatasetGraph() != null) {
            log.warn((Object)"Both dataset and datasetGraph are set (ignoring dataset");
            this.dataset = null;
        }
        if (this.getDataset() == null && this.getDatasetGraph() == null) {
            this.datasetGraph = this.buildDatasetForQuery();
        } else if (this.getDataset() != null) {
            if (this.getDataset().getDefaultModel() == null) {
                log.warn((Object)"Default model is null in the dataset");
            }
            this.datasetGraph = new DataSourceGraphImpl(this.getDataset());
        }
        if (this.getDataset() == null) {
            this.dataset = new DataSourceImpl(this.datasetGraph);
        }
        this.execContext = new ExecutionContext(this.context, this.getQuery(), this.datasetGraph.getDefaultGraph(), this.datasetGraph);
        this.queryExecutionInitialised = true;
        this.finishInitializing();
    }

    protected void startInitializing() {
    }

    protected void finishInitializing() {
    }

    protected DatasetGraph buildDatasetForQuery() {
        if (!(this.query.getGraphURIs() != null && this.query.getGraphURIs().size() != 0 || this.query.getNamedGraphURIs() != null && this.query.getNamedGraphURIs().size() != 0)) {
            throw new QueryExecException("No model for query");
        }
        String baseURI = this.query.getBaseURI();
        if (baseURI == null) {
            baseURI = RelURI.chooseBaseURI();
        }
        log.debug((Object)("init: baseURI for query is: " + baseURI));
        DatasetGraph dsg = DatasetUtils.createDatasetGraph(this.query.getGraphURIs(), this.query.getNamedGraphURIs(), this.fileManager, baseURI);
        return dsg;
    }

    public void setInitialBinding(QuerySolution rb) {
        this.startBinding = rb;
    }

    public void setFileManager(FileManager fm) {
        this.fileManager = fm;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public DatasetGraph getDatasetGraph() {
        return this.datasetGraph;
    }

    public void setDatasetGraph(DatasetGraph dataset) {
        this.datasetGraph = dataset;
    }

    public Context getContext() {
        return this.context;
    }

    public ExecutionContext getExecContext() {
        return this.execContext;
    }

    public QueryIterator exec() {
        return this.execInternalGraph();
    }

    public ResultSet execSelect() {
        if (!this.query.isSelectType()) {
            throw new QueryExecException("Attempt to have ResultSet from a " + QueryEngineBase.labelForQuery(this.query) + " query");
        }
        this.init();
        return this.execInternal();
    }

    public Model execConstruct() {
        return this.execConstruct(GraphUtils.makeJenaDefaultModel());
    }

    public Model execConstruct(Model model) {
        if (!this.query.isConstructType()) {
            throw new QueryExecException("Attempt to get a CONSTRUCT model from a " + QueryEngineBase.labelForQuery(this.query) + " query");
        }
        this.query.setQueryResultStar(true);
        ResultSet qRes = this.execInternal();
        this.insertPrefixesInto(model);
        HashSet set = new HashSet();
        Template template = this.query.getConstructTemplate();
        while (qRes.hasNext()) {
            HashMap bNodeMap = new HashMap();
            QuerySolution qs = qRes.nextSolution();
            ResultBinding rb = (ResultBinding)qs;
            template.subst(set, bNodeMap, rb.getBinding());
        }
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            Statement stmt = QueryEngineUtils.tripleToStatement(model, t);
            if (stmt == null) continue;
            model.add(stmt);
        }
        this.close();
        return model;
    }

    public Model execDescribe() {
        return this.execDescribe(GraphUtils.makeJenaDefaultModel());
    }

    public Model execDescribe(Model model) {
        DescribeHandler dh;
        Iterator iter;
        if (!this.query.isDescribeType()) {
            throw new QueryExecException("Attempt to get a DESCRIBE result from a " + QueryEngineBase.labelForQuery(this.query) + " query");
        }
        this.query.setQueryResultStar(true);
        HashSet<RDFNode> set = new HashSet<RDFNode>();
        ResultSet qRes = this.execInternal();
        this.insertPrefixesInto(model);
        if (qRes != null) {
            while (qRes.hasNext()) {
                QuerySolution rb = qRes.nextSolution();
                iter = this.query.getResultVars().iterator();
                while (iter.hasNext()) {
                    String varName = (String)iter.next();
                    RDFNode n = rb.get(varName);
                    set.add(n);
                }
            }
        }
        if (this.query.getResultURIs() != null) {
            Iterator iter2 = this.query.getResultURIs().iterator();
            while (iter2.hasNext()) {
                Node n = (Node)iter2.next();
                RDFNode rNode = NodeUtils.convertGraphNodeToRDFNode(n, this.dataset.getDefaultModel());
                set.add(rNode);
            }
        }
        DescribeHandlerRegistry dhReg = DescribeHandlerRegistry.get();
        Iterator handlers = dhReg.handlers();
        while (handlers.hasNext()) {
            dh = (DescribeHandler)handlers.next();
            dh.start(model, this.execContext);
        }
        iter = set.iterator();
        while (iter.hasNext()) {
            RDFNode n = (RDFNode)iter.next();
            if (!(n instanceof Resource)) continue;
            Iterator handlers2 = dhReg.handlers();
            while (handlers2.hasNext()) {
                DescribeHandler dh2 = (DescribeHandler)handlers2.next();
                dh2.describe((Resource)n);
            }
        }
        handlers = dhReg.handlers();
        while (handlers.hasNext()) {
            dh = (DescribeHandler)handlers.next();
            dh.finish();
        }
        this.close();
        return model;
    }

    public boolean execAsk() {
        if (!this.query.isAskType()) {
            throw new QueryExecException("Attempt to have boolean from a " + QueryEngineBase.labelForQuery(this.query) + " query");
        }
        this.init();
        ResultSet results = this.execInternal();
        boolean r = results.hasNext();
        this.close();
        return r;
    }

    private ResultSet execInternal() {
        this.init();
        this.query.setResultVars();
        if (this.query.getQueryPattern() == null) {
            return null;
        }
        this.resultsIter = this.execInternalGraph();
        Object model = null;
        if (this.dataset != null) {
            model = this.dataset.getDefaultModel();
        }
        if (model == null) {
            Graph g = this.datasetGraph.getDefaultGraph();
            model = g != null ? ModelFactory.createModelForGraph((Graph)g) : null;
        }
        ResultSetStream rStream = new ResultSetStream(this.query.getResultVars(), (Model)model, this.resultsIter);
        if (this.query.hasOrderBy()) {
            rStream.setOrdered(true);
        }
        if (this.query.isDistinct()) {
            rStream.setDistinct(true);
        }
        return rStream;
    }

    private QueryIterator execInternalGraph() {
        QueryIterator qIter;
        this.init();
        Plan plan = this.getPlan();
        this.resultsIter = qIter = plan.iterator();
        return this.resultsIter;
    }

    protected Modifiers getModifiers() {
        Modifiers mods = new Modifiers(this.query);
        if (this.query.isConstructType()) {
            mods.projectVars = null;
        }
        return mods;
    }

    protected abstract Plan queryToPlan(Query var1, Modifiers var2, Element var3);

    public Plan getPlan() {
        if (this.plan == null) {
            this.plan = this.queryToPlan();
        }
        return this.plan;
    }

    private Plan queryToPlan() {
        Modifiers mods = this.getModifiers();
        Plan plan = this.queryToPlan(this.query, mods, this.query.getQueryPattern());
        return plan;
    }

    public void abort() {
        this.close(true);
    }

    public void close() {
        this.close(true);
    }

    private void close(boolean forceClose) {
        if (this.queryExecutionClosed) {
            return;
        }
        if (!this.queryExecutionInitialised) {
            log.warn((Object)"Closing a query that has not been run");
            return;
        }
        if (forceClose) {
            if (this.resultsIter != null) {
                this.resultsIter.close();
            }
            this.resultsIter = null;
        }
        Iterator iter = this.execContext.listOpenIterators();
        while (iter.hasNext()) {
            QueryIterator qIterOpen = (QueryIterator)iter.next();
            if (qIterOpen instanceof QueryIter) {
                QueryIter qIterBase = (QueryIter)qIterOpen;
                log.warn((Object)("Open iterator: " + qIterBase.getIteratorNumber() + " " + qIterOpen));
                continue;
            }
            log.warn((Object)("Open iterator: " + qIterOpen));
        }
        if (this.resultsIter != null) {
            this.resultsIter.close();
        }
        this.resultsIter = null;
        this.queryExecutionClosed = true;
    }

    private void insertPrefixesInto(Model model) {
        try {
            PrefixMapping m = this.datasetGraph.getDefaultGraph().getPrefixMapping();
            model.setNsPrefixes(m);
            model.setNsPrefixes(this.query.getPrefixMapping());
        }
        catch (Exception ex) {
            log.warn((Object)("Exception in insertPrefixes: " + ex.getMessage()), (Throwable)ex);
        }
    }

    private static String labelForQuery(Query q) {
        if (q.isSelectType()) {
            return "SELECT";
        }
        if (q.isConstructType()) {
            return "CONSTRUCT";
        }
        if (q.isDescribeType()) {
            return "DESCRIBE";
        }
        if (q.isAskType()) {
            return "ASK";
        }
        return "<<unknown>>";
    }

    public static class Modifiers {
        public long start;
        public long length;
        public boolean distinct;
        public List projectVars;
        public List orderConditions;

        public Modifiers(Query query) {
            this.start = query.getOffset();
            this.length = query.getLimit();
            this.distinct = query.isDistinct();
            this.projectVars = Var.varList(query.getResultVars());
            this.orderConditions = query.getOrderBy();
        }
    }
}

