/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.core.Var;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanVisitor;
import com.hp.hpl.jena.query.engine1.plan.PlanBasicGraphPattern;
import com.hp.hpl.jena.query.engine1.plan.PlanBlockTriples;
import com.hp.hpl.jena.query.engine1.plan.PlanDataset;
import com.hp.hpl.jena.query.engine1.plan.PlanDistinct;
import com.hp.hpl.jena.query.engine1.plan.PlanElementExternal;
import com.hp.hpl.jena.query.engine1.plan.PlanExtension;
import com.hp.hpl.jena.query.engine1.plan.PlanFilter;
import com.hp.hpl.jena.query.engine1.plan.PlanGroup;
import com.hp.hpl.jena.query.engine1.plan.PlanLimitOffset;
import com.hp.hpl.jena.query.engine1.plan.PlanNamedGraph;
import com.hp.hpl.jena.query.engine1.plan.PlanOptional;
import com.hp.hpl.jena.query.engine1.plan.PlanOrderBy;
import com.hp.hpl.jena.query.engine1.plan.PlanOuterJoin;
import com.hp.hpl.jena.query.engine1.plan.PlanProject;
import com.hp.hpl.jena.query.engine1.plan.PlanPropertyFunction;
import com.hp.hpl.jena.query.engine1.plan.PlanUnion;
import com.hp.hpl.jena.query.engine1.plan.PlanUnsaid;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.serializer.FmtExprARQ;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.FmtUtils;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.shared.PrefixMapping;
import java.util.Collection;
import java.util.Iterator;

public class PlanFormatterVisitor
implements PlanVisitor {
    protected static final int INDENT = 2;
    private static boolean defaultClosingBracketOnSameLine = true;
    protected IndentedWriter out;
    protected SerializationContext context;
    private boolean closingBracketOnSameLine = defaultClosingBracketOnSameLine;

    public PlanFormatterVisitor(IndentedWriter w, PrefixMapping pmap) {
        this(w, new SerializationContext(pmap));
    }

    public PlanFormatterVisitor(IndentedWriter w, SerializationContext context) {
        this.out = w;
        this.context = context;
    }

    public void startVisit() {
    }

    public void finishVisit() {
        this.out.ensureStartOfLine();
        this.out.flush();
    }

    public void visit(PlanBlockTriples planElt) {
        this.start("Triples");
        if (planElt.getPattern().size() == 1) {
            this.out.print(" ");
            Triple t = (Triple)planElt.getPattern().get(0);
            this.formatTriple(t);
            this.finish();
            return;
        }
        this.out.incIndent(2);
        Iterator iter = planElt.getPattern().iterator();
        while (iter.hasNext()) {
            this.out.newline();
            Triple t = (Triple)iter.next();
            this.formatTriple(t);
        }
        if (this.closingBracketOnSameLine) {
            this.out.newline();
        }
        this.out.decIndent(2);
        this.finish();
    }

    public void visit(PlanBasicGraphPattern planElt) {
        String s = "BasicGraphPattern";
        this.multipleSubPlans(s, planElt.iterator());
    }

    public void visit(PlanGroup planElt) {
        String s = "Group";
        if (!planElt.canReorder()) {
            s = "Group(fixed)";
        }
        this.multipleSubPlans(s, planElt.iterator());
    }

    public void visit(PlanUnion planElt) {
        this.multipleSubPlans("Union", planElt.getSubElements().iterator());
    }

    public void visit(PlanOptional planElt) {
        this.singleSubPlan("Optional", planElt.getOptional());
    }

    public void visit(PlanUnsaid planElt) {
        this.singleSubPlan("Unsaid", planElt.getSubElement());
    }

    public void visit(PlanFilter planElt) {
        this.start("Constraint");
        this.out.print(" ");
        Expr c = planElt.getExpr();
        FmtExprARQ.format(this.out, this.context, c);
        this.finish();
    }

    public void visit(PlanNamedGraph planElt) {
        this.start("NamedGraph");
        this.out.print(" ");
        this.out.print(this.slotToString(planElt.getGraphNameNode()));
        this.out.incIndent(2);
        if (planElt.getSubElement() != null) {
            this.out.println();
            planElt.getSubElement().visit(this);
        }
        this.out.decIndent(2);
        this.finish();
    }

    public void visit(PlanOuterJoin planElt) {
        this.multipleSubPlans("OuterJoin", planElt.getPlanElements().iterator());
    }

    public void visit(PlanPropertyFunction planElt) {
        this.start("PropertyFunction");
        this.out.print(" ");
        planElt.getSubjArgs().output(this.out, this.context);
        this.out.print(" ");
        this.out.print(FmtUtils.stringForNode(planElt.getPredicate(), this.context));
        this.out.print(" ");
        planElt.getObjArgs().output(this.out, this.context);
        this.finish();
    }

    public void visit(PlanExtension planElt) {
        this.start("Extension");
        this.out.print(" <");
        this.out.print(planElt.getElement().getURI());
        this.out.print(">");
        this.finish();
    }

    public void visit(PlanDataset planElt) {
        this.singleSubPlan("Block", planElt.getSubElement());
    }

    public void visit(PlanElementExternal planElt) {
        planElt.output(this.out, this.context);
    }

    public void visit(PlanDistinct planElt) {
        this.singleSubPlan("Distinct", planElt.getSubElement(), planElt.getVars());
    }

    public void visit(PlanProject planElt) {
        this.singleSubPlan("Project", planElt.getSubElement(), planElt.getVars());
    }

    public void visit(PlanOrderBy planElt) {
        this.singleSubPlan("OrderBy", planElt.getSubElement());
    }

    public void visit(PlanLimitOffset planElt) {
        this.singleSubPlan("LimitOffset", planElt.getSubElement());
    }

    private void plainPlan(String label) {
        this.start(label);
        this.finish();
    }

    private void singleSubPlan(String label, PlanElement subElt) {
        this.singleSubPlan(label, subElt, null);
    }

    private void singleSubPlan(String label, PlanElement subElt, Collection vars) {
        this.start(label);
        if (vars != null) {
            Iterator iter = vars.iterator();
            while (iter.hasNext()) {
                Var vn = (Var)((Object)iter.next());
                this.out.print(" ?");
                this.out.print(vn.getVarName());
            }
        }
        this.out.incIndent(2);
        if (subElt != null) {
            this.out.println();
            subElt.visit(this);
        }
        this.out.decIndent(2);
        this.finish();
    }

    private void multipleSubPlans(String label, Iterator iter) {
        this.start(label);
        this.out.incIndent(2);
        while (iter.hasNext()) {
            this.out.newline();
            PlanElement element = (PlanElement)iter.next();
            element.visit(this);
        }
        this.out.decIndent(2);
        this.finish();
    }

    private void start(String name) {
        this.out.print("[");
        this.out.print(name);
    }

    private void finish() {
        if (this.closingBracketOnSameLine) {
            this.out.print("]");
        } else {
            this.out.println();
            this.out.print("]");
        }
    }

    private void formatTriple(Triple tp) {
        this.out.print(this.slotToString(tp.getSubject()));
        this.out.print(" ");
        this.out.print(this.slotToString(tp.getPredicate()));
        this.out.print(" ");
        this.out.print(this.slotToString(tp.getObject()));
    }

    private String slotToString(Node n) {
        return FmtUtils.stringForNode(n, this.context);
    }
}

