/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1;

import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanVisitor;
import com.hp.hpl.jena.query.engine1.plan.PlanBasicGraphPattern;
import com.hp.hpl.jena.query.engine1.plan.PlanBlockTriples;
import com.hp.hpl.jena.query.engine1.plan.PlanDataset;
import com.hp.hpl.jena.query.engine1.plan.PlanDistinct;
import com.hp.hpl.jena.query.engine1.plan.PlanElementExternal;
import com.hp.hpl.jena.query.engine1.plan.PlanExtension;
import com.hp.hpl.jena.query.engine1.plan.PlanFilter;
import com.hp.hpl.jena.query.engine1.plan.PlanGroup;
import com.hp.hpl.jena.query.engine1.plan.PlanLimitOffset;
import com.hp.hpl.jena.query.engine1.plan.PlanNamedGraph;
import com.hp.hpl.jena.query.engine1.plan.PlanOptional;
import com.hp.hpl.jena.query.engine1.plan.PlanOrderBy;
import com.hp.hpl.jena.query.engine1.plan.PlanOuterJoin;
import com.hp.hpl.jena.query.engine1.plan.PlanProject;
import com.hp.hpl.jena.query.engine1.plan.PlanPropertyFunction;
import com.hp.hpl.jena.query.engine1.plan.PlanUnion;
import com.hp.hpl.jena.query.engine1.plan.PlanUnsaid;
import java.util.Iterator;
import org.apache.commons.logging.LogFactory;

public class PlanWalker {
    public static void walk(PlanElement el, PlanVisitor v) {
        if (el == null) {
            LogFactory.getLog((Class)PlanWalker.class).warn((Object)"Attempt to walk a null PlanElement - ignored");
            return;
        }
        el.visit(new Walker(v));
    }

    private static class Walker
    implements PlanVisitor {
        PlanVisitor proc;

        Walker(PlanVisitor v) {
            this.proc = v;
        }

        public void visit(PlanBlockTriples planElt) {
            this.proc.visit(planElt);
        }

        public void visit(PlanBasicGraphPattern planElt) {
            Iterator iter = planElt.iterator();
            while (iter.hasNext()) {
                PlanElement e2 = (PlanElement)iter.next();
                e2.visit(this.proc);
            }
            this.proc.visit(planElt);
        }

        public void visit(PlanGroup planElt) {
            Iterator iter = planElt.iterator();
            while (iter.hasNext()) {
                PlanElement e2 = (PlanElement)iter.next();
                e2.visit(this);
            }
            this.proc.visit(planElt);
        }

        public void visit(PlanUnion planElt) {
            Iterator iter = planElt.getSubElements().iterator();
            while (iter.hasNext()) {
                PlanElement e2 = (PlanElement)iter.next();
                e2.visit(this);
            }
            this.proc.visit(planElt);
        }

        public void visit(PlanOptional planElt) {
            this.visitOrNull(planElt.getOptional());
            this.proc.visit(planElt);
        }

        public void visit(PlanUnsaid planElt) {
            this.visitOrNull(planElt.getSubElement());
            this.proc.visit(planElt);
        }

        public void visit(PlanFilter planElt) {
            this.proc.visit(planElt);
        }

        public void visit(PlanNamedGraph planElt) {
            this.visitOrNull(planElt.getSubElement());
            this.proc.visit(planElt);
        }

        public void visit(PlanOuterJoin planElt) {
            Iterator iter = planElt.getPlanElements().iterator();
            while (iter.hasNext()) {
                PlanElement e2 = (PlanElement)iter.next();
                e2.visit(this);
            }
            this.proc.visit(planElt);
        }

        public void visit(PlanPropertyFunction planElt) {
            this.proc.visit(planElt);
        }

        public void visit(PlanExtension planElt) {
            this.proc.visit(planElt);
        }

        public void visit(PlanDataset planElt) {
            this.visitOrNull(planElt.getSubElement());
            this.proc.visit(planElt);
        }

        public void visit(PlanElementExternal planElt) {
            this.proc.visit(planElt);
        }

        public void visit(PlanProject planElt) {
            this.visitOrNull(planElt.getSubElement());
            this.proc.visit(planElt);
        }

        public void visit(PlanDistinct planElt) {
            this.visitOrNull(planElt.getSubElement());
            this.proc.visit(planElt);
        }

        public void visit(PlanOrderBy planElt) {
            this.visitOrNull(planElt.getSubElement());
            this.proc.visit(planElt);
        }

        public void visit(PlanLimitOffset planElt) {
            this.visitOrNull(planElt.getSubElement());
            this.proc.visit(planElt);
        }

        private void visitOrNull(PlanElement pElt) {
            if (pElt != null) {
                pElt.visit(this);
            }
        }
    }
}

