/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.engine.Binding;
import com.hp.hpl.jena.query.engine.BindingRoot;
import com.hp.hpl.jena.query.engine.Plan;
import com.hp.hpl.jena.query.engine.QueryEngineBase;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.EngineConfig;
import com.hp.hpl.jena.query.engine1.Plan1;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.QueryEngineUtils;
import com.hp.hpl.jena.query.engine1.compiler.QueryPatternCompiler;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterNullIterator;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterSingleton;
import com.hp.hpl.jena.query.engine1.plan.PlanDistinct;
import com.hp.hpl.jena.query.engine1.plan.PlanLimitOffset;
import com.hp.hpl.jena.query.engine1.plan.PlanOrderBy;
import com.hp.hpl.jena.query.engine1.plan.PlanProject;
import com.hp.hpl.jena.query.util.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryEngine
extends QueryEngineBase {
    private static Log log = LogFactory.getLog((Class)QueryEngine.class);
    private PlanElement plan = null;
    private PlanElement planPattern = null;

    public QueryEngine(Query q) {
        this(q, null);
    }

    public QueryEngine(Query q, Context context) {
        super(q, context);
        if (context == null) {
            context = new Context(EngineConfig.getContext());
        }
    }

    public PlanElement getPlanElement() {
        if (this.plan == null) {
            this.plan = this.buildPlan(this.getModifiers(), this.query.getQueryPattern());
        }
        return this.plan;
    }

    public PlanElement getPlanPattern() {
        if (this.plan == null) {
            this.getPlanElement();
        }
        return this.planPattern;
    }

    protected final Plan queryToPlan(Query query, QueryEngineBase.Modifiers modifiers, Element pattern) {
        if (this.plan == null) {
            this.plan = this.buildPlan(this.getModifiers(), query.getQueryPattern());
        }
        PlanElement pElt = this.getPlanElement();
        return new Plan1(pElt, this);
    }

    protected PlanElement makePlanForQueryPattern(Context context, Element queryPatternElement) {
        if (queryPatternElement == null) {
            return null;
        }
        return QueryPatternCompiler.makePlan(context, queryPatternElement);
    }

    protected PlanElement queryPlanPatternHook(Context context, PlanElement planElt) {
        return planElt;
    }

    protected PlanElement queryPlanHook(Context context, PlanElement planElt) {
        return planElt;
    }

    private PlanElement buildPlan(QueryEngineBase.Modifiers mods, Element pattern) {
        if (this.plan != null) {
            return this.plan;
        }
        this.planPattern = this.makePlanForQueryPattern(this.getContext(), pattern);
        PlanElement planElt = this.planPattern = this.queryPlanPatternHook(this.getContext(), this.planPattern);
        if (mods.orderConditions != null) {
            planElt = PlanOrderBy.make(this.getContext(), planElt, mods.orderConditions);
        }
        if (mods.projectVars != null && !this.query.isQueryResultStar()) {
            if (mods.projectVars.size() == 0 && this.query.isSelectType()) {
                log.warn((Object)"No project variables");
            }
            if (mods.projectVars.size() > 0) {
                planElt = PlanProject.make(this.getContext(), planElt, mods.projectVars);
            }
        }
        if (this.query.isDistinct() || this.getContext().isTrue(EngineConfig.autoDistinct)) {
            planElt = PlanDistinct.make(this.getContext(), planElt, mods.projectVars);
        }
        if (this.query.hasLimit() || this.query.hasOffset()) {
            planElt = PlanLimitOffset.make(this.getContext(), planElt, mods.start, mods.length);
        }
        this.plan = planElt;
        this.plan = this.queryPlanHook(this.getContext(), this.plan);
        return this.plan;
    }

    QueryIterator planToIterator(PlanElement pElt) {
        QueryIterator qIter = null;
        try {
            if (!this.queryExecutionInitialised) {
                throw new ARQInternalErrorException("Query execution not initialized");
            }
            Binding rootBinding = this.buildInitialBinding();
            QueryIterSingleton initialIter = new QueryIterSingleton(rootBinding, this.getExecContext());
            if (pElt == null) {
                if (this.startBinding != null) {
                    return initialIter;
                }
                return new QueryIterNullIterator(this.getExecContext());
            }
            qIter = pElt.build(initialIter, this.getExecContext());
            return qIter;
        }
        catch (RuntimeException ex) {
            if (qIter != null) {
                qIter.close();
            }
            throw ex;
        }
    }

    private Binding buildInitialBinding() {
        Binding rootBinding = QueryEngine.makeRootBinding();
        if (this.startBinding != null) {
            QueryEngineUtils.addToBinding(rootBinding, this.startBinding);
        }
        return rootBinding;
    }

    private static Binding makeRootBinding() {
        Binding rootBinding = BindingRoot.create();
        return rootBinding;
    }
}

