/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.plan;

import com.hp.hpl.jena.query.core.ElementFilter;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanVisitor;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterConstraintFilter;
import com.hp.hpl.jena.query.engine1.plan.PlanElement0;
import com.hp.hpl.jena.query.engine1.plan.Transform;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprBuild;
import com.hp.hpl.jena.query.expr.ExprWalker;
import com.hp.hpl.jena.query.util.Context;
import com.hp.hpl.jena.query.util.Utils;
import org.apache.commons.logging.LogFactory;

public class PlanFilter
extends PlanElement0 {
    ElementFilter element;

    public static PlanElement make(Context context, ElementFilter el) {
        return new PlanFilter(context, el);
    }

    private PlanFilter(Context context, ElementFilter el) {
        super(context);
        this.element = el;
    }

    public QueryIterator build(QueryIterator input, ExecutionContext execCxt) {
        Expr ex;
        if (input == null) {
            LogFactory.getLog(this.getClass()).fatal((Object)("Null input to " + Utils.classShortName(this.getClass())));
        }
        if ((ex = this.element.getExpr().deepCopy()) == null) {
            ex = this.element.getExpr();
        }
        ExprWalker.walk(new ExprBuild(execCxt), ex);
        return new QueryIterConstraintFilter(input, this.element.getExpr(), execCxt);
    }

    public Expr getExpr() {
        return this.element.getExpr();
    }

    public void visit(PlanVisitor visitor) {
        visitor.visit(this);
    }

    public PlanElement apply(Transform transform) {
        return transform.transform(this);
    }

    public PlanElement copy() {
        return PlanFilter.make(this.getContext(), this.element);
    }
}

