/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.plan;

import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanVisitor;
import com.hp.hpl.jena.query.engine1.analyse.PlanVarsMentioned;
import com.hp.hpl.jena.query.engine1.plan.PlanDistinct;
import com.hp.hpl.jena.query.engine1.plan.PlanElement0;
import com.hp.hpl.jena.query.engine1.plan.PlanGroup;
import com.hp.hpl.jena.query.engine1.plan.PlanUnion;
import com.hp.hpl.jena.query.engine1.plan.Transform;
import com.hp.hpl.jena.query.util.Context;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlanOuterJoin
extends PlanElement0 {
    static Log log = LogFactory.getLog((Class)PlanOuterJoin.class);
    Set planElements;
    PlanElement planElement;

    public static PlanElement make(Context context, Set equiv) {
        PlanElement p = PlanOuterJoin.permute(context, equiv);
        Set vars = PlanVarsMentioned.varMentioned(p);
        p = PlanDistinct.make(context, p, vars);
        return p;
    }

    private PlanOuterJoin(Context context, Set planElements) {
        super(context);
        this.planElements = planElements;
        this.planElement = PlanOuterJoin.permute(this.getContext(), planElements);
    }

    public Set getPlanElements() {
        return this.planElements;
    }

    public QueryIterator build(QueryIterator input, ExecutionContext execCxt) {
        return this.planElement.build(input, execCxt);
    }

    private static PlanElement permute(Context context, Set planElements) {
        if (planElements.size() != 2) {
            log.fatal((Object)("Can only permute 2 elements - not " + planElements.size()));
            return null;
        }
        Iterator iter = planElements.iterator();
        PlanElement x1 = (PlanElement)iter.next();
        PlanElement x2 = (PlanElement)iter.next();
        ArrayList<PlanElement> u1 = new ArrayList<PlanElement>();
        u1.add(x1);
        u1.add(x2);
        PlanGroup pg1 = PlanGroup.make(context, u1, false);
        ArrayList<PlanElement> u2 = new ArrayList<PlanElement>();
        u2.add(x2);
        u2.add(x1);
        PlanGroup pg2 = PlanGroup.make(context, u2, false);
        ArrayList<PlanGroup> u = new ArrayList<PlanGroup>();
        u.add(pg1);
        u.add(pg2);
        PlanElement pUnion = PlanUnion.make(context, u);
        return pUnion;
    }

    public void visit(PlanVisitor visitor) {
        visitor.visit(this);
    }

    public PlanElement apply(Transform transform) {
        return null;
    }

    public PlanElement copy() {
        return PlanOuterJoin.make(this.getContext(), this.planElements);
    }
}

