/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine2;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBasicGraphPattern;
import com.hp.hpl.jena.query.core.ElementFilter;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.ElementNamedGraph;
import com.hp.hpl.jena.query.core.ElementOptional;
import com.hp.hpl.jena.query.core.ElementUnion;
import com.hp.hpl.jena.query.engine2.op.Op;
import com.hp.hpl.jena.query.engine2.op.OpBGP;
import com.hp.hpl.jena.query.engine2.op.OpFilter;
import com.hp.hpl.jena.query.engine2.op.OpGraph;
import com.hp.hpl.jena.query.engine2.op.OpJoin;
import com.hp.hpl.jena.query.engine2.op.OpLeftJoin;
import com.hp.hpl.jena.query.engine2.op.OpTable;
import com.hp.hpl.jena.query.engine2.op.OpUnion;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.util.Context;
import com.hp.hpl.jena.query.util.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

public class AlgebraCompiler {
    protected Context context;

    public AlgebraCompiler(Context context) {
        this.context = context;
    }

    public static Op compile(Element elt, Context context) {
        return new AlgebraCompiler(context).compileFixedElement(elt);
    }

    protected Op compile(ElementBasicGraphPattern el) {
        OpBGP op = new OpBGP(el.getTriples(), el);
        return op;
    }

    protected Op compile(ElementUnion el) {
        if (el.getElements().size() == 1) {
            Element subElt = (Element)el.getElements().get(0);
            ElementGroup elg = (ElementGroup)subElt;
            return this.compile(elg);
        }
        Op current = null;
        ListIterator iter = el.getElements().listIterator();
        while (iter.hasNext()) {
            Element subElt = (Element)iter.next();
            ElementGroup elg = (ElementGroup)subElt;
            Op op = this.compile(elg);
            if (current == null) {
                current = op;
                continue;
            }
            current = new OpUnion(current, op);
        }
        return current;
    }

    protected Op compile(ElementGroup groupElt) {
        ArrayList<Expr> filters = new ArrayList<Expr>();
        Op current = OpTable.unit();
        Iterator iter = groupElt.getElements().listIterator();
        while (iter.hasNext()) {
            Element elt = (Element)iter.next();
            if (elt instanceof ElementFilter) {
                ElementFilter f = (ElementFilter)elt;
                filters.add(f.getExpr());
                continue;
            }
            if (elt instanceof ElementOptional) {
                ElementOptional eltOpt = (ElementOptional)elt;
                Element subElt = eltOpt.getOptionalElement();
                Op op = this.compileFixedElement(subElt);
                Expr expr = null;
                if (op instanceof OpFilter) {
                    OpFilter f = (OpFilter)op;
                    Op sub = f.getSubOp();
                    if (sub instanceof OpFilter) {
                        this.broken("compile/Optional/nested filters - unfinished");
                    }
                    expr = f.getExpr();
                    op = sub;
                }
                current = OpLeftJoin.create(current, op, expr);
                continue;
            }
            if (elt instanceof ElementGroup || elt instanceof ElementBasicGraphPattern || elt instanceof ElementNamedGraph || elt instanceof ElementUnion) {
                Op op = this.compileFixedElement(elt);
                current = OpJoin.create(current, op);
                continue;
            }
            this.broken("compile/group: not a fixed element, optional or filter: " + Utils.className(elt));
        }
        iter = filters.iterator();
        while (iter.hasNext()) {
            Expr expr = (Expr)iter.next();
            if (current == null) {
                current = OpTable.unit();
            }
            current = OpFilter.filter(expr, current);
        }
        return current;
    }

    protected Op compile(ElementNamedGraph eltGraph) {
        Node graphNode = eltGraph.getGraphNameNode();
        Op sub = this.compileFixedElement(eltGraph.getElement());
        return new OpGraph(graphNode, sub);
    }

    protected Op compileFixedElement(Element elt) {
        if (elt instanceof ElementBasicGraphPattern) {
            return this.compile((ElementBasicGraphPattern)elt);
        }
        if (elt instanceof ElementUnion) {
            return this.compile((ElementUnion)elt);
        }
        if (elt instanceof ElementGroup) {
            return this.compile((ElementGroup)elt);
        }
        if (elt instanceof ElementNamedGraph) {
            return this.compile((ElementNamedGraph)elt);
        }
        this.broken("compileFixedElement/Not a fixed element: " + Utils.className(elt));
        return null;
    }

    private void broken(String msg) {
        System.err.println("AlgebraCompiler: " + msg);
        throw new ARQInternalErrorException(msg);
    }
}

