/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine2;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.core.Var;
import com.hp.hpl.jena.query.engine.Binding;
import com.hp.hpl.jena.query.engine2.op.Op;
import com.hp.hpl.jena.query.engine2.op.OpFilter;
import com.hp.hpl.jena.query.engine2.op.OpQuadPattern;
import com.hp.hpl.jena.query.engine2.op.Quad;
import com.hp.hpl.jena.query.engine2.op.TransformCopy;
import com.hp.hpl.jena.query.engine2.op.Transformer;
import com.hp.hpl.jena.query.expr.Expr;
import java.util.ArrayList;
import java.util.Iterator;

public class OpSubstitute
extends TransformCopy {
    private Binding binding;

    public static Op substitute(Binding b, Op op) {
        return Transformer.transform(new OpSubstitute(b), op);
    }

    public OpSubstitute(Binding binding) {
        super(true);
        this.binding = binding;
    }

    public Op transform(OpQuadPattern quadPattern) {
        Node gNode = quadPattern.getGraphNode();
        Node g = OpSubstitute.substitute(this.binding, gNode);
        ArrayList<Triple> triples = new ArrayList<Triple>();
        Iterator iter = quadPattern.getQuads().iterator();
        while (iter.hasNext()) {
            Quad quad = (Quad)iter.next();
            if (!quad.getGraph().equals((Object)gNode)) {
                throw new ARQInternalErrorException("Internal error: quads block is not uniform over the graph node");
            }
            Node s = OpSubstitute.substitute(this.binding, quad.getSubject());
            Node p = OpSubstitute.substitute(this.binding, quad.getPredicate());
            Node o = OpSubstitute.substitute(this.binding, quad.getObject());
            Triple t = new Triple(s, p, o);
            triples.add(t);
        }
        return new OpQuadPattern(g, triples);
    }

    public Op transform(OpFilter filter, Op op) {
        Expr expr = filter.getExpr().copySubstitute(this.binding, true);
        return OpFilter.filter(expr, op);
    }

    private static Node substitute(Binding b, Node n) {
        if (!Var.isVar(n)) {
            return n;
        }
        Var v = Var.alloc(n);
        Node x = b.get(v);
        if (x == null) {
            return n;
        }
        return x;
    }
}

