/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine2;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.query.engine2.op.Op;
import com.hp.hpl.jena.query.engine2.op.OpBGP;
import com.hp.hpl.jena.query.engine2.op.OpDatasetNames;
import com.hp.hpl.jena.query.engine2.op.OpFilter;
import com.hp.hpl.jena.query.engine2.op.OpGraph;
import com.hp.hpl.jena.query.engine2.op.OpOrder;
import com.hp.hpl.jena.query.engine2.op.OpProject;
import com.hp.hpl.jena.query.engine2.op.OpQuadPattern;
import com.hp.hpl.jena.query.engine2.op.OpVisitorBase;
import com.hp.hpl.jena.query.engine2.op.OpWalker;
import com.hp.hpl.jena.query.engine2.op.Quad;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class OpVars {
    public static Set patternVars(Op op) {
        HashSet acc = new HashSet();
        OpWalker.walk(op, new OpVarsPattern(acc));
        return acc;
    }

    public static Set allVars(Op op) {
        HashSet acc = new HashSet();
        OpWalker.walk(op, new OpVarsPattern(acc));
        return acc;
    }

    private static void addVarsFromTriple(Set acc, Triple t) {
        OpVars.addVar(acc, t.getSubject());
        OpVars.addVar(acc, t.getPredicate());
        OpVars.addVar(acc, t.getObject());
    }

    private static void addVarsFromQuad(Set acc, Quad q) {
        OpVars.addVar(acc, q.getSubject());
        OpVars.addVar(acc, q.getPredicate());
        OpVars.addVar(acc, q.getObject());
        OpVars.addVar(acc, q.getGraph());
    }

    private static void addVar(Set acc, Node n) {
        if (n == null) {
            return;
        }
        if (n.isVariable()) {
            acc.add(n);
        }
    }

    private static class OpVarsQuery
    extends OpVarsPattern {
        OpVarsQuery(Set acc) {
            super(acc);
        }

        public void visit(OpFilter opFilter) {
            opFilter.getExpr().varsMentioned(this.acc);
        }

        public void visit(OpOrder opOrder) {
            Iterator iter = opOrder.getConditions().iterator();
            while (iter.hasNext()) {
                SortCondition sc = (SortCondition)iter.next();
                Set x = sc.getExpression().getVarsMentioned();
                this.acc.addAll(x);
            }
        }

        public void visit(OpProject opProject) {
            this.acc.addAll(opProject.getVars());
        }
    }

    private static class OpVarsPattern
    extends OpVisitorBase {
        protected Set acc;

        OpVarsPattern(Set acc) {
            this.acc = acc;
        }

        public void visit(OpBGP opBGP) {
            Iterator iter = opBGP.getPattern().iterator();
            while (iter.hasNext()) {
                Triple t = (Triple)iter.next();
                OpVars.addVarsFromTriple(this.acc, t);
            }
        }

        public void visit(OpQuadPattern quadPattern) {
            Iterator iter = quadPattern.getQuads().iterator();
            while (iter.hasNext()) {
                Quad quad = (Quad)iter.next();
                OpVars.addVarsFromQuad(this.acc, quad);
            }
        }

        public void visit(OpGraph opGraph) {
            OpVars.addVar(this.acc, opGraph.getNode());
        }

        public void visit(OpDatasetNames dsNames) {
            OpVars.addVar(this.acc, dsNames.getGraphNode());
        }
    }
}

