/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine2.op;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.core.Var;
import com.hp.hpl.jena.query.engine.Binding1;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.query.engine2.Evaluator;
import com.hp.hpl.jena.query.engine2.Table;
import com.hp.hpl.jena.query.engine2.TableFactory;
import com.hp.hpl.jena.query.engine2.op.Op;
import com.hp.hpl.jena.query.engine2.op.Op0;
import com.hp.hpl.jena.query.engine2.op.OpVisitor;
import com.hp.hpl.jena.query.engine2.op.Transform;
import com.hp.hpl.jena.query.engine2.table.TableEmpty;
import com.hp.hpl.jena.query.engine2.table.TableUnit;
import java.util.ArrayList;
import java.util.Iterator;

public class OpDatasetNames
extends Op0 {
    Node graphNode;

    public OpDatasetNames(Node gn) {
        this.graphNode = gn;
    }

    public Table eval(Evaluator evaluator) {
        if (this.graphNode.isURI()) {
            if (evaluator.getExecContext().getDataset().containsNamedGraph(this.graphNode.getURI())) {
                return new TableUnit();
            }
            return new TableEmpty();
        }
        if (!Var.isVar(this.graphNode)) {
            throw new ARQInternalErrorException("OpDatasetNames: Not a URI or variable: " + this.graphNode);
        }
        Iterator iter = evaluator.getExecContext().getDataset().listNames();
        ArrayList<Binding1> list2 = new ArrayList<Binding1>();
        while (iter.hasNext()) {
            String uri = (String)iter.next();
            Binding1 b = new Binding1(null, Var.alloc(this.graphNode), Node.createURI((String)uri));
            list2.add(b);
        }
        QueryIterPlainWrapper qIter = new QueryIterPlainWrapper(list2.iterator(), evaluator.getExecContext());
        return TableFactory.create(qIter);
    }

    public Node getGraphNode() {
        return this.graphNode;
    }

    public Op apply(Transform transform) {
        return transform.transform(this);
    }

    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    public Op copy() {
        return new OpDatasetNames(this.graphNode);
    }
}

