/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine2.op;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.query.core.ARQConstants;
import com.hp.hpl.jena.query.core.Var;
import com.hp.hpl.jena.query.engine2.Table;
import com.hp.hpl.jena.query.engine2.op.Op;
import com.hp.hpl.jena.query.engine2.op.Op1;
import com.hp.hpl.jena.query.engine2.op.Op2;
import com.hp.hpl.jena.query.engine2.op.OpBGP;
import com.hp.hpl.jena.query.engine2.op.OpDatasetNames;
import com.hp.hpl.jena.query.engine2.op.OpDistinct;
import com.hp.hpl.jena.query.engine2.op.OpExt;
import com.hp.hpl.jena.query.engine2.op.OpFilter;
import com.hp.hpl.jena.query.engine2.op.OpGraph;
import com.hp.hpl.jena.query.engine2.op.OpJoin;
import com.hp.hpl.jena.query.engine2.op.OpLeftJoin;
import com.hp.hpl.jena.query.engine2.op.OpOrder;
import com.hp.hpl.jena.query.engine2.op.OpPlanElement;
import com.hp.hpl.jena.query.engine2.op.OpProject;
import com.hp.hpl.jena.query.engine2.op.OpQuadPattern;
import com.hp.hpl.jena.query.engine2.op.OpSlice;
import com.hp.hpl.jena.query.engine2.op.OpTable;
import com.hp.hpl.jena.query.engine2.op.OpUnion;
import com.hp.hpl.jena.query.engine2.op.OpVisitor;
import com.hp.hpl.jena.query.engine2.op.Quad;
import com.hp.hpl.jena.query.engine2.table.TableUnit;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.ExprUtils;
import com.hp.hpl.jena.query.util.FmtUtils;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.query.util.PrintUtils;
import com.hp.hpl.jena.shared.PrefixMapping;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.ListIterator;

public class OpWriter {
    private static final int NL = 1;
    private static final int NoNL = -1;

    public static void out(OutputStream out, Op op, PrefixMapping pMap) {
        SerializationContext sCxt = new SerializationContext(pMap);
        OpWriter.out(new IndentedWriter(out), op, sCxt);
    }

    public static void out(OutputStream out, Op op, SerializationContext sCxt) {
        OpWriter.out(new IndentedWriter(out), op, sCxt);
    }

    public static void out(OutputStream out, Op op) {
        OpWriter.out(out, op, ARQConstants.getGlobalPrefixMap());
    }

    public static void out(IndentedWriter iWriter, Op op, PrefixMapping pMap) {
        SerializationContext sCxt = new SerializationContext(pMap);
        OpWriter.out(iWriter, op, sCxt);
    }

    public static void out(IndentedWriter iWriter, Op op, SerializationContext sCxt) {
        op.visit(new OpWriterWorker(iWriter, sCxt));
        iWriter.ensureStartOfLine();
        iWriter.flush();
    }

    public static void out(IndentedWriter iWriter, Op op) {
        OpWriter.out(iWriter, op, ARQConstants.getGlobalPrefixMap());
    }

    static class OpWriterWorker
    implements OpVisitor {
        private IndentedWriter out;
        private SerializationContext sContext;

        public OpWriterWorker(IndentedWriter out, SerializationContext sCxt) {
            this.sContext = sCxt;
            this.out = out;
        }

        private void visitOp2(Op2 op, Expr expr) {
            this.start(op, 1);
            this.printOp(op.getLeft());
            this.out.ensureStartOfLine();
            this.printOp(op.getRight());
            this.out.ensureStartOfLine();
            if (expr != null) {
                this.out.print("(expr ");
                ExprUtils.fmtSPARQL(this.out, expr);
                this.out.println(" )");
            }
            this.finish(op);
        }

        private void visitOp1(Op1 op) {
            this.start(op, 1);
            this.printOp(op.getSubOp());
            this.finish(op);
        }

        public void visit(OpQuadPattern opQuadP) {
            if (opQuadP.getQuads().size() == 1) {
                this.start(opQuadP, -1);
                this.out.print(" ");
                this.formatQuad((Quad)opQuadP.getQuads().get(0));
                this.finish(opQuadP);
                return;
            }
            this.start(opQuadP, 1);
            ListIterator iter = opQuadP.getQuads().listIterator();
            while (iter.hasNext()) {
                Quad quad = (Quad)iter.next();
                this.formatQuad(quad);
                this.out.println();
            }
            this.finish(opQuadP);
        }

        public void visit(OpBGP opBGP) {
            if (opBGP.getPattern().size() == 1) {
                this.start(opBGP, -1);
                this.out.print(" ");
                this.formatTriple((Triple)opBGP.getPattern().get(0));
                this.finish(opBGP);
                return;
            }
            this.start(opBGP, 1);
            ListIterator iter = opBGP.getPattern().listIterator();
            while (iter.hasNext()) {
                Triple t = (Triple)iter.next();
                this.formatTriple(t);
                this.out.println();
            }
            this.finish(opBGP);
        }

        public void visit(OpJoin opJoin) {
            this.visitOp2(opJoin, null);
        }

        public void visit(OpLeftJoin opLeftJoin) {
            this.visitOp2(opLeftJoin, opLeftJoin.getExpr());
        }

        public void visit(OpUnion opUnion) {
            this.visitOp2(opUnion, null);
        }

        public void visit(OpFilter opFilter) {
            this.start(opFilter, -1);
            this.out.print(" ");
            Expr expr = opFilter.getExpr();
            if (expr == null) {
                this.out.print("(null expr)");
            } else {
                ExprUtils.fmtSPARQL(this.out, expr, this.sContext.getPrefixMapping());
            }
            this.out.println();
            this.printOp(opFilter.getSubOp());
            this.finish(opFilter);
        }

        public void visit(OpGraph opGraph) {
            this.start(opGraph, -1);
            this.out.print(" ");
            this.out.println(FmtUtils.stringForNode(opGraph.getNode()));
            this.out.incIndent();
            opGraph.getSubOp().visit(this);
            this.finish(opGraph);
        }

        public void visit(OpTable opTable) {
            Table table = opTable.getTable();
            if (table instanceof TableUnit) {
                this.out.print("(unit table)");
                return;
            }
            if (table == null) {
                this.out.print("(null table)");
            } else {
                this.out.print("(table)");
            }
        }

        public void visit(OpPlanElement element) {
            this.start(element, 1);
            String x = element.getPlanElement().toString();
            if (x.endsWith("\n")) {
                x = x.substring(0, x.length() - 2);
            }
            this.out.print(x);
            this.finish(element);
        }

        public void visit(OpDatasetNames dsNames) {
            this.out.print("(TableDatasetNames");
            this.out.print(" ");
            this.out.print(this.slotToString(dsNames.getGraphNode()));
        }

        public void visit(OpExt opExt) {
            opExt.output(this.out, this.sContext);
        }

        public void visit(OpOrder opOrder) {
            this.start(opOrder, -1);
            if (opOrder.getConditions().size() > 0) {
                String sep = " ";
                Iterator iter = opOrder.getConditions().iterator();
                while (iter.hasNext()) {
                    SortCondition sc = (SortCondition)iter.next();
                    this.out.print(sep);
                    sc.output(this.out, this.sContext);
                }
            }
            this.out.println();
            this.printOp(opOrder.getSubOp());
            this.finish(opOrder);
        }

        public void visit(OpProject opProject) {
            this.start(opProject, -1);
            if (opProject.getVars().size() > 0) {
                this.out.print(" ");
                PrintUtils.Fmt fmt = new PrintUtils.Fmt(){

                    public String fmt(Object thing) {
                        return ((Var)((Object)thing)).toString();
                    }
                };
                PrintUtils.printList(this.out, opProject.getVars(), " ", fmt);
            }
            this.out.println();
            this.printOp(opProject.getSubOp());
            this.finish(opProject);
        }

        public void visit(OpDistinct opDistinct) {
            this.visitOp1(opDistinct);
        }

        public void visit(OpSlice opSlice) {
            this.start(opSlice, -1);
            this.out.print(" ");
            this.out.print(Long.toString(opSlice.getStart()));
            this.out.print(" ");
            this.out.print(Long.toString(opSlice.getLength()));
            this.out.println();
            this.printOp(opSlice.getSubOp());
            this.finish(opSlice);
        }

        private void start(Op op, int newline) {
            this.out.print("[");
            this.out.print(op.getName());
            if (newline == 1) {
                this.out.println();
            }
            this.out.incIndent();
        }

        private void finish(Op op) {
            this.out.decIndent();
            this.out.print("]");
        }

        private void printOp(Op op) {
            if (op == null) {
                this.out.print("(null)");
            } else {
                op.visit(this);
            }
        }

        private void formatTriple(Triple tp) {
            this.out.print(this.slotToString(tp.getSubject()));
            this.out.print(" ");
            this.out.print(this.slotToString(tp.getPredicate()));
            this.out.print(" ");
            this.out.print(this.slotToString(tp.getObject()));
        }

        private void formatQuad(Quad qp) {
            this.out.print(this.slotToString(qp.getGraph()));
            this.out.print(" ");
            this.out.print(this.slotToString(qp.getSubject()));
            this.out.print(" ");
            this.out.print(this.slotToString(qp.getPredicate()));
            this.out.print(" ");
            this.out.print(this.slotToString(qp.getObject()));
        }

        private String slotToString(Node n) {
            return FmtUtils.stringForNode(n, this.sContext);
        }
    }
}

