/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine2.table;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.core.Var;
import com.hp.hpl.jena.query.engine.Binding;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine.ResultSetStream;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.query.engine2.Table;
import com.hp.hpl.jena.query.util.PrintUtils;
import com.hp.hpl.jena.query.util.Utils;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class TableBase
implements Table {
    private boolean materialized = false;
    protected List rows = null;
    protected List vars = null;

    protected TableBase() {
    }

    public final void close() {
        this.closeTable();
        this.rows = null;
        this.vars = null;
    }

    protected abstract void closeTable();

    public void dump() {
        System.out.println("Table: " + Utils.className(this));
        this.materialize();
        if (this.rows.size() == 0) {
            if (this.vars.size() == 0) {
                System.out.println("++ Empty table, no variables");
            } else {
                System.out.print("++ Empty table, with variables:");
                PrintUtils.printList(System.out, this.vars);
                System.out.println();
            }
        } else {
            ResultSetFormatter.out(this.toResultSet());
        }
    }

    public final QueryIterator iterator(ExecutionContext execCxt) {
        if (!this.materialized) {
            return this.createIterator(execCxt);
        }
        return new QueryIterPlainWrapper(this.rows.iterator(), execCxt);
    }

    protected abstract QueryIterator createIterator(ExecutionContext var1);

    public void materialize() {
        if (this.rows != null) {
            return;
        }
        this.materialized = true;
        this.rows = new ArrayList();
        this.vars = new ArrayList();
        QueryIterator source = this.createIterator(null);
        while (source.hasNext()) {
            Binding b = source.nextBinding();
            Iterator names = b.vars();
            while (names.hasNext()) {
                Var v = (Var)((Object)names.next());
                if (this.vars.contains((Object)v)) continue;
                this.vars.add(v);
            }
            this.rows.add(b);
        }
        source.close();
    }

    private ResultSet toResultSet() {
        this.materialize();
        return new ResultSetStream(this.vars, ModelFactory.createDefaultModel(), this.iterator(null));
    }
}

