/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine2.table;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.core.Var;
import com.hp.hpl.jena.query.engine.Binding;
import com.hp.hpl.jena.query.engine.BindingMap;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterNullIterator;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.query.engine2.table.TableBase;
import com.hp.hpl.jena.query.expr.Expr;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.LogFactory;

public class TableSimple
extends TableBase {
    boolean iteratorReturned = false;
    private QueryIterator input;

    public TableSimple(QueryIterator qIter) {
        this.input = qIter;
    }

    public QueryIterator matchRightLeft(Binding bindingLeft, boolean includeOnNoMatch, Expr condition, ExecutionContext execContext) {
        this.materialize();
        ArrayList<Binding> out = new ArrayList<Binding>();
        Iterator iter = this.rows.iterator();
        while (iter.hasNext()) {
            Binding bindingRight = (Binding)iter.next();
            Binding r = TableSimple.merge(bindingLeft, bindingRight);
            if (r == null || condition != null && !condition.isSatisfied(r, execContext)) continue;
            out.add(r);
        }
        if (out.size() == 0 && includeOnNoMatch) {
            out.add(bindingLeft);
        }
        if (out.size() == 0) {
            return new QueryIterNullIterator(execContext);
        }
        return new QueryIterPlainWrapper(out.iterator(), execContext);
    }

    private static Binding merge(Binding bindingLeft, Binding bindingRight) {
        boolean matches2 = true;
        Iterator vIter = bindingLeft.vars();
        while (vIter.hasNext()) {
            Var v = (Var)((Object)vIter.next());
            Node nLeft = bindingLeft.get(v);
            Node nRight = bindingRight.get(v);
            if (nRight == null || nRight.equals((Object)nLeft)) continue;
            matches2 = false;
            break;
        }
        if (!matches2) {
            return null;
        }
        BindingMap b = new BindingMap(bindingLeft);
        Iterator vIter2 = bindingRight.vars();
        while (vIter2.hasNext()) {
            Var v = (Var)((Object)vIter2.next());
            Node n = bindingRight.get(v);
            if (bindingLeft.contains(v)) continue;
            b.add(v, n);
        }
        return b;
    }

    public QueryIterator createIterator(ExecutionContext execCxt) {
        if (this.iteratorReturned) {
            LogFactory.getLog((Class)TableSimple.class).fatal((Object)"Iterator already returned");
            return null;
        }
        this.iteratorReturned = true;
        return this.input;
    }

    public void closeTable() {
        if (this.input != null) {
            this.input.close();
        }
        this.input = null;
    }
}

