/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.query.core.Var;
import com.hp.hpl.jena.query.engine.Binding;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.ExprFunction;
import com.hp.hpl.jena.query.expr.ExprWalker;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.NodeVar;
import com.hp.hpl.jena.query.expr.VarsVisitor;
import com.hp.hpl.jena.query.expr.nodevalue.Functions;
import com.hp.hpl.jena.query.util.ExprUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public abstract class ExprNode
implements Expr {
    public boolean isSatisfied(Binding binding, ExecutionContext execCxt) {
        try {
            NodeValue v = this.eval(binding, execCxt);
            boolean b = Functions.booleanEffectiveValue(v);
            return b;
        }
        catch (ExprEvalException ex) {
            return false;
        }
    }

    public boolean isExpr() {
        return true;
    }

    public final Expr getExpr() {
        return this;
    }

    public abstract NodeValue eval(Binding var1, ExecutionContext var2);

    public Set getVarsMentioned() {
        HashSet acc = new HashSet();
        this.varsMentioned(acc);
        return acc;
    }

    public void varsMentioned(Collection acc) {
        VarsVisitor.Action action = new VarsVisitor.Action(){

            public void var(Collection acc, NodeVar nv) {
                acc.add(nv.asVar());
            }
        };
        VarsVisitor vv = new VarsVisitor(acc, action);
        ExprWalker.walk(vv, this);
    }

    public Set getVarNamesMentioned() {
        HashSet acc = new HashSet();
        this.varNamesMentioned(acc);
        return acc;
    }

    public void varNamesMentioned(Collection acc) {
        VarsVisitor.Action action = new VarsVisitor.Action(){

            public void var(Collection acc, NodeVar nv) {
                acc.add(nv.getVarName());
            }
        };
        VarsVisitor vv = new VarsVisitor(acc, action);
        ExprWalker.walk(vv, this);
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public final Expr copySubstitute(Binding binding) {
        return this.copySubstitute(binding, false);
    }

    public final Expr deepCopy() {
        return this.copySubstitute(null, false);
    }

    public abstract Expr copySubstitute(Binding var1, boolean var2);

    public boolean isVariable() {
        return false;
    }

    public String getVarName() {
        return null;
    }

    public NodeVar getNodeVar() {
        return null;
    }

    public Var asVar() {
        return null;
    }

    public boolean isConstant() {
        return false;
    }

    public NodeValue getConstant() {
        return null;
    }

    public boolean isFunction() {
        return false;
    }

    public ExprFunction getFunction() {
        return null;
    }

    public String toString() {
        return ExprUtils.fmtSPARQL(this);
    }
}

