/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.function;

import com.hp.hpl.jena.query.engine1.EngineConfig;
import com.hp.hpl.jena.query.function.Function;
import com.hp.hpl.jena.query.function.FunctionFactory;
import com.hp.hpl.jena.query.function.FunctionFactoryAuto;
import com.hp.hpl.jena.query.function.StandardFunctions;
import com.hp.hpl.jena.query.util.Loader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FunctionRegistry {
    static Log log = LogFactory.getLog((Class)FunctionRegistry.class);
    Map registry = new HashMap();
    Set attemptedLoads = new HashSet();

    public static synchronized FunctionRegistry standardRegistry() {
        FunctionRegistry reg = new FunctionRegistry();
        StandardFunctions.loadStdDefs(reg);
        return reg;
    }

    public static synchronized FunctionRegistry get() {
        FunctionRegistry reg = (FunctionRegistry)EngineConfig.getContext().get(EngineConfig.registryFunctions);
        if (reg == null) {
            reg = FunctionRegistry.standardRegistry();
            EngineConfig.getContext().set(EngineConfig.registryFunctions, reg);
        }
        return reg;
    }

    public void put(String uri, FunctionFactory f) {
        this.registry.put(uri, f);
    }

    public void put(String uri, Class funcClass) {
        if (!Function.class.isAssignableFrom(funcClass)) {
            log.warn((Object)("Class " + funcClass.getName() + " is not a Function"));
            return;
        }
        this.registry.put(uri, new FunctionFactoryAuto(funcClass));
    }

    public FunctionFactory get(String uri) {
        FunctionFactory function = (FunctionFactory)this.registry.get(uri);
        if (function != null) {
            return function;
        }
        if (!uri.startsWith("java:")) {
            return null;
        }
        if (this.attemptedLoads.contains(uri)) {
            return null;
        }
        Class functionClass = Loader.loadClass(uri, Function.class);
        this.put(uri, functionClass);
        this.attemptedLoads.add(uri);
        return (FunctionFactory)this.registry.get(uri);
    }

    public boolean isRegistered(String uri) {
        return this.registry.containsKey(uri);
    }

    public FunctionFactory remove(String uri) {
        return (FunctionFactory)this.registry.remove(uri);
    }

    public Iterator keys() {
        return this.registry.keySet().iterator();
    }
}

