/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.lang;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.query.core.ARQConstants;
import com.hp.hpl.jena.query.lang.Parser;
import com.hp.hpl.jena.query.lang.rdql.ParseException;
import com.hp.hpl.jena.query.lang.rdql.Q_Query;
import com.hp.hpl.jena.query.lang.rdql.RDQLParser;
import com.hp.hpl.jena.query.util.PrefixMapping2;
import com.hp.hpl.jena.query.util.RelURI;
import java.io.StringReader;

class ParserRDQL
extends Parser {
    ParserRDQL() {
    }

    public Query parse(Query q, String s) {
        q.setSyntax(Syntax.syntaxRDQL);
        PrefixMapping2 pm = new PrefixMapping2(ARQConstants.getGlobalPrefixMap(), q.getPrefixMapping());
        q.setPrefixMapping(pm);
        q.getPrefixMapping().setNsPrefixes(ARQConstants.getGlobalPrefixMap());
        Q_Query query = null;
        try {
            StringReader in = new StringReader(s);
            RDQLParser parser = new RDQLParser(in);
            parser.CompilationUnit();
            query = (Q_Query)parser.top();
            query.rdqlPhase2(q);
            if (q.getGraphURIs() != null) {
                for (int i = 0; i < q.getGraphURIs().size(); ++i) {
                    String u = (String)q.getGraphURIs().get(i);
                    u = RelURI.resolve(u, q.getBaseURI());
                    q.getGraphURIs().set(i, u);
                }
            }
            return q;
        }
        catch (QueryParseException qEx) {
            throw qEx;
        }
        catch (ParseException ex) {
            throw new QueryParseException("Parse error: " + ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (Error e2) {
            throw new QueryParseException("Parse error: " + e2.getMessage(), -1, -1);
        }
        catch (Throwable th) {
            throw new QueryException("Unexpected throwable: " + th.getMessage(), th);
        }
    }
}

