/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.lang;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.query.lang.Parser;
import com.hp.hpl.jena.query.lang.sparql.ParseException;
import com.hp.hpl.jena.query.lang.sparql.SPARQLParser;
import com.hp.hpl.jena.query.lang.sparql.TokenMgrError;
import com.hp.hpl.jena.shared.JenaException;
import java.io.StringReader;

class ParserSPARQL
extends Parser {
    ParserSPARQL() {
    }

    public Query parse(Query query, String queryString) {
        SPARQLParser parser = null;
        StringReader in = new StringReader(queryString);
        try {
            query.setStrict(true);
            parser = new SPARQLParser(in);
            parser.setQuery(query);
            parser.CompilationUnit();
            query.setSyntax(Syntax.syntaxSPARQL);
            this.validateParsedQuery(query);
            return query;
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (TokenMgrError tErr) {
            int col = parser.token.endColumn;
            int line = parser.token.endLine;
            throw new QueryParseException(tErr.getMessage(), line, col);
        }
        catch (QueryException ex) {
            throw ex;
        }
        catch (JenaException ex) {
            throw new QueryException(ex.getMessage(), ex);
        }
        catch (Error err) {
            throw new QueryParseException(err.getMessage(), err, -1, -1);
        }
        catch (Throwable th) {
            Parser.log.warn((Object)"Unexpected throwable: ", th);
            throw new QueryException(th.getMessage(), th);
        }
    }
}

