/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.lang.sparql;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBasicGraphPattern;
import com.hp.hpl.jena.query.core.ElementFilter;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.ElementNamedGraph;
import com.hp.hpl.jena.query.core.ElementOptional;
import com.hp.hpl.jena.query.core.ElementUnion;
import com.hp.hpl.jena.query.core.Template;
import com.hp.hpl.jena.query.core.TemplateGroup;
import com.hp.hpl.jena.query.core.TripleCollector;
import com.hp.hpl.jena.query.expr.E_Add;
import com.hp.hpl.jena.query.expr.E_Bound;
import com.hp.hpl.jena.query.expr.E_Datatype;
import com.hp.hpl.jena.query.expr.E_Divide;
import com.hp.hpl.jena.query.expr.E_Equals;
import com.hp.hpl.jena.query.expr.E_Function;
import com.hp.hpl.jena.query.expr.E_GreaterThan;
import com.hp.hpl.jena.query.expr.E_GreaterThanOrEqual;
import com.hp.hpl.jena.query.expr.E_IsBlank;
import com.hp.hpl.jena.query.expr.E_IsIRI;
import com.hp.hpl.jena.query.expr.E_IsLiteral;
import com.hp.hpl.jena.query.expr.E_IsURI;
import com.hp.hpl.jena.query.expr.E_Lang;
import com.hp.hpl.jena.query.expr.E_LangMatches;
import com.hp.hpl.jena.query.expr.E_LessThan;
import com.hp.hpl.jena.query.expr.E_LessThanOrEqual;
import com.hp.hpl.jena.query.expr.E_LogicalAnd;
import com.hp.hpl.jena.query.expr.E_LogicalNot;
import com.hp.hpl.jena.query.expr.E_LogicalOr;
import com.hp.hpl.jena.query.expr.E_Multiply;
import com.hp.hpl.jena.query.expr.E_NotEquals;
import com.hp.hpl.jena.query.expr.E_Regex;
import com.hp.hpl.jena.query.expr.E_SameTerm;
import com.hp.hpl.jena.query.expr.E_Str;
import com.hp.hpl.jena.query.expr.E_Subtract;
import com.hp.hpl.jena.query.expr.E_UnaryMinus;
import com.hp.hpl.jena.query.expr.E_UnaryPlus;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.NodeVar;
import com.hp.hpl.jena.query.lang.sparql.JavaCharStream;
import com.hp.hpl.jena.query.lang.sparql.ParseException;
import com.hp.hpl.jena.query.lang.sparql.SPARQLParserBase;
import com.hp.hpl.jena.query.lang.sparql.SPARQLParserConstants;
import com.hp.hpl.jena.query.lang.sparql.SPARQLParserTokenManager;
import com.hp.hpl.jena.query.lang.sparql.Token;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class SPARQLParser
extends SPARQLParserBase
implements SPARQLParserConstants {
    public SPARQLParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[72];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public final void CompilationUnit() throws ParseException {
        this.Query();
        this.jj_consume_token(0);
    }

    public final void Query() throws ParseException {
        this.Prolog();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                this.SelectQuery();
                break;
            }
            case 23: {
                this.ConstructQuery();
                break;
            }
            case 22: {
                this.DescribeQuery();
                break;
            }
            case 24: {
                this.AskQuery();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Prolog() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.BaseDecl();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block6;
                }
            }
            this.PrefixDecl();
        }
    }

    public final void BaseDecl() throws ParseException {
        this.jj_consume_token(18);
        Node n = this.Q_IRI_REF();
        this.getQuery().setBaseURI(n.getURI());
    }

    public final void PrefixDecl() throws ParseException {
        this.jj_consume_token(19);
        Token t = this.jj_consume_token(9);
        Node n = this.Q_IRI_REF();
        String s = this.fixupPrefix(t.image, t.beginLine, t.beginColumn);
        this.getQuery().setPrefix(s, n.getURI());
    }

    public final void SelectQuery() throws ParseException {
        Token t = null;
        this.jj_consume_token(20);
        this.getQuery().setQuerySelectType();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: {
                t = this.jj_consume_token(21);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        this.getQuery().setDistinct(t != null);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: 
            case 13: {
                block13: while (true) {
                    Node v = this.Var();
                    this.getQuery().addResultVar(v);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 12: 
                        case 13: {
                            continue block13;
                        }
                    }
                    break;
                }
                this.jj_la1[4] = this.jj_gen;
                this.getQuery().setQueryResultStar(false);
                break;
            }
            case 89: {
                this.jj_consume_token(89);
                this.getQuery().setQueryResultStar(true);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 32: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block14;
                }
            }
            this.DatasetClause();
        }
        this.WhereClause();
        this.SolutionModifier();
    }

    public final void ConstructQuery() throws ParseException {
        this.jj_consume_token(23);
        this.getQuery().setQueryConstructType();
        this.setInConstructTemplate(true);
        Template t = this.ConstructTemplate();
        this.setInConstructTemplate(false);
        this.getQuery().setQueryResultStar(false);
        this.getQuery().setConstructTemplate(t);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 32: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block3;
                }
            }
            this.DatasetClause();
        }
        this.WhereClause();
        this.SolutionModifier();
    }

    public final void DescribeQuery() throws ParseException {
        this.jj_consume_token(22);
        this.getQuery().setQueryDescribeType();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                block13: while (true) {
                    Node n = this.VarOrIRIref();
                    this.getQuery().addDescribeNode(n);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 13: {
                            continue block13;
                        }
                    }
                    break;
                }
                this.jj_la1[8] = this.jj_gen;
                this.getQuery().setQueryResultStar(false);
                break;
            }
            case 89: {
                this.jj_consume_token(89);
                this.getQuery().setQueryResultStar(true);
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 32: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block14;
                }
            }
            this.DatasetClause();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: 
            case 68: {
                this.WhereClause();
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        this.SolutionModifier();
    }

    public final void AskQuery() throws ParseException {
        this.jj_consume_token(24);
        this.getQuery().setQueryAskType();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 32: {
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    break block3;
                }
            }
            this.DatasetClause();
        }
        this.WhereClause();
    }

    public final void DatasetClause() throws ParseException {
        this.jj_consume_token(32);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: {
                this.DefaultGraphClause();
                break;
            }
            case 31: {
                this.NamedGraphClause();
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void DefaultGraphClause() throws ParseException {
        Node n = this.SourceSelector();
        this.getQuery().addGraphURI(n.getURI());
    }

    public final void NamedGraphClause() throws ParseException {
        this.jj_consume_token(31);
        Node n = this.SourceSelector();
        this.getQuery().addNamedGraphURI(n.getURI());
    }

    public final Node SourceSelector() throws ParseException {
        Node n = this.IRIref();
        if (!n.isURI()) {
            throw new QueryParseException("Not an URI: " + n.toString(), this.token.beginLine, this.token.beginColumn);
        }
        return n;
    }

    public final void WhereClause() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: {
                this.jj_consume_token(33);
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
        Element el = this.GroupGraphPattern();
        this.getQuery().setQueryPattern(el);
    }

    public final void SolutionModifier() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                this.OrderClause();
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 25: 
            case 26: {
                this.LimitOffsetClauses();
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
            }
        }
    }

    public final void LimitOffsetClauses() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 25: {
                this.LimitClause();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 26: {
                        this.OffsetClause();
                        break block0;
                    }
                }
                this.jj_la1[17] = this.jj_gen;
                break;
            }
            case 26: {
                this.OffsetClause();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 25: {
                        this.LimitClause();
                        break block0;
                    }
                }
                this.jj_la1[18] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void OrderClause() throws ParseException {
        this.jj_consume_token(27);
        this.jj_consume_token(28);
        block3: while (true) {
            this.OrderCondition();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 29: 
                case 30: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 65: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[20] = this.jj_gen;
    }

    public final void OrderCondition() throws ParseException {
        int direction = 0;
        Expr expr = null;
        Node v = null;
        direction = Query.ORDER_DEFAULT;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: 
            case 30: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 29: {
                        this.jj_consume_token(29);
                        direction = Query.ORDER_ASCENDING;
                        break;
                    }
                    case 30: {
                        this.jj_consume_token(30);
                        direction = Query.ORDER_DESCENDING;
                        break;
                    }
                    default: {
                        this.jj_la1[21] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                expr = this.BrackettedExpression();
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 65: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: 
                    case 9: 
                    case 10: {
                        expr = this.FunctionCall();
                        break block0;
                    }
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: {
                        expr = this.BuiltInCall();
                        break block0;
                    }
                    case 12: 
                    case 13: {
                        v = this.Var();
                        break block0;
                    }
                    case 65: {
                        expr = this.BrackettedExpression();
                        break block0;
                    }
                }
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (v == null) {
            this.getQuery().addOrderBy(expr, direction);
        } else {
            this.getQuery().addOrderBy(v, direction);
        }
    }

    public final void LimitClause() throws ParseException {
        this.jj_consume_token(25);
        Token t = this.jj_consume_token(53);
        this.getQuery().setLimit(this.integerValue(t.image));
    }

    public final void OffsetClause() throws ParseException {
        this.jj_consume_token(26);
        Token t = this.jj_consume_token(53);
        this.getQuery().setOffset(this.integerValue(t.image));
    }

    public final Element GroupGraphPattern() throws ParseException {
        ElementGroup elg = new ElementGroup();
        this.jj_consume_token(68);
        this.startGroup(elg);
        this.GraphPatternElement(elg);
        this.endGroup(elg);
        this.jj_consume_token(69);
        return elg;
    }

    public final void GraphPatternElement(ElementGroup elg) throws ParseException {
        Element el = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 67: 
            case 70: 
            case 72: 
            case 87: 
            case 88: {
                el = this.BasicGraphPattern(null);
                elg.addElement(el);
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 68: {
                el = this.GraphPatternNotTriples();
                elg.addElement(el);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 75: {
                        this.jj_consume_token(75);
                        break;
                    }
                    default: {
                        this.jj_la1[25] = this.jj_gen;
                    }
                }
                this.GraphPatternElement(elg);
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
            }
        }
    }

    public final Element BasicGraphPattern(ElementBasicGraphPattern acc) throws ParseException {
        if (acc == null) {
            acc = new ElementBasicGraphPattern();
        }
        this.TriplesSameSubject(acc);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 75: {
                this.jj_consume_token(75);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 65: 
                    case 67: 
                    case 70: 
                    case 72: 
                    case 87: 
                    case 88: {
                        this.BasicGraphPattern(acc);
                        break block0;
                    }
                }
                this.jj_la1[27] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
            }
        }
        return acc;
    }

    public final Element GraphPatternNotTriples() throws ParseException {
        Element el = null;
        Expr c = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: {
                el = this.OptionalGraphPattern();
                return el;
            }
            case 68: {
                el = this.GroupOrUnionGraphPattern();
                return el;
            }
            case 35: {
                el = this.GraphGraphPattern();
                return el;
            }
            case 39: {
                c = this.Constraint();
                return new ElementFilter(c);
            }
            case 37: {
                el = this.ImpreciseGraphPattern();
                return el;
            }
        }
        this.jj_la1[29] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Element ImpreciseGraphPattern() throws ParseException {
        this.jj_consume_token(37);
        Element el = this.GroupGraphPattern();
        return el;
    }

    public final Element OptionalGraphPattern() throws ParseException {
        this.jj_consume_token(36);
        Element el = this.GroupGraphPattern();
        return new ElementOptional(null, el);
    }

    public final Element GraphGraphPattern() throws ParseException {
        this.jj_consume_token(35);
        Node n = this.VarOrIRIref();
        Element el = this.GroupGraphPattern();
        return new ElementNamedGraph(n, el);
    }

    public final Element GroupOrUnionGraphPattern() throws ParseException {
        Element el = null;
        ElementUnion el2 = null;
        el = this.GroupGraphPattern();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 38: {
                    break;
                }
                default: {
                    this.jj_la1[30] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(38);
            if (el2 == null) {
                el2 = new ElementUnion();
                el2.addElement(el);
            }
            el = this.GroupGraphPattern();
            el2.addElement(el);
        }
        return el2 == null ? el : el2;
    }

    public final Expr Constraint() throws ParseException {
        Expr c;
        this.jj_consume_token(39);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 65: {
                c = this.BrackettedExpression();
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                c = this.BuiltInCall();
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                c = this.FunctionCall();
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return c;
    }

    public final Expr FunctionCall() throws ParseException {
        Node fname = this.IRIref();
        List a = this.ArgList();
        return new E_Function(fname.getURI(), a);
    }

    public final List ArgList() throws ParseException {
        ArrayList<Expr> args = new ArrayList<Expr>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: {
                this.jj_consume_token(67);
                break;
            }
            case 65: {
                this.jj_consume_token(65);
                Expr expr = this.Expression();
                args.add(expr);
                block7: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 74: {
                            break;
                        }
                        default: {
                            this.jj_la1[32] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(74);
                    expr = this.Expression();
                    args.add(expr);
                }
                this.jj_consume_token(66);
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return args;
    }

    public final Template ConstructTemplate() throws ParseException {
        TemplateGroup g = new TemplateGroup();
        this.jj_consume_token(68);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 67: 
            case 70: 
            case 72: 
            case 87: 
            case 88: {
                this.ConstructTriples(g);
                break;
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
            }
        }
        this.jj_consume_token(69);
        return g;
    }

    public final void ConstructTriples(TemplateGroup acc) throws ParseException {
        this.TriplesSameSubject(acc);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 75: {
                this.jj_consume_token(75);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 65: 
                    case 67: 
                    case 70: 
                    case 72: 
                    case 87: 
                    case 88: {
                        this.ConstructTriples(acc);
                        break block0;
                    }
                }
                this.jj_la1[35] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
            }
        }
    }

    public final void TriplesSameSubject(TripleCollector acc) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 67: 
            case 72: 
            case 87: 
            case 88: {
                Node s = this.VarOrTerm();
                this.PropertyListNotEmpty(s, acc);
                break;
            }
            case 65: 
            case 70: {
                Node s = this.TriplesNode(acc);
                this.PropertyList(s, acc);
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void PropertyList(Node s, TripleCollector acc) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: {
                this.PropertyListNotEmpty(s, acc);
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
            }
        }
    }

    public final void PropertyListNotEmpty(Node s, TripleCollector acc) throws ParseException {
        Node p = this.Verb();
        this.ObjectList(s, p, acc);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 73: {
                this.jj_consume_token(73);
                this.PropertyList(s, acc);
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
            }
        }
    }

    public final void ObjectList(Node s, Node p, TripleCollector acc) throws ParseException {
        int mark = acc.mark();
        Node o = this.GraphNode(acc);
        this.insert(acc, mark, s, p, o);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 74: {
                this.jj_consume_token(74);
                this.ObjectList(s, p, acc);
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
            }
        }
    }

    public final Node Verb() throws ParseException {
        Node p;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                p = this.VarOrIRIref();
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                p = this.nRDFtype;
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return p;
    }

    public final Node TriplesNode(TripleCollector acc) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 65: {
                Node n = this.Collection(acc);
                return n;
            }
            case 70: {
                Node n = this.BlankNodePropertyList(acc);
                return n;
            }
        }
        this.jj_la1[42] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node BlankNodePropertyList(TripleCollector acc) throws ParseException {
        this.jj_consume_token(70);
        Node n = this.createBNode();
        this.PropertyListNotEmpty(n, acc);
        this.jj_consume_token(71);
        return n;
    }

    public final Node Collection(TripleCollector acc) throws ParseException {
        Node listHead = this.nRDFnil;
        Node lastCell = null;
        this.jj_consume_token(65);
        block3: while (true) {
            Node cell = this.createListNode();
            if (listHead == this.nRDFnil) {
                listHead = cell;
            }
            if (lastCell != null) {
                this.insert(acc, lastCell, this.nRDFrest, cell);
            }
            int mark = acc.mark();
            Node n = this.GraphNode(acc);
            this.insert(acc, mark, cell, this.nRDFfirst, n);
            lastCell = cell;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 65: 
                case 67: 
                case 70: 
                case 72: 
                case 87: 
                case 88: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[43] = this.jj_gen;
        this.jj_consume_token(66);
        if (lastCell != null) {
            this.insert(acc, lastCell, this.nRDFrest, this.nRDFnil);
        }
        return listHead;
    }

    public final Node GraphNode(TripleCollector acc) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 67: 
            case 72: 
            case 87: 
            case 88: {
                Node n = this.VarOrTerm();
                return n;
            }
            case 65: 
            case 70: {
                Node n = this.TriplesNode(acc);
                return n;
            }
        }
        this.jj_la1[44] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node VarOrTerm() throws ParseException {
        Node n = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: 
            case 13: {
                n = this.Var();
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 67: 
            case 72: 
            case 87: 
            case 88: {
                n = this.GraphTerm();
                break;
            }
            default: {
                this.jj_la1[45] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return n;
    }

    public final Node VarOrIRIref() throws ParseException {
        Node n = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: 
            case 13: {
                n = this.Var();
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                n = this.IRIref();
                break;
            }
            default: {
                this.jj_la1[46] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return n;
    }

    public final Node Var() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                t = this.jj_consume_token(12);
                break;
            }
            case 13: {
                t = this.jj_consume_token(13);
                break;
            }
            default: {
                this.jj_la1[47] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.createVariable(t.image, t.beginLine, t.beginColumn);
    }

    public final Node GraphTerm() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: {
                Node n = this.IRIref();
                return n;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                Node n = this.RDFLiteral();
                return n;
            }
            case 53: 
            case 54: 
            case 55: 
            case 87: 
            case 88: {
                boolean positive = true;
                block8 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 87: 
                    case 88: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 88: {
                                this.jj_consume_token(88);
                                positive = false;
                                break block8;
                            }
                            case 87: {
                                this.jj_consume_token(87);
                                break block8;
                            }
                        }
                        this.jj_la1[48] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[49] = this.jj_gen;
                    }
                }
                Node n = this.NumericLiteral(positive);
                return n;
            }
            case 51: 
            case 52: {
                Node n = this.BooleanLiteral();
                return n;
            }
            case 11: 
            case 72: {
                Node n = this.BlankNode();
                return n;
            }
            case 67: {
                this.jj_consume_token(67);
                return this.nRDFnil;
            }
        }
        this.jj_la1[50] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Expr Expression() throws ParseException {
        Expr n = this.ConditionalOrExpression();
        return n;
    }

    public final Expr ConditionalOrExpression() throws ParseException {
        Expr n1 = this.ConditionalAndExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 85: {
                    break;
                }
                default: {
                    this.jj_la1[51] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(85);
            Expr n2 = this.ConditionalAndExpression();
            n1 = new E_LogicalOr(n1, n2);
        }
        return n1;
    }

    public final Expr ConditionalAndExpression() throws ParseException {
        Expr n1 = this.ValueLogical();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 86: {
                    break;
                }
                default: {
                    this.jj_la1[52] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(86);
            Expr n2 = this.ValueLogical();
            n1 = new E_LogicalAnd(n1, n2);
        }
        return n1;
    }

    public final Expr ValueLogical() throws ParseException {
        Expr n = this.RelationalExpression();
        return n;
    }

    public final Expr RelationalExpression() throws ParseException {
        Expr n1 = this.NumericExpression();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 76: {
                        this.jj_consume_token(76);
                        Expr n2 = this.NumericExpression();
                        n1 = new E_Equals(n1, n2);
                        break block0;
                    }
                    case 77: {
                        this.jj_consume_token(77);
                        Expr n2 = this.NumericExpression();
                        n1 = new E_NotEquals(n1, n2);
                        break block0;
                    }
                    case 79: {
                        this.jj_consume_token(79);
                        Expr n2 = this.NumericExpression();
                        n1 = new E_LessThan(n1, n2);
                        break block0;
                    }
                    case 78: {
                        this.jj_consume_token(78);
                        Expr n2 = this.NumericExpression();
                        n1 = new E_GreaterThan(n1, n2);
                        break block0;
                    }
                    case 80: {
                        this.jj_consume_token(80);
                        Expr n2 = this.NumericExpression();
                        n1 = new E_LessThanOrEqual(n1, n2);
                        break block0;
                    }
                    case 81: {
                        this.jj_consume_token(81);
                        Expr n2 = this.NumericExpression();
                        n1 = new E_GreaterThanOrEqual(n1, n2);
                        break block0;
                    }
                }
                this.jj_la1[53] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
            }
        }
        return n1;
    }

    public final Expr NumericExpression() throws ParseException {
        Expr n = this.AdditiveExpression();
        return n;
    }

    public final Expr AdditiveExpression() throws ParseException {
        Expr n1;
        block8: {
            n1 = this.MultiplicativeExpression();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 87: 
                    case 88: {
                        break;
                    }
                    default: {
                        this.jj_la1[55] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 87: {
                        this.jj_consume_token(87);
                        Expr n2 = this.MultiplicativeExpression();
                        n1 = new E_Add(n1, n2);
                        continue block7;
                    }
                    case 88: {
                        this.jj_consume_token(88);
                        Expr n2 = this.MultiplicativeExpression();
                        n1 = new E_Subtract(n1, n2);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[56] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return n1;
    }

    public final Expr MultiplicativeExpression() throws ParseException {
        Expr n1;
        block8: {
            n1 = this.UnaryExpression();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 89: 
                    case 90: {
                        break;
                    }
                    default: {
                        this.jj_la1[57] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 89: {
                        this.jj_consume_token(89);
                        Expr n2 = this.UnaryExpression();
                        n1 = new E_Multiply(n1, n2);
                        continue block7;
                    }
                    case 90: {
                        this.jj_consume_token(90);
                        Expr n2 = this.UnaryExpression();
                        n1 = new E_Divide(n1, n2);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[58] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return n1;
    }

    public final Expr UnaryExpression() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 82: {
                this.jj_consume_token(82);
                Expr n = this.PrimaryExpression();
                return new E_LogicalNot(n);
            }
            case 87: {
                this.jj_consume_token(87);
                Expr n = this.PrimaryExpression();
                return new E_UnaryPlus(n);
            }
            case 88: {
                this.jj_consume_token(88);
                Expr n = this.PrimaryExpression();
                return new E_UnaryMinus(n);
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: {
                Expr n = this.PrimaryExpression();
                return n;
            }
        }
        this.jj_la1[59] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Expr PrimaryExpression() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 65: {
                Expr expr = this.BrackettedExpression();
                return expr;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                Expr expr = this.BuiltInCall();
                return expr;
            }
            case 8: 
            case 9: 
            case 10: {
                Expr expr = this.IRIrefOrFunction();
                return expr;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                Node gn = this.RDFLiteral();
                return this.asExpr(gn);
            }
            case 53: 
            case 54: 
            case 55: {
                Node gn = this.NumericLiteral(true);
                return this.asExpr(gn);
            }
            case 51: 
            case 52: {
                Node gn = this.BooleanLiteral();
                return this.asExpr(gn);
            }
            case 12: 
            case 13: {
                Node gn = this.Var();
                return this.asExpr(gn);
            }
        }
        this.jj_la1[60] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Expr BrackettedExpression() throws ParseException {
        this.jj_consume_token(65);
        Expr expr = this.Expression();
        this.jj_consume_token(66);
        return expr;
    }

    public final Expr BuiltInCall() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 41: {
                this.jj_consume_token(41);
                this.jj_consume_token(65);
                Expr expr = this.Expression();
                this.jj_consume_token(66);
                return new E_Str(expr);
            }
            case 43: {
                this.jj_consume_token(43);
                this.jj_consume_token(65);
                Expr expr = this.Expression();
                this.jj_consume_token(66);
                return new E_Lang(expr);
            }
            case 44: {
                this.jj_consume_token(44);
                this.jj_consume_token(65);
                Expr expr1 = this.Expression();
                this.jj_consume_token(74);
                Expr expr2 = this.Expression();
                this.jj_consume_token(66);
                return new E_LangMatches(expr1, expr2);
            }
            case 42: {
                this.jj_consume_token(42);
                this.jj_consume_token(65);
                Expr expr = this.Expression();
                this.jj_consume_token(66);
                return new E_Datatype(expr);
            }
            case 40: {
                this.jj_consume_token(40);
                this.jj_consume_token(65);
                Node gn = this.Var();
                this.jj_consume_token(66);
                return new E_Bound(new NodeVar(gn));
            }
            case 50: {
                this.jj_consume_token(50);
                this.jj_consume_token(65);
                Expr expr1 = this.Expression();
                this.jj_consume_token(74);
                Expr expr2 = this.Expression();
                this.jj_consume_token(66);
                return new E_SameTerm(expr1, expr2);
            }
            case 46: {
                Token t = this.jj_consume_token(46);
                this.jj_consume_token(65);
                Expr expr = this.Expression();
                this.jj_consume_token(66);
                return new E_IsIRI(expr);
            }
            case 45: {
                Token t = this.jj_consume_token(45);
                this.jj_consume_token(65);
                Expr expr = this.Expression();
                this.jj_consume_token(66);
                return new E_IsURI(expr);
            }
            case 47: {
                this.jj_consume_token(47);
                this.jj_consume_token(65);
                Expr expr = this.Expression();
                this.jj_consume_token(66);
                return new E_IsBlank(expr);
            }
            case 48: {
                this.jj_consume_token(48);
                this.jj_consume_token(65);
                Expr expr = this.Expression();
                this.jj_consume_token(66);
                return new E_IsLiteral(expr);
            }
            case 49: {
                Expr expr = this.RegexExpression();
                return expr;
            }
        }
        this.jj_la1[61] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Expr RegexExpression() throws ParseException {
        Expr patExpr = null;
        Expr flagsExpr = null;
        this.jj_consume_token(49);
        this.jj_consume_token(65);
        Expr expr = this.Expression();
        this.jj_consume_token(74);
        patExpr = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 74: {
                this.jj_consume_token(74);
                flagsExpr = this.Expression();
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
            }
        }
        this.jj_consume_token(66);
        return new E_Regex(expr, patExpr, flagsExpr);
    }

    public final Expr IRIrefOrFunction() throws ParseException {
        List a = null;
        Node gn = this.IRIref();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 65: 
            case 67: {
                a = this.ArgList();
                break;
            }
            default: {
                this.jj_la1[63] = this.jj_gen;
            }
        }
        if (a == null) {
            return this.asExpr(gn);
        }
        return new E_Function(gn.getURI(), a);
    }

    public final Node RDFLiteral() throws ParseException {
        String lex = null;
        lex = this.String();
        String lang = null;
        Node uri = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 91: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: {
                        Token t = this.jj_consume_token(14);
                        lang = this.stripChars(t.image, 1);
                        break block0;
                    }
                    case 91: {
                        this.jj_consume_token(91);
                        uri = this.IRIref();
                        break block0;
                    }
                }
                this.jj_la1[64] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[65] = this.jj_gen;
            }
        }
        return this.makeNode(lex, lang, uri);
    }

    public final Node NumericLiteral(boolean positive) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 53: {
                Token t = this.jj_consume_token(53);
                return this.makeNodeInteger(positive, t.image);
            }
            case 54: {
                Token t = this.jj_consume_token(54);
                return this.makeNodeDecimal(positive, t.image);
            }
            case 55: {
                Token t = this.jj_consume_token(55);
                return this.makeNodeDouble(positive, t.image);
            }
        }
        this.jj_la1[66] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node BooleanLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 51: {
                this.jj_consume_token(51);
                return this.XSD_TRUE;
            }
            case 52: {
                this.jj_consume_token(52);
                return this.XSD_FALSE;
            }
        }
        this.jj_la1[67] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String String() throws ParseException {
        String lex;
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 60: {
                t = this.jj_consume_token(60);
                lex = this.stripQuotes(t.image);
                break;
            }
            case 61: {
                t = this.jj_consume_token(61);
                lex = this.stripQuotes(t.image);
                break;
            }
            case 62: {
                t = this.jj_consume_token(62);
                lex = this.stripQuotes3(t.image);
                break;
            }
            case 63: {
                t = this.jj_consume_token(63);
                lex = this.stripQuotes3(t.image);
                break;
            }
            default: {
                this.jj_la1[68] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        lex = this.unescapeStr(lex, t.beginLine, t.beginColumn);
        return lex;
    }

    public final Node IRIref() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                Node n = this.Q_IRI_REF();
                return n;
            }
            case 9: 
            case 10: {
                Node n = this.QName();
                return n;
            }
        }
        this.jj_la1[69] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node QName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                Token t = this.jj_consume_token(10);
                return this.createNodeFromPrefixedName(t.image, t.beginLine, t.beginColumn);
            }
            case 9: {
                Token t = this.jj_consume_token(9);
                return this.createNodeFromPrefixedName(t.image, t.beginLine, t.beginColumn);
            }
        }
        this.jj_la1[70] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node BlankNode() throws ParseException {
        Token t = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                t = this.jj_consume_token(11);
                return this.createBNode(t.image, t.beginLine, t.beginColumn);
            }
            case 72: {
                this.jj_consume_token(72);
                return this.createBNode();
            }
        }
        this.jj_la1[71] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node Q_IRI_REF() throws ParseException {
        Token t = this.jj_consume_token(8);
        return this.createNodeFromURI(t.image, t.beginLine, t.beginColumn);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{0x1D00000, 262144, 524288, 0x200000, 12288, 12288, 0, 0, 14080, 14080, 0, 0, 0, -2147481856, 0, 0x8000000, 0x6000000, 0x4000000, 0x2000000, 0x6000000, 1610626816, 0x60000000, 14080, 1610626816, 16128, 0, 0, 16128, 0, 0, 0, 1792, 0, 0, 16128, 16128, 0, 16128, 145152, 0, 0, 145152, 0, 16128, 16128, 16128, 14080, 12288, 0, 0, 3840, 0, 0, 0, 0, 0, 0, 0, 0, 14080, 14080, 0, 0, 0, 16384, 16384, 0, 0, 0, 1792, 1536, 2048};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 2, 1, 0, 2, 0, 0, 0, 0, 0, 524032, 0, 524032, 524032, -252182528, 0, 184, -252182528, 0, 184, 64, 524032, 0, 0, -252182528, -252182528, 0, -252182528, 0, 0, 0, 0, 0, -252182528, -252182528, -252182528, 0, 0, 0, 0, -252182528, 0, 0, 0, 0, 0, 0, 0, 0, -251658496, -251658496, 524032, 0, 0, 0, 0, 0xE00000, 0x180000, -268435456, 0, 0, 0};
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0x2000000, 0, 0, 0, 0x2000000, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 2, 25166154, 2048, 16, 25166154, 2048, 16, 0, 2, 1024, 10, 25166154, 25166154, 2048, 25166154, 0, 512, 1024, 0, 66, 25166154, 25166154, 0x1800108, 0, 0, 0x1800000, 0x1800000, 0x1800108, 0x200000, 0x400000, 258048, 258048, 0x1800000, 0x1800000, 0x6000000, 0x6000000, 25427970, 2, 0, 1024, 10, 0x8000000, 0x8000000, 0, 0, 0, 0, 0, 256};
    }

    private static void jj_la1_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public SPARQLParser(InputStream stream) {
        this(stream, null);
    }

    public SPARQLParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
        this.token_source = new SPARQLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 72; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 72; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public SPARQLParser(Reader stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new SPARQLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 72; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 72; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public SPARQLParser(SPARQLParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 72; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(SPARQLParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 72; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[100];
        for (i = 0; i < 100; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 72; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 100; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        SPARQLParser.jj_la1_0();
        SPARQLParser.jj_la1_1();
        SPARQLParser.jj_la1_2();
        SPARQLParser.jj_la1_3();
    }
}

