/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.pfunction;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.extension.Extension;
import com.hp.hpl.jena.query.extension.ExtensionRegistry;
import com.hp.hpl.jena.query.extension.library.container;
import com.hp.hpl.jena.query.pfunction.PropFuncArg;
import com.hp.hpl.jena.query.pfunction.PropertyFunction;
import com.hp.hpl.jena.query.util.ExprUtils;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropFuncAdapter
implements PropertyFunction {
    private Log log = LogFactory.getLog((Class)PropFuncAdapter.class);
    Extension ext = null;
    List args;

    public static boolean isMagicProperty(Triple t) {
        return ExtensionRegistry.get().isRegistered(t.getPredicate().getURI());
    }

    public PropFuncAdapter(Extension ext) {
        this.ext = ext;
        this.log.info((Object)("Property function adapter for " + ext.getClass().getName()));
    }

    public void build(PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        this.args = this.pfArgs(argSubject, argObject);
        this.ext.build(predicate.getURI(), this.args);
    }

    public QueryIterator exec(QueryIterator input, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        return this.ext.exec(input, this.args, predicate.getURI(), execCxt);
    }

    private List pfArgs(PropFuncArg argSubject, PropFuncArg argObject) {
        ArrayList<Expr> args = new ArrayList<Expr>();
        Expr sExpr = ExprUtils.nodeToExpr(argSubject.getArg());
        Expr oExpr = ExprUtils.nodeToExpr(argObject.getArg());
        args.add(sExpr);
        args.add(oExpr);
        return args;
    }

    static {
        ExtensionRegistry.get().put(RDFS.member.getURI(), container.class);
    }
}

