/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.resultset;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.resultset.ResultSetMem;
import com.hp.hpl.jena.query.vocabulary.ResultSetGraphVocab;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PropertyNotFoundException;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RDFInput
extends ResultSetMem {
    private static Log log = LogFactory.getLog((Class)RDFInput.class);

    public RDFInput(Model model) {
        this.buildFromDumpFormat(model);
    }

    private void buildFromDumpFormat(Model resultsModel) {
        this.varNames = new ArrayList();
        StmtIterator sIter = resultsModel.listStatements(null, RDF.type, (RDFNode)ResultSetGraphVocab.ResultSet);
        while (sIter.hasNext()) {
            Statement s = sIter.nextStatement();
            Resource root = s.getSubject();
            this.buildOneResource(root);
        }
        sIter.close();
        this.reset();
    }

    private void buildOneResource(Resource root) {
        this.buildVariables(root);
        int count = this.buildPreprocess(root);
        if (this.ordered) {
            this.buildRowsOrdered(root, count);
        } else {
            this.buildRows(root);
        }
    }

    private void buildVariables(Resource root) {
        StmtIterator rVarsIter = root.listProperties(ResultSetGraphVocab.resultVariable);
        while (rVarsIter.hasNext()) {
            String varName = rVarsIter.nextStatement().getString();
            this.varNames.add(varName);
        }
        rVarsIter.close();
    }

    private int buildPreprocess(Resource root) {
        StmtIterator solnIter = root.listProperties(ResultSetGraphVocab.solution);
        int rows = 0;
        int indexed = 0;
        while (solnIter.hasNext()) {
            Resource soln = solnIter.nextStatement().getResource();
            ++rows;
            if (!soln.hasProperty(ResultSetGraphVocab.index)) continue;
            ++indexed;
        }
        solnIter.close();
        if (indexed > 0 && rows != indexed) {
            log.warn((Object)("Rows = " + rows + " but only " + indexed + " indexes"));
            return rows;
        }
        if (indexed > 0) {
            this.ordered = true;
        }
        return rows;
    }

    private void buildRowsOrdered(Resource root, int count) {
        Literal ind;
        StmtIterator sIter;
        Model m = root.getModel();
        int index = 1;
        while ((sIter = m.listStatements(null, ResultSetGraphVocab.index, (RDFNode)(ind = m.createTypedLiteral(index)))).hasNext()) {
            Statement s = sIter.nextStatement();
            if (sIter.hasNext()) {
                log.warn((Object)("More than one solution: index = " + index));
            }
            Resource soln = s.getSubject();
            QuerySolution rb = this.buildBinding(soln);
            this.rows.add(rb);
            sIter.close();
            ++index;
        }
        if (this.rows.size() != count) {
            log.warn((Object)("Found " + this.rows.size() + ": expected " + count));
        }
    }

    private void buildRows(Resource root) {
        int count = 0;
        StmtIterator solnIter = root.listProperties(ResultSetGraphVocab.solution);
        while (solnIter.hasNext()) {
            Resource soln = solnIter.nextStatement().getResource();
            ++count;
            QuerySolution rb = this.buildBinding(soln);
            this.rows.add(rb);
        }
        solnIter.close();
        if (root.hasProperty(ResultSetGraphVocab.size)) {
            try {
                int size = root.getRequiredProperty(ResultSetGraphVocab.size).getInt();
                if (size != count) {
                    log.warn((Object)("Warning: Declared size = " + size + " : Count = " + count));
                }
            }
            catch (JenaException rdfEx) {
                // empty catch block
            }
        }
    }

    private QuerySolution buildBinding(Resource soln) {
        QuerySolutionMap rb = new QuerySolutionMap();
        StmtIterator bindingIter = soln.listProperties(ResultSetGraphVocab.binding);
        while (bindingIter.hasNext()) {
            Resource binding = bindingIter.nextStatement().getResource();
            String var = binding.getRequiredProperty(ResultSetGraphVocab.variable).getString();
            try {
                RDFNode val = binding.getRequiredProperty(ResultSetGraphVocab.value).getObject();
                rb.add(var, val);
            }
            catch (PropertyNotFoundException ex) {
                log.warn((Object)("Failed to get value for ?" + var));
            }
        }
        bindingIter.close();
        return rb;
    }
}

