/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.resultset;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.util.GraphUtils;
import com.hp.hpl.jena.query.vocabulary.ResultSetGraphVocab;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Iterator;

public class RDFOutput {
    boolean reportAllVars = false;

    public boolean getAllVars() {
        return this.reportAllVars;
    }

    public void setAllVars(boolean all) {
        this.reportAllVars = all;
    }

    public Model toModel(ResultSet resultSet) {
        Model m = GraphUtils.makeJenaDefaultModel();
        this.asRDF(m, resultSet);
        if (m.getNsPrefixURI("rs") == null) {
            m.setNsPrefix("rs", ResultSetGraphVocab.getURI());
        }
        if (m.getNsPrefixURI("rdf") == null) {
            m.setNsPrefix("rdf", RDF.getURI());
        }
        return m;
    }

    public Resource asRDF(Model model, ResultSet resultSet) {
        Resource results = model.createResource();
        results.addProperty(RDF.type, (RDFNode)ResultSetGraphVocab.ResultSet);
        Iterator iter = resultSet.getResultVars().iterator();
        while (iter.hasNext()) {
            String vName = (String)iter.next();
            results.addProperty(ResultSetGraphVocab.resultVariable, vName);
        }
        int count = 0;
        while (resultSet.hasNext()) {
            Iterator iter2;
            ++count;
            QuerySolution rBind = resultSet.nextSolution();
            Resource thisSolution = model.createResource();
            results.addProperty(ResultSetGraphVocab.solution, (RDFNode)thisSolution);
            Iterator iterator = iter2 = this.getAllVars() ? rBind.varNames() : resultSet.getResultVars().iterator();
            while (iter2.hasNext()) {
                Resource thisBinding = model.createResource();
                String rVar = (String)iter2.next();
                RDFNode n = rBind.get(rVar);
                if (n == null) continue;
                thisBinding.addProperty(ResultSetGraphVocab.variable, rVar);
                thisBinding.addProperty(ResultSetGraphVocab.value, n);
                thisSolution.addProperty(ResultSetGraphVocab.binding, (RDFNode)thisBinding);
                if (!resultSet.isOrdered()) continue;
                Literal i = model.createTypedLiteral(Integer.toString(count), (RDFDatatype)XSDDatatype.XSDinteger);
                thisSolution.addProperty(ResultSetGraphVocab.index, (RDFNode)i);
            }
        }
        return results;
    }

    public Model toModel(boolean result) {
        Model m = GraphUtils.makeJenaDefaultModel();
        this.asRDF(m, result);
        if (m.getNsPrefixURI("rs") == null) {
            m.setNsPrefix("rs", ResultSetGraphVocab.getURI());
        }
        if (m.getNsPrefixURI("rdf") == null) {
            m.setNsPrefix("rdf", RDF.getURI());
        }
        if (m.getNsPrefixURI("xsd") == null) {
            m.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        }
        return m;
    }

    public Resource asRDF(Model model, boolean result) {
        Resource results = model.createResource();
        results.addProperty(RDF.type, (RDFNode)ResultSetGraphVocab.ResultSet);
        Literal lit = model.createTypedLiteral(result);
        results.addProperty(ResultSetGraphVocab.p_boolean, (RDFNode)lit);
        return results;
    }
}

