/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.serializer;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBasicGraphPattern;
import com.hp.hpl.jena.query.core.ElementDataset;
import com.hp.hpl.jena.query.core.ElementExtension;
import com.hp.hpl.jena.query.core.ElementFilter;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.ElementNamedGraph;
import com.hp.hpl.jena.query.core.ElementOptional;
import com.hp.hpl.jena.query.core.ElementUnion;
import com.hp.hpl.jena.query.core.ElementUnsaid;
import com.hp.hpl.jena.query.core.Template;
import com.hp.hpl.jena.query.core.TemplateGroup;
import com.hp.hpl.jena.query.core.TemplateTriple;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.serializer.FmtExprARQ;
import com.hp.hpl.jena.query.serializer.FmtExprPrefix;
import com.hp.hpl.jena.query.serializer.FormatterBase;
import com.hp.hpl.jena.query.serializer.FormatterElement;
import com.hp.hpl.jena.query.serializer.FormatterTemplate;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.FmtUtils;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.query.util.IndentedWriter;
import java.util.Iterator;
import java.util.ListIterator;

public class FormatterPrefix
extends FormatterBase
implements FormatterElement,
FormatterTemplate {
    static int INDENT = 2;
    static final boolean closingBracketOnSameLine = true;
    static final boolean allowDoubles = true;
    protected String openMarker = "(";
    protected String closeMarker = ")";
    static final boolean hideBlocks = true;

    public FormatterPrefix(IndentedWriter out, SerializationContext context) {
        super(out, context);
    }

    public static void format(IndentedWriter out, SerializationContext cxt, Element el) {
        FormatterPrefix fmt = new FormatterPrefix(out, cxt);
        fmt.startVisit();
        el.visit(fmt);
        fmt.finishVisit();
    }

    public static String asString(Element el) {
        SerializationContext cxt = new SerializationContext();
        IndentedLineBuffer b = new IndentedLineBuffer();
        FormatterPrefix.format(b.getIndentedWriter(), cxt, el);
        return b.toString();
    }

    public boolean topMustBeGroup() {
        return false;
    }

    private void format(Triple t) {
        this.printOpen();
        this.out.print("triplepattern");
        this.out.print(" ");
        this.formatTriple(t);
        this.printClose();
    }

    public void visit(ElementBasicGraphPattern el) {
        this.printOpen();
        this.out.print("basicgraphpattern");
        this.out.incIndent(INDENT);
        ListIterator iter = el.getTriples().listIterator();
        while (iter.hasNext()) {
            this.out.newline();
            Triple t = (Triple)iter.next();
            this.format(t);
        }
        this.out.decIndent(INDENT);
        this.printClose();
    }

    public void visit(ElementDataset el) {
        el.getPatternElement().visit(this);
    }

    public void visit(ElementFilter el) {
        this.printOpen();
        this.out.print("filter");
        this.out.incIndent(INDENT);
        this.out.print(" ");
        FmtExprPrefix.format(this.out, this.context, el.getExpr());
        this.out.decIndent(INDENT);
        this.printClose();
    }

    public void visit(ElementUnion el) {
        this.multiElement("union", el.getElements().iterator());
    }

    public void visit(ElementGroup el) {
        this.multiElement("group", el.getElements().iterator());
    }

    public void visit(ElementOptional el) {
        this.singleElement("optional", el.getOptionalElement());
    }

    public void visit(ElementNamedGraph el) {
        this.printOpen();
        this.out.print("graph");
        this.out.print(" ");
        this.out.print(this.slotToString(this.context, el.getGraphNameNode()));
        this.out.incIndent(INDENT);
        this.out.newline();
        el.getElement().visit(this);
        this.out.decIndent(INDENT);
        this.printClose();
    }

    public void visit(ElementUnsaid el) {
        this.singleElement("unsaid", el.getElement());
    }

    public void visit(ElementExtension el) {
        Expr expr;
        this.printOpen();
        this.out.print("ext");
        this.out.print(" ");
        String uri = el.getURI();
        String tmp = FmtUtils.stringForURI(uri, this.context.getPrefixMapping());
        this.out.print(tmp);
        this.out.print("(");
        int i = 1;
        while ((expr = el.getArg(i)) != null) {
            if (i != 1) {
                this.out.print(", ");
            }
            FmtExprARQ v = new FmtExprARQ(this.out, this.context);
            expr.visit(v);
            ++i;
        }
        this.out.print(")");
        this.out.print(" )");
    }

    private void singleElement(String name, Element element) {
        this.printOpen();
        this.out.print(name);
        this.out.incIndent(INDENT);
        this.out.newline();
        element.visit(this);
        this.out.decIndent(INDENT);
        this.printClose();
    }

    private void doubleElement(String name, Element el_1, Element el_2) {
        this.printOpen();
        this.out.print(name);
        this.out.println();
        this.out.incIndent(INDENT);
        el_1.visit(this);
        this.out.newline();
        el_2.visit(this);
        this.out.decIndent(INDENT);
        this.printClose();
    }

    private void multiElement(String name, Iterator iter) {
        this.printOpen();
        this.out.print(name);
        this.out.incIndent(INDENT);
        while (iter.hasNext()) {
            this.out.newline();
            Element element = (Element)iter.next();
            element.visit(this);
        }
        this.out.decIndent(INDENT);
        this.printClose();
    }

    public void visit(TemplateTriple template) {
        this.printOpen();
        this.out.print("triplepattern");
        this.out.print(" ");
        this.formatTriple(template.getTriple());
        this.printClose();
    }

    public void visit(TemplateGroup tGroup) {
        this.printOpen();
        this.out.print("templategroup");
        this.out.incIndent(INDENT);
        Iterator iter = tGroup.templates();
        while (iter.hasNext()) {
            this.out.newline();
            Template sub = (Template)iter.next();
            sub.visit(this);
        }
        this.out.decIndent(INDENT);
        this.printClose();
    }

    private void printOpen() {
        this.out.print(this.openMarker);
    }

    private void printClose() {
        this.out.print(this.closeMarker);
    }
}

