/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.util;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.core.VarAlloc;
import java.util.HashMap;
import java.util.Map;

public class LabelToNodeMap {
    Map bNodeLabels = new HashMap();
    boolean generateVars = false;
    VarAlloc allocator = null;

    public LabelToNodeMap() {
        this(false);
    }

    public LabelToNodeMap(VarAlloc allocator) {
        this(false, allocator);
    }

    public LabelToNodeMap(boolean genVars) {
        this(genVars, VarAlloc.getBNodeAllocator());
        this.generateVars = genVars;
    }

    public LabelToNodeMap(boolean genVars, VarAlloc allocator) {
        this.generateVars = genVars;
        this.allocator = allocator;
    }

    public Node asNode(String label) {
        Node n = (Node)this.bNodeLabels.get(label);
        if (n != null) {
            return n;
        }
        n = this.allocNode();
        this.bNodeLabels.put(label, n);
        return n;
    }

    public Node allocNode() {
        if (this.generateVars) {
            return this.allocAnonVariable();
        }
        return Node.createAnon();
    }

    private Node allocAnonVariable() {
        return this.allocator.allocVar();
    }

    public void clear() {
        this.bNodeLabels.clear();
    }
}

