/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.util;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.util.StringUtils;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;

public class NodeUtils {
    public static boolean isStringLiteral(Node literal) {
        if (!literal.isLiteral()) {
            return false;
        }
        RDFDatatype dType = literal.getLiteralDatatype();
        String langTag = literal.getLiteralLanguage();
        if (langTag == null || !langTag.equals("")) {
            return false;
        }
        return dType == null || dType.equals(XSDDatatype.XSDstring);
    }

    public static String stringLiteral(Node literal) {
        if (!NodeUtils.isStringLiteral(literal)) {
            return null;
        }
        return literal.getLiteralLexicalForm();
    }

    public static boolean sameNode(Node node1, Node node2) {
        return node1.equals((Object)node2);
    }

    public static int compareRDFTerms(Node node1, Node node2) {
        if (node1 == null) {
            if (node2 == null) {
                return 0;
            }
            return -1;
        }
        if (node2 == null) {
            return 1;
        }
        if (node1.isLiteral() && node2.isLiteral()) {
            return NodeUtils.compareLiteralsBySyntax(node1, node2);
        }
        if (node1.isBlank()) {
            if (node2.isBlank()) {
                String s1 = node1.getBlankNodeId().getLabelString();
                String s2 = node2.getBlankNodeId().getLabelString();
                return StringUtils.strCompare(s1, s2);
            }
            return -1;
        }
        if (node2.isBlank()) {
            return 1;
        }
        if (node1.isURI()) {
            if (node2.isURI()) {
                String s1 = node1.getURI();
                String s2 = node2.getURI();
                return StringUtils.strCompare(s1, s2);
            }
            return -1;
        }
        if (node2.isURI()) {
            return 1;
        }
        throw new ARQInternalErrorException("Compare: " + node1 + "  " + node2);
    }

    private static int compareLiteralsBySyntax(Node node1, Node node2) {
        String lex2;
        if (node1 == null || !node1.isLiteral() || node2 == null || !node2.isLiteral()) {
            throw new ARQInternalErrorException("compareLiteralsBySyntax called with non-literal: (" + node1 + "," + node2 + ")");
        }
        if (node1.equals((Object)node2)) {
            return 0;
        }
        String lex1 = node1.getLiteralLexicalForm();
        int x = StringUtils.strCompare(lex1, lex2 = node2.getLiteralLexicalForm());
        if (x != 0) {
            return x;
        }
        String lang1 = node1.getLiteralLanguage();
        String lang2 = node2.getLiteralLanguage();
        String dt1 = node1.getLiteralDatatypeURI();
        String dt2 = node2.getLiteralDatatypeURI();
        if (lang1 == null) {
            throw new ARQInternalErrorException("Language tag is null: " + node1);
        }
        if (lang2 == null) {
            throw new ARQInternalErrorException("Language tag is null: " + node2);
        }
        if (NodeUtils.simpleLiteral(node1)) {
            return -1;
        }
        if (NodeUtils.simpleLiteral(node2)) {
            return 1;
        }
        if (!lang1.equals("") && dt2 != null) {
            return -1;
        }
        if (dt1 != null && !lang2.equals("")) {
            return 1;
        }
        if (dt1 == null && dt2 == null) {
            x = StringUtils.strCompareIgnoreCase(lang1, lang2);
            if (x != 0) {
                return x;
            }
            x = StringUtils.strCompare(lang1, lang2);
            if (x != 0) {
                return x;
            }
            throw new ARQInternalErrorException("compareLiteralsBySyntax: lexical form and languages tags identical on non.equals literals");
        }
        return StringUtils.strCompare(dt1, dt2);
    }

    private static boolean simpleLiteral(Node node) {
        return node.getLiteralDatatypeURI() == null && node.getLiteralLanguage().equals("");
    }

    public static RDFNode convertGraphNodeToRDFNode(Node n, Model model) {
        if (n.isVariable()) {
            throw new QueryException("Variable: " + n);
        }
        if (model != null) {
            return model.asRDFNode(n);
        }
        if (n.isLiteral()) {
            return new LiteralImpl(n, null);
        }
        if (n.isURI() || n.isBlank()) {
            return new ResourceImpl(n, null);
        }
        throw new ARQInternalErrorException("Unknown node type for node: " + n);
    }

    public static Node createLiteralNode(String lex, String lang, String datatypeURI) {
        if (datatypeURI != null && datatypeURI.equals("")) {
            datatypeURI = null;
        }
        if (lang != null && lang.equals("")) {
            lang = null;
        }
        RDFDatatype dType = null;
        if (datatypeURI != null) {
            dType = TypeMapper.getInstance().getSafeTypeByName(datatypeURI);
        }
        Node n = Node.createLiteral((String)lex, (String)lang, (RDFDatatype)dType);
        return n;
    }

    public static int nodeToInt(Node node) {
        LiteralLabel lit = node.getLiteral();
        if (!XSDDatatype.XSDinteger.isValidLiteral(lit)) {
            return -2;
        }
        int i = ((Number)lit.getValue()).intValue();
        return i;
    }

    public static Node intToNode(int integer) {
        return Node.createLiteral((String)Integer.toString(integer), (String)"", (RDFDatatype)XSDDatatype.XSDinteger);
    }
}

