/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.util;

import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import java.util.Iterator;
import java.util.Map;

public class PrefixMapping2
implements PrefixMapping {
    PrefixMapping pmapGlobal;
    PrefixMapping pmapLocal;

    public PrefixMapping2(PrefixMapping globalMapping, PrefixMapping localMapping) {
        this.pmapGlobal = globalMapping;
        this.pmapLocal = localMapping;
    }

    public PrefixMapping2(PrefixMapping globalMapping) {
        this(globalMapping, (PrefixMapping)new PrefixMappingImpl());
    }

    public PrefixMapping getLocalPrefixMapping() {
        return this.pmapLocal;
    }

    public PrefixMapping getGlobalPrefixMapping() {
        return this.pmapGlobal;
    }

    public void setLocalPrefixMapping(PrefixMapping x) {
        this.pmapLocal = x;
    }

    public void setGlobalPrefixMapping(PrefixMapping x) {
        this.pmapGlobal = x;
    }

    public PrefixMapping setNsPrefix(String prefix, String uri) {
        this.pmapLocal.setNsPrefix(prefix, uri);
        return this;
    }

    public PrefixMapping removeNsPrefix(String prefix) {
        this.pmapLocal.removeNsPrefix(prefix);
        if (this.pmapGlobal != null && this.pmapGlobal.getNsPrefixURI(prefix) != null) {
            throw new UnsupportedOperationException("PrefixMapping2: prefix '" + prefix + "' in the immutable map");
        }
        return this;
    }

    public PrefixMapping setNsPrefixes(PrefixMapping other) {
        this.pmapLocal.setNsPrefixes(other);
        return this;
    }

    public PrefixMapping setNsPrefixes(Map map) {
        this.pmapLocal.setNsPrefixes(map);
        return this;
    }

    public String getNsPrefixURI(String prefix) {
        String s = this.pmapLocal.getNsPrefixURI(prefix);
        if (s != null) {
            return s;
        }
        return this.pmapGlobal.getNsPrefixURI(prefix);
    }

    public String getNsURIPrefix(String uri) {
        String s = this.pmapLocal.getNsURIPrefix(uri);
        if (s != null) {
            return s;
        }
        if (this.pmapGlobal == null) {
            return null;
        }
        return this.pmapGlobal.getNsURIPrefix(uri);
    }

    public Map getNsPrefixMap() {
        return this.getNsPrefixMap(true);
    }

    public Map getNsPrefixMap(boolean includeGlobalMap) {
        Map m1 = this.pmapLocal.getNsPrefixMap();
        if (this.pmapGlobal == null) {
            return m1;
        }
        if (includeGlobalMap) {
            Map m2 = this.pmapGlobal.getNsPrefixMap();
            m1.putAll(m2);
        }
        return m1;
    }

    public String expandPrefix(String prefixed) {
        String s = this.pmapLocal.expandPrefix(prefixed);
        if (this.pmapGlobal == null) {
            return s;
        }
        if (s == null || s.equals(prefixed)) {
            s = this.pmapGlobal.expandPrefix(prefixed);
        }
        return s;
    }

    public String shortForm(String uri) {
        String s = this.pmapLocal.shortForm(uri);
        if (this.pmapGlobal == null) {
            return s;
        }
        if (s == null || s.equals(uri)) {
            s = this.pmapGlobal.shortForm(uri);
        }
        return s;
    }

    public String usePrefix(String uri) {
        String s = this.pmapLocal.qnameFor(uri);
        if (this.pmapGlobal == null) {
            return s;
        }
        if (s != null) {
            return s;
        }
        return this.pmapGlobal.qnameFor(uri);
    }

    public String qnameFor(String uri) {
        String s = this.pmapLocal.qnameFor(uri);
        if (this.pmapGlobal == null) {
            return s;
        }
        if (s != null) {
            return s;
        }
        return this.pmapGlobal.qnameFor(uri);
    }

    public PrefixMapping lock() {
        this.pmapLocal.lock();
        return this;
    }

    public PrefixMapping withDefaultMappings(PrefixMapping map) {
        Iterator it = map.getNsPrefixMap().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e2 = it.next();
            String prefix = (String)e2.getKey();
            String uri = (String)e2.getValue();
            if (this.getNsPrefixURI(prefix) != null || this.getNsURIPrefix(uri) != null) continue;
            this.setNsPrefix(prefix, uri);
        }
        return this;
    }

    public boolean samePrefixMappingAs(PrefixMapping other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof PrefixMapping2)) {
            return false;
        }
        PrefixMapping2 other2 = (PrefixMapping2)other;
        return this.pmapGlobal.samePrefixMappingAs(other2.pmapGlobal) && this.pmapLocal.samePrefixMappingAs(other2.pmapLocal);
    }
}

