/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.util;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.engine.Plan;
import com.hp.hpl.jena.query.engine.QueryEngineBase;
import com.hp.hpl.jena.query.engine2.QueryEngineQuad;
import com.hp.hpl.jena.query.engine2.QueryEngineRef;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.query.util.Utils;

public class QueryUtils {
    public static void printPlan(Query query) {
        QueryExecution qe = QueryExecutionFactory.create(query);
        QueryUtils._print(query, qe);
    }

    public static void printOp(Query query) {
        QueryEngineRef qe = new QueryEngineRef(query);
        QueryUtils._print(query, qe);
    }

    public static void printQuad(Query query) {
        QueryEngineQuad qe = new QueryEngineQuad(query);
        QueryUtils._print(query, qe);
    }

    private static void _print(Query query, QueryExecution qe) {
        if (qe instanceof QueryEngineBase) {
            Plan plan = ((QueryEngineBase)qe).getPlan();
            SerializationContext sCxt = new SerializationContext(query);
            IndentedWriter out = new IndentedWriter(System.out);
            plan.output(out, sCxt);
            out.flush();
            return;
        }
        System.err.println("printPlan: Unknown engine type: " + Utils.className(qe));
    }
}

